/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.AddExpr;
import com.xmlmind.xml.xpath.AlternativesPattern;
import com.xmlmind.xml.xpath.AncestorAxisExpr;
import com.xmlmind.xml.xpath.AncestorOrSelfAxisExpr;
import com.xmlmind.xml.xpath.AndExpr;
import com.xmlmind.xml.xpath.AnyNodeButAttrAndDocTest;
import com.xmlmind.xml.xpath.AttributeAxisExpr;
import com.xmlmind.xml.xpath.AttributeTest;
import com.xmlmind.xml.xpath.AxisExpr;
import com.xmlmind.xml.xpath.BooleanExpr;
import com.xmlmind.xml.xpath.BooleanFunction;
import com.xmlmind.xml.xpath.BooleanRelationalExpr;
import com.xmlmind.xml.xpath.CeilingFunction;
import com.xmlmind.xml.xpath.ChildAxisExpr;
import com.xmlmind.xml.xpath.ConcatFunction;
import com.xmlmind.xml.xpath.ContainsFunction;
import com.xmlmind.xml.xpath.Converter;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xml.xpath.CopyFunction;
import com.xmlmind.xml.xpath.CountFunction;
import com.xmlmind.xml.xpath.CurrentFunction;
import com.xmlmind.xml.xpath.DefinedFunction;
import com.xmlmind.xml.xpath.DescendantAxisExpr;
import com.xmlmind.xml.xpath.DescendantOrSelfAxisExpr;
import com.xmlmind.xml.xpath.DifferenceFunction;
import com.xmlmind.xml.xpath.DivideExpr;
import com.xmlmind.xml.xpath.DocumentFunction;
import com.xmlmind.xml.xpath.ElementAvailableFunction;
import com.xmlmind.xml.xpath.ElementTest;
import com.xmlmind.xml.xpath.EndsWithFunction;
import com.xmlmind.xml.xpath.EqualsRelation;
import com.xmlmind.xml.xpath.ExprTokenizer;
import com.xmlmind.xml.xpath.ExtensionFunctionCallExpr;
import com.xmlmind.xml.xpath.FalseFunction;
import com.xmlmind.xml.xpath.FilterExpr;
import com.xmlmind.xml.xpath.FilterPattern;
import com.xmlmind.xml.xpath.FloorFunction;
import com.xmlmind.xml.xpath.FollowingAxisExpr;
import com.xmlmind.xml.xpath.FollowingSiblingAxisExpr;
import com.xmlmind.xml.xpath.FormatNumberFunction;
import com.xmlmind.xml.xpath.Function;
import com.xmlmind.xml.xpath.FunctionAvailableFunction;
import com.xmlmind.xml.xpath.GenerateIdFunction;
import com.xmlmind.xml.xpath.GreaterThanEqualsRelation;
import com.xmlmind.xml.xpath.GreaterThanRelation;
import com.xmlmind.xml.xpath.IdFunction;
import com.xmlmind.xml.xpath.IdPattern;
import com.xmlmind.xml.xpath.IfFunction;
import com.xmlmind.xml.xpath.IndexOfNodeFunction;
import com.xmlmind.xml.xpath.InheritPattern;
import com.xmlmind.xml.xpath.IntersectionFunction;
import com.xmlmind.xml.xpath.IsEditableFunction;
import com.xmlmind.xml.xpath.JoinFunction;
import com.xmlmind.xml.xpath.KeyFunction;
import com.xmlmind.xml.xpath.LangFunction;
import com.xmlmind.xml.xpath.LastFunction;
import com.xmlmind.xml.xpath.LiteralExpr;
import com.xmlmind.xml.xpath.LocalNameFunction;
import com.xmlmind.xml.xpath.LowerCaseFunction;
import com.xmlmind.xml.xpath.MatchesFunction;
import com.xmlmind.xml.xpath.MaxFunction;
import com.xmlmind.xml.xpath.MinFunction;
import com.xmlmind.xml.xpath.ModuloExpr;
import com.xmlmind.xml.xpath.MultiplyExpr;
import com.xmlmind.xml.xpath.NameFunction;
import com.xmlmind.xml.xpath.NamespaceAttributeTest;
import com.xmlmind.xml.xpath.NamespaceElementTest;
import com.xmlmind.xml.xpath.NamespaceUriFunction;
import com.xmlmind.xml.xpath.NegateExpr;
import com.xmlmind.xml.xpath.NodeSetExpr;
import com.xmlmind.xml.xpath.NodeTestExpr;
import com.xmlmind.xml.xpath.NodeTypeTest;
import com.xmlmind.xml.xpath.NormalizeSpaceFunction;
import com.xmlmind.xml.xpath.NotEqualsRelation;
import com.xmlmind.xml.xpath.NotFunction;
import com.xmlmind.xml.xpath.NumberConstantExpr;
import com.xmlmind.xml.xpath.NumberExpr;
import com.xmlmind.xml.xpath.NumberFunction;
import com.xmlmind.xml.xpath.NumberRelationalExpr;
import com.xmlmind.xml.xpath.NumericRelation;
import com.xmlmind.xml.xpath.OrExpr;
import com.xmlmind.xml.xpath.ParentAxisExpr;
import com.xmlmind.xml.xpath.ParentPattern;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.PathPattern;
import com.xmlmind.xml.xpath.PathPatternBase;
import com.xmlmind.xml.xpath.Pattern;
import com.xmlmind.xml.xpath.PositionFunction;
import com.xmlmind.xml.xpath.PowFunction;
import com.xmlmind.xml.xpath.PrecedingAxisExpr;
import com.xmlmind.xml.xpath.PrecedingSiblingAxisExpr;
import com.xmlmind.xml.xpath.ProcessingInstructionTest;
import com.xmlmind.xml.xpath.PropertyFunction;
import com.xmlmind.xml.xpath.Relation;
import com.xmlmind.xml.xpath.RelativizeURIFunction;
import com.xmlmind.xml.xpath.ReplaceFunction;
import com.xmlmind.xml.xpath.ResolveURIFunction;
import com.xmlmind.xml.xpath.RootExpr;
import com.xmlmind.xml.xpath.RoundFunction;
import com.xmlmind.xml.xpath.SelfAxisExpr;
import com.xmlmind.xml.xpath.SerializeFunction;
import com.xmlmind.xml.xpath.SimpleFunction;
import com.xmlmind.xml.xpath.SimpleFunctionCallExpr;
import com.xmlmind.xml.xpath.SimpleFunctionTable;
import com.xmlmind.xml.xpath.StartsWithFunction;
import com.xmlmind.xml.xpath.StringExpr;
import com.xmlmind.xml.xpath.StringFunction;
import com.xmlmind.xml.xpath.StringLengthFunction;
import com.xmlmind.xml.xpath.StringRelationalExpr;
import com.xmlmind.xml.xpath.SubstringAfterFunction;
import com.xmlmind.xml.xpath.SubstringBeforeFunction;
import com.xmlmind.xml.xpath.SubstringFunction;
import com.xmlmind.xml.xpath.SubtractExpr;
import com.xmlmind.xml.xpath.SumFunction;
import com.xmlmind.xml.xpath.SystemPropertyFunction;
import com.xmlmind.xml.xpath.TokenizeFunction;
import com.xmlmind.xml.xpath.TranslateFunction;
import com.xmlmind.xml.xpath.TrueFunction;
import com.xmlmind.xml.xpath.URIOrFileNameFunction;
import com.xmlmind.xml.xpath.URIToFileNameFunction;
import com.xmlmind.xml.xpath.UnexpectedTokenException;
import com.xmlmind.xml.xpath.UnionExpr;
import com.xmlmind.xml.xpath.UnparsedEntityURIFunction;
import com.xmlmind.xml.xpath.UpperCaseFunction;
import com.xmlmind.xml.xpath.VariableRefExpr;
import com.xmlmind.xml.xpath.VariantExpr;
import com.xmlmind.xml.xpath.VariantRelationalExpr;
import com.xmlmind.xml.xpath.WithCurrentExpr;
import java.util.HashMap;
import java.util.IdentityHashMap;

public class ExprParser
extends ExprTokenizer {
    private PrefixToNamespace prefixToNS;
    private boolean allowDefaultNS;
    private boolean usesCurrentFunction = false;
    private static final HashMap<String, AxisExpr> axisTable = new HashMap();
    private static final AxisExpr childAxis = new ChildAxisExpr();
    private static final AxisExpr parentAxis = new ParentAxisExpr();
    private static final AxisExpr selfAxis = new SelfAxisExpr();
    private static final AxisExpr attributeAxis = new AttributeAxisExpr();
    private static final AxisExpr descendantOrSelfAxis = new DescendantOrSelfAxisExpr();
    private static final HashMap<String, Function> functionTable = new HashMap();
    private static final IdentityHashMap<Namespace, SimpleFunctionTable> simpleFunctionTables = new IdentityHashMap();
    private static final Relation equalsRelation = new EqualsRelation();
    private static final Relation notEqualsRelation = new NotEqualsRelation();
    private static final Relation greaterThanEqualsRelation = new GreaterThanEqualsRelation();
    private static final Relation greaterThanRelation = new GreaterThanRelation();
    private static final Function currentFunction = new CurrentFunction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSimpleFunctionTable(Namespace namespace, SimpleFunctionTable simpleFunctionTable) {
        IdentityHashMap<Namespace, SimpleFunctionTable> identityHashMap = simpleFunctionTables;
        synchronized (identityHashMap) {
            if (simpleFunctionTable == null) {
                simpleFunctionTables.remove(namespace);
            } else {
                simpleFunctionTables.put(namespace, simpleFunctionTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFunctionTable getSimpleFunctionTable(Namespace namespace) {
        IdentityHashMap<Namespace, SimpleFunctionTable> identityHashMap = simpleFunctionTables;
        synchronized (identityHashMap) {
            return simpleFunctionTables.get(namespace);
        }
    }

    public static boolean isFunctionAvailable(Name name) {
        Namespace namespace = name.namespace;
        String string = name.localPart;
        if (namespace == Namespace.NONE && (functionTable.containsKey(string) || "current".equals(string))) {
            return true;
        }
        SimpleFunctionTable simpleFunctionTable = ExprParser.getSimpleFunctionTable(namespace);
        if (simpleFunctionTable == null) {
            return false;
        }
        return simpleFunctionTable.getSimpleFunction(string) != null;
    }

    public static NodeSetExpr parseNodeSetExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace).makeNodeSetExpr();
    }

    public static StringExpr parseStringExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace).makeStringExpr();
    }

    public static NumberExpr parseNumberExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace).makeNumberExpr();
    }

    public static BooleanExpr parseBooleanExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace).makeBooleanExpr();
    }

    public static VariantExpr parseVariantExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return ExprParser.parseConvertibleExpr(string, prefixToNamespace).makeVariantExpr();
    }

    private static ConvertibleExpr parseConvertibleExpr(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return new ExprParser(string, 0, string.length(), prefixToNamespace).parseExpr();
    }

    public ExprParser(String string, int n, int n2, PrefixToNamespace prefixToNamespace) {
        super(string, n, n2);
        this.prefixToNS = prefixToNamespace;
    }

    public void setAllowDefaultNS(boolean bl) {
        this.allowDefaultNS = bl;
    }

    public boolean getAllowDefaultNS() {
        return this.allowDefaultNS;
    }

    public NodeSetExpr parseNodeSetExpr() throws ParseException {
        return this.parseExpr().makeNodeSetExpr();
    }

    public StringExpr parseStringExpr() throws ParseException {
        return this.parseExpr().makeStringExpr();
    }

    public NumberExpr parseNumberExpr() throws ParseException {
        return this.parseExpr().makeNumberExpr();
    }

    public BooleanExpr parseBooleanExpr() throws ParseException {
        return this.parseExpr().makeBooleanExpr();
    }

    public VariantExpr parseVariantExpr() throws ParseException {
        return this.parseExpr().makeVariantExpr();
    }

    private ConvertibleExpr parseExpr() throws ParseException {
        this.next();
        ConvertibleExpr convertibleExpr = this.parseOrExpr();
        if (this.currentToken != 0) {
            throw new UnexpectedTokenException();
        }
        if (this.usesCurrentFunction) {
            return new WithCurrentExpr(convertibleExpr);
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseOrExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseAndExpr();
        while (this.currentToken == 35) {
            this.next();
            convertibleExpr = new OrExpr(convertibleExpr.makeBooleanExpr(), this.parseAndExpr().makeBooleanExpr());
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseAndExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseEqualityExpr();
        while (this.currentToken == 34) {
            this.next();
            convertibleExpr = new AndExpr(convertibleExpr.makeBooleanExpr(), this.parseEqualityExpr().makeBooleanExpr());
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseEqualityExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseRelationalExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 28: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(equalsRelation, convertibleExpr, this.parseRelationalExpr());
                    continue block4;
                }
                case 29: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(notEqualsRelation, convertibleExpr, this.parseRelationalExpr());
                    continue block4;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseRelationalExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseAdditiveExpr();
        block6: while (true) {
            switch (this.currentToken) {
                case 30: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanRelation, convertibleExpr, this.parseAdditiveExpr());
                    continue block6;
                }
                case 32: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanEqualsRelation, convertibleExpr, this.parseAdditiveExpr());
                    continue block6;
                }
                case 31: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanRelation, this.parseAdditiveExpr(), convertibleExpr);
                    continue block6;
                }
                case 33: {
                    this.next();
                    convertibleExpr = this.makeRelationalExpr(greaterThanEqualsRelation, this.parseAdditiveExpr(), convertibleExpr);
                    continue block6;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseAdditiveExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 26: {
                    this.next();
                    convertibleExpr = new AddExpr(convertibleExpr.makeNumberExpr(), this.parseMultiplicativeExpr().makeNumberExpr());
                    continue block4;
                }
                case 27: {
                    this.next();
                    convertibleExpr = new SubtractExpr(convertibleExpr.makeNumberExpr(), this.parseMultiplicativeExpr().makeNumberExpr());
                    continue block4;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseMultiplicativeExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 37: {
                    this.next();
                    convertibleExpr = new DivideExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
                case 36: {
                    this.next();
                    convertibleExpr = new ModuloExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
                case 11: {
                    this.next();
                    convertibleExpr = new MultiplyExpr(convertibleExpr.makeNumberExpr(), this.parseUnaryExpr().makeNumberExpr());
                    continue block5;
                }
            }
            break;
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parseUnaryExpr() throws ParseException {
        if (this.currentToken == 27) {
            this.next();
            return new NegateExpr(this.parseUnaryExpr().makeNumberExpr());
        }
        return this.parseUnionExpr();
    }

    private ConvertibleExpr parseUnionExpr() throws ParseException {
        ConvertibleExpr convertibleExpr = this.parsePathExpr();
        while (this.currentToken == 24) {
            this.next();
            convertibleExpr = new UnionExpr(convertibleExpr.makeNodeSetExpr(), this.parsePathExpr().makeNodeSetExpr());
        }
        return convertibleExpr;
    }

    private ConvertibleExpr parsePathExpr() throws ParseException {
        if (this.tokenStartsStep()) {
            return this.parseRelativeLocationPath();
        }
        if (this.currentToken == 22) {
            this.next();
            if (this.tokenStartsStep()) {
                return new RootExpr(this.parseRelativeLocationPath());
            }
            return new RootExpr(selfAxis);
        }
        if (this.currentToken == 23) {
            this.next();
            return new RootExpr(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        ConvertibleExpr convertibleExpr = this.parsePrimaryExpr();
        while (this.currentToken == 14) {
            this.next();
            convertibleExpr = new FilterExpr(convertibleExpr.makeNodeSetExpr(), this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        if (this.currentToken == 22) {
            this.next();
            return convertibleExpr.makeNodeSetExpr().compose(this.parseRelativeLocationPath());
        }
        if (this.currentToken == 23) {
            this.next();
            return convertibleExpr.makeNodeSetExpr().compose(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        return convertibleExpr;
    }

    private ConvertibleNodeSetExpr parseRelativeLocationPath() throws ParseException {
        ConvertibleNodeSetExpr convertibleNodeSetExpr = this.parseStep();
        if (this.currentToken == 22) {
            this.next();
            return convertibleNodeSetExpr.compose(this.parseRelativeLocationPath());
        }
        if (this.currentToken == 23) {
            this.next();
            return convertibleNodeSetExpr.compose(descendantOrSelfAxis.compose(this.parseRelativeLocationPath()));
        }
        return convertibleNodeSetExpr;
    }

    private ConvertibleNodeSetExpr parseStep() throws ParseException {
        switch (this.currentToken) {
            case 18: {
                AxisExpr axisExpr = axisTable.get(this.currentTokenValue);
                if (axisExpr == null) {
                    throw new ParseException("no such axis");
                }
                boolean bl = this.currentTokenValue.equals("attribute");
                this.next();
                return this.parsePredicates(axisExpr, this.parseNodeTest(bl));
            }
            case 5: {
                this.next();
                return selfAxis;
            }
            case 6: {
                this.next();
                return parentAxis;
            }
            case 4: {
                this.next();
                return this.parsePredicates(attributeAxis, this.parseNodeTest(true));
            }
        }
        return this.parsePredicates(childAxis, this.parseNodeTest(false));
    }

    private ConvertibleNodeSetExpr parsePredicates(AxisExpr axisExpr, Pattern pattern) throws ParseException {
        ConvertibleNodeSetExpr convertibleNodeSetExpr = axisExpr;
        if (pattern != null) {
            convertibleNodeSetExpr = new NodeTestExpr(convertibleNodeSetExpr, pattern);
        }
        while (this.currentToken == 14) {
            this.next();
            convertibleNodeSetExpr = new FilterExpr(convertibleNodeSetExpr, this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        return axisExpr.makeDocumentOrderExpr(convertibleNodeSetExpr);
    }

    private PathPatternBase parseNodeTest(boolean bl) throws ParseException {
        PathPatternBase pathPatternBase;
        switch (this.currentToken) {
            case 1: {
                if (bl) {
                    pathPatternBase = new AttributeTest(this.expandName(false));
                    break;
                }
                pathPatternBase = new ElementTest(this.expandName(true));
                break;
            }
            case 2: {
                pathPatternBase = bl ? null : new NodeTypeTest(XNode.Type.ELEMENT);
                break;
            }
            case 3: {
                if (bl) {
                    pathPatternBase = new NamespaceAttributeTest(this.expandPrefix());
                    break;
                }
                pathPatternBase = new NamespaceElementTest(this.expandPrefix());
                break;
            }
            case 8: {
                PathPatternBase pathPatternBase2;
                this.next();
                if (this.currentToken == 16) {
                    pathPatternBase2 = new ProcessingInstructionTest(this.expandName(false));
                    this.next();
                } else {
                    pathPatternBase2 = new NodeTypeTest(XNode.Type.PROCESSING_INSTRUCTION);
                }
                this.expectRpar();
                return pathPatternBase2;
            }
            case 7: {
                this.next();
                this.expectRpar();
                return new NodeTypeTest(XNode.Type.COMMENT);
            }
            case 9: {
                this.next();
                this.expectRpar();
                return new NodeTypeTest(XNode.Type.TEXT);
            }
            case 10: {
                this.next();
                this.expectRpar();
                return null;
            }
            default: {
                throw new ParseException("expected node test");
            }
        }
        this.next();
        return pathPatternBase;
    }

    private final void expectRpar() throws ParseException {
        if (this.currentToken != 13) {
            throw new ParseException("expected )");
        }
        this.next();
    }

    private final void expectRsqb() throws ParseException {
        if (this.currentToken != 15) {
            throw new ParseException("expected ]");
        }
        this.next();
    }

    private ConvertibleExpr parsePrimaryExpr() throws ParseException {
        ConvertibleExpr convertibleExpr;
        switch (this.currentToken) {
            case 21: {
                convertibleExpr = new VariableRefExpr(this.expandName(false));
                break;
            }
            case 12: {
                this.next();
                ConvertibleExpr convertibleExpr2 = this.parseOrExpr();
                this.expectRpar();
                return convertibleExpr2;
            }
            case 16: {
                convertibleExpr = new LiteralExpr(this.currentTokenValue);
                break;
            }
            case 17: {
                convertibleExpr = new NumberConstantExpr(Converter.toNumber(this.currentTokenValue));
                break;
            }
            case 19: {
                String string = this.currentTokenValue;
                this.next();
                Function function = functionTable.get(string);
                if (function == null && "current".equals(string)) {
                    this.usesCurrentFunction = true;
                    function = currentFunction;
                }
                if (function != null) {
                    return function.makeCallExpr(this.parseArgs(), this.prefixToNS);
                }
                return this.makeSimpleFunctionCallExpr(Namespace.NONE, string);
            }
            case 20: {
                Name name = this.expandName(false);
                this.next();
                Namespace namespace = name.namespace;
                if (namespace.uri.startsWith("java:")) {
                    ConvertibleExpr[] convertibleExprArray = this.parseArgs();
                    int n = convertibleExprArray.length;
                    VariantExpr[] variantExprArray = new VariantExpr[n];
                    for (int i = 0; i < n; ++i) {
                        variantExprArray[i] = convertibleExprArray[i].makeVariantExpr();
                    }
                    return new ExtensionFunctionCallExpr(name, variantExprArray);
                }
                return this.makeSimpleFunctionCallExpr(namespace, name.localPart);
            }
            default: {
                throw new ParseException("syntax error");
            }
        }
        this.next();
        return convertibleExpr;
    }

    SimpleFunctionCallExpr makeSimpleFunctionCallExpr(Namespace namespace, String string) throws ParseException {
        SimpleFunction simpleFunction = null;
        SimpleFunctionTable simpleFunctionTable = ExprParser.getSimpleFunctionTable(namespace);
        if (simpleFunctionTable != null) {
            simpleFunction = simpleFunctionTable.getSimpleFunction(string);
        }
        if (simpleFunction == null) {
            throw new ParseException("no such function: " + Name.get(namespace, string).toString());
        }
        ConvertibleExpr[] convertibleExprArray = this.parseArgs();
        int n = convertibleExprArray.length;
        VariantExpr[] variantExprArray = new VariantExpr[n];
        for (int i = 0; i < n; ++i) {
            variantExprArray[i] = convertibleExprArray[i].makeVariantExpr();
        }
        return new SimpleFunctionCallExpr(simpleFunction.getObject(), simpleFunction.getMethod(), variantExprArray);
    }

    ConvertibleExpr[] parseArgs() throws ParseException {
        if (this.currentToken == 13) {
            this.next();
            return new ConvertibleExpr[0];
        }
        ConvertibleExpr[] convertibleExprArray = new ConvertibleExpr[1];
        while (true) {
            convertibleExprArray[convertibleExprArray.length - 1] = this.parseOrExpr();
            if (this.currentToken != 25) break;
            this.next();
            ConvertibleExpr[] convertibleExprArray2 = convertibleExprArray;
            convertibleExprArray = new ConvertibleExpr[convertibleExprArray2.length + 1];
            System.arraycopy(convertibleExprArray2, 0, convertibleExprArray, 0, convertibleExprArray2.length);
        }
        this.expectRpar();
        return convertibleExprArray;
    }

    private boolean tokenStartsNodeTest() {
        switch (this.currentToken) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private boolean tokenStartsStep() {
        switch (this.currentToken) {
            case 4: 
            case 5: 
            case 6: 
            case 18: {
                return true;
            }
        }
        return this.tokenStartsNodeTest();
    }

    private Name expandName(boolean bl) throws ParseException {
        boolean bl2 = !bl || !this.allowDefaultNS;
        Name name = Name.parse(this.currentTokenValue, bl2, this.prefixToNS);
        if (name == null) {
            throw new ParseException("'" + this.currentTokenValue + "' malformed name or undefined prefix");
        }
        return name;
    }

    private Namespace expandPrefix() throws ParseException {
        Namespace namespace = null;
        if (this.prefixToNS == null) {
            if ("".equals(this.currentTokenValue)) {
                namespace = Namespace.NONE;
            } else if ("xml".equals(this.currentTokenValue)) {
                namespace = Namespace.XML;
            }
        } else {
            namespace = this.prefixToNS.prefixToNamespace(this.currentTokenValue);
        }
        if (namespace == null) {
            throw new ParseException("undefined prefix '" + this.currentTokenValue + "'");
        }
        return namespace;
    }

    ConvertibleExpr makeRelationalExpr(Relation relation, ConvertibleExpr convertibleExpr, ConvertibleExpr convertibleExpr2) throws ParseException {
        if (convertibleExpr instanceof NodeSetExpr || convertibleExpr2 instanceof NodeSetExpr || convertibleExpr instanceof VariantExpr || convertibleExpr2 instanceof VariantExpr) {
            return new VariantRelationalExpr(relation, convertibleExpr.makeVariantExpr(), convertibleExpr2.makeVariantExpr());
        }
        if (relation instanceof NumericRelation) {
            return new NumberRelationalExpr(relation, convertibleExpr.makeNumberExpr(), convertibleExpr2.makeNumberExpr());
        }
        if (convertibleExpr instanceof BooleanExpr || convertibleExpr2 instanceof BooleanExpr) {
            return new BooleanRelationalExpr(relation, convertibleExpr.makeBooleanExpr(), convertibleExpr2.makeBooleanExpr());
        }
        if (convertibleExpr instanceof NumberExpr || convertibleExpr2 instanceof NumberExpr) {
            return new NumberRelationalExpr(relation, convertibleExpr.makeNumberExpr(), convertibleExpr2.makeNumberExpr());
        }
        return new StringRelationalExpr(relation, convertibleExpr.makeStringExpr(), convertibleExpr2.makeStringExpr());
    }

    public static PathPattern parsePattern(String string, PrefixToNamespace prefixToNamespace) throws ParseException {
        return new ExprParser(string, 0, string.length(), prefixToNamespace).parseTopLevelPattern();
    }

    public PathPattern parseTopLevelPattern() throws ParseException {
        this.next();
        PathPattern pathPattern = this.parsePathPattern();
        while (this.currentToken == 24) {
            this.next();
            pathPattern = new AlternativesPattern(pathPattern, this.parsePathPattern());
        }
        if (this.currentToken != 0) {
            throw new UnexpectedTokenException();
        }
        if (this.usesCurrentFunction) {
            throw new ParseException("current() in match pattern");
        }
        return pathPattern;
    }

    private PathPatternBase parsePathPattern() throws ParseException {
        PathPatternBase pathPatternBase;
        Pattern pattern = null;
        switch (this.currentToken) {
            case 23: {
                this.next();
                break;
            }
            case 22: {
                this.next();
                if (!this.tokenStartsStep()) {
                    return new NodeTypeTest(XNode.Type.DOCUMENT);
                }
                pattern = new NodeTypeTest(XNode.Type.DOCUMENT);
                break;
            }
            case 19: {
                if (this.currentTokenValue.equals("id")) {
                    this.next();
                    if (this.currentToken != 16) {
                        throw new ParseException("expected literal");
                    }
                    pathPatternBase = new IdPattern(this.currentTokenValue);
                    this.next();
                    this.expectRpar();
                    if (this.currentToken == 22) {
                        pattern = pathPatternBase;
                    } else if (this.currentToken == 23) {
                        pattern = new InheritPattern(pathPatternBase);
                    } else {
                        return pathPatternBase;
                    }
                    this.next();
                    break;
                }
                throw new ParseException("function illegal in pattern");
            }
        }
        while (true) {
            pathPatternBase = this.parseStepPattern();
            if (pattern != null) {
                pathPatternBase = new ParentPattern(pathPatternBase, pattern);
            }
            if (this.currentToken == 22) {
                pattern = pathPatternBase;
            } else if (this.currentToken == 23) {
                pattern = new InheritPattern(pathPatternBase);
            } else {
                return pathPatternBase;
            }
            this.next();
        }
    }

    private PathPatternBase parseStepPattern() throws ParseException {
        PathPatternBase pathPatternBase;
        if (this.currentToken == 4 || this.currentToken == 18 && this.currentTokenValue.equals("attribute")) {
            this.next();
            pathPatternBase = this.parseNodeTest(true);
            if (pathPatternBase == null) {
                pathPatternBase = new NodeTypeTest(XNode.Type.ATTRIBUTE);
            }
        } else {
            if (this.currentToken == 18 && this.currentTokenValue.equals("child")) {
                this.next();
            }
            if ((pathPatternBase = this.parseNodeTest(false)) == null) {
                pathPatternBase = new AnyNodeButAttrAndDocTest();
            }
        }
        while (this.currentToken == 14) {
            this.next();
            pathPatternBase = new FilterPattern(pathPatternBase, this.parseOrExpr().makePredicateExpr());
            this.expectRsqb();
        }
        return pathPatternBase;
    }

    static {
        axisTable.put("child", childAxis);
        axisTable.put("parent", parentAxis);
        axisTable.put("self", selfAxis);
        axisTable.put("attribute", attributeAxis);
        axisTable.put("descendant-or-self", descendantOrSelfAxis);
        axisTable.put("descendant", new DescendantAxisExpr());
        axisTable.put("ancestor-or-self", new AncestorOrSelfAxisExpr());
        axisTable.put("ancestor", new AncestorAxisExpr());
        axisTable.put("following-sibling", new FollowingSiblingAxisExpr());
        axisTable.put("preceding-sibling", new PrecedingSiblingAxisExpr());
        axisTable.put("following", new FollowingAxisExpr());
        axisTable.put("preceding", new PrecedingAxisExpr());
        functionTable.put("boolean", new BooleanFunction());
        functionTable.put("ceiling", new CeilingFunction());
        functionTable.put("concat", new ConcatFunction());
        functionTable.put("contains", new ContainsFunction());
        functionTable.put("count", new CountFunction());
        functionTable.put("document", new DocumentFunction());
        functionTable.put("false", new FalseFunction());
        functionTable.put("floor", new FloorFunction());
        functionTable.put("format-number", new FormatNumberFunction());
        functionTable.put("id", new IdFunction());
        functionTable.put("lang", new LangFunction());
        functionTable.put("last", new LastFunction());
        functionTable.put("local-name", new LocalNameFunction());
        functionTable.put("namespace-uri", new NamespaceUriFunction());
        functionTable.put("normalize-space", new NormalizeSpaceFunction());
        functionTable.put("not", new NotFunction());
        functionTable.put("number", new NumberFunction());
        functionTable.put("position", new PositionFunction());
        functionTable.put("name", new NameFunction());
        functionTable.put("round", new RoundFunction());
        functionTable.put("starts-with", new StartsWithFunction());
        functionTable.put("string", new StringFunction());
        functionTable.put("string-length", new StringLengthFunction());
        functionTable.put("substring", new SubstringFunction());
        functionTable.put("substring-after", new SubstringAfterFunction());
        functionTable.put("substring-before", new SubstringBeforeFunction());
        functionTable.put("sum", new SumFunction());
        functionTable.put("translate", new TranslateFunction());
        functionTable.put("true", new TrueFunction());
        functionTable.put("intersection", new IntersectionFunction());
        functionTable.put("difference", new DifferenceFunction());
        functionTable.put("key", new KeyFunction());
        functionTable.put("system-property", new SystemPropertyFunction());
        functionTable.put("unparsed-entity-uri", new UnparsedEntityURIFunction());
        functionTable.put("generate-id", new GenerateIdFunction());
        functionTable.put("function-available", new FunctionAvailableFunction());
        functionTable.put("element-available", new ElementAvailableFunction());
        functionTable.put("copy", new CopyFunction());
        functionTable.put("resolve-uri", new ResolveURIFunction());
        functionTable.put("relativize-uri", new RelativizeURIFunction());
        functionTable.put("uri-to-file-name", new URIToFileNameFunction());
        functionTable.put("uri-or-file-name", new URIOrFileNameFunction());
        functionTable.put("if", new IfFunction());
        functionTable.put("min", new MinFunction());
        functionTable.put("max", new MaxFunction());
        functionTable.put("pow", new PowFunction());
        functionTable.put("join", new JoinFunction());
        functionTable.put("tokenize", new TokenizeFunction());
        functionTable.put("replace", new ReplaceFunction());
        functionTable.put("matches", new MatchesFunction());
        functionTable.put("index-of-node", new IndexOfNodeFunction());
        functionTable.put("property", new PropertyFunction());
        functionTable.put("is-editable", new IsEditableFunction());
        functionTable.put("ends-with", new EndsWithFunction());
        functionTable.put("serialize", new SerializeFunction());
        functionTable.put("lower-case", new LowerCaseFunction());
        functionTable.put("upper-case", new UpperCaseFunction());
        functionTable.put("defined", new DefinedFunction());
    }
}

