/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.load.DocumentCache;
import com.xmlmind.xml.load.DocumentManager;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import com.xmlmind.xml.validate.IdEntry;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NullNodeIterator;
import com.xmlmind.xml.xpath.OutermostExprContext;
import com.xmlmind.xml.xpath.SingleNodeIterator;
import com.xmlmind.xml.xpath.Variant;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ExprContextImpl
extends OutermostExprContext {
    protected final IdentityLinearHashtable<Name, Variant> globalVariables;
    protected DocumentManager documentManager;
    protected IdentityLinearHashtable<Document, Map<String, IdEntry>> idMaps;
    protected static final HashMap<String, IdEntry> EMPTY_ID_MAP = new HashMap(1);
    protected static final String ID_MAP_PROP = "com.xmlmind.xml.xpath.ExprContextImpl.idMap";

    public ExprContextImpl() {
        this(DocumentCache.getCache());
    }

    public ExprContextImpl(DocumentManager documentManager) {
        this.setDocumentManager(documentManager);
        this.globalVariables = new IdentityLinearHashtable();
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public Variant setGlobalVariable(Name name, Variant variant) {
        if (variant == null) {
            return this.globalVariables.remove(name);
        }
        return this.globalVariables.put(name, variant);
    }

    public Variant getGlobalVariable(Name name, XNode xNode) throws EvalException {
        return this.globalVariables.get(name);
    }

    @Override
    public Variant getVariableValue(Name name, XNode xNode) throws EvalException {
        return this.getGlobalVariable(name, xNode);
    }

    public void reset() {
        this.globalVariables.clear();
        this.idMaps = null;
    }

    @Override
    public XNode findElementWithId(XNode xNode, String string) throws EvalException {
        Map<String, IdEntry> map = this.getIdMap(xNode);
        IdEntry idEntry = map.get(string);
        return idEntry == null ? null : idEntry.elements[0];
    }

    @Override
    public boolean isElementWithId(XNode xNode, String string) throws EvalException {
        Map<String, IdEntry> map = this.getIdMap(xNode);
        IdEntry idEntry = map.get(string);
        return idEntry == null ? false : idEntry.elements[0] == xNode;
    }

    protected Map<String, IdEntry> getIdMap(XNode xNode) {
        Map<Object, Object> map;
        XNode xNode2 = xNode.document();
        if (xNode2 == null || !(xNode2 instanceof Document)) {
            return EMPTY_ID_MAP;
        }
        Document document = (Document)xNode2;
        if (this.idMaps == null) {
            this.idMaps = new IdentityLinearHashtable(3);
        }
        if ((map = this.idMaps.get(document)) == null) {
            URL uRL;
            DocumentCache.Entry entry = null;
            if (this.documentManager != null && this.documentManager instanceof DocumentCache && (uRL = document.getSourceURL()) != null && (entry = ((DocumentCache)this.documentManager).fetchEntry(uRL)) != null && entry.document != document) {
                entry = null;
            }
            if (map == null) {
                map = entry != null ? (Map<Object, Object>)entry.addProperty(ID_MAP_PROP, () -> this.doGetIdMap(document)) : this.doGetIdMap(document);
            }
            this.idMaps.put(document, map);
        }
        return map;
    }

    protected Map<String, IdEntry> doGetIdMap(Document document) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(document);
        if (documentType == null) {
            documentType = AnyDocumentType.INSTANCE;
        }
        HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
        DocumentTypeUtil.collectIds(documentType, document.getRootElement(), hashMap);
        return hashMap;
    }

    @Override
    public NodeIterator getDocument(String string, URL uRL) throws EvalException {
        if (this.documentManager == null) {
            return NullNodeIterator.INSTANCE;
        }
        URL uRL2 = this.resolveDocumentURL(string, uRL);
        String string2 = URLUtil.getFragment(uRL2);
        if (string2 != null) {
            uRL2 = URLUtil.setFragment(uRL2, null);
        }
        Document document = null;
        try {
            document = this.documentManager.getDocument(uRL2);
        }
        catch (IOException iOException) {
            throw new EvalException("cannot load document '" + String.valueOf(uRL2) + "': " + ThrowableUtil.reason(iOException));
        }
        if (document == null) {
            return NullNodeIterator.INSTANCE;
        }
        if (string2 == null) {
            return new SingleNodeIterator(document);
        }
        XNode xNode = this.findNodeByFragment(document, string2);
        if (xNode == null) {
            throw new EvalException("node specified by fragment '" + string2 + "' is not found in '" + String.valueOf(uRL2) + "'");
        }
        return new SingleNodeIterator(xNode);
    }

    protected URL resolveDocumentURL(String string, URL uRL) throws EvalException {
        try {
            return XMLCatalogs.resolveURI(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new EvalException("malformed URL uriRef='" + string + "', baseURL='" + String.valueOf(uRL) + "': " + ThrowableUtil.reason(malformedURLException));
        }
    }

    protected XNode findNodeByFragment(Document document, String string) throws EvalException {
        return this.findElementWithId(document, string);
    }
}

