/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xinclude;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.InclusionException;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.load.Includable;
import com.xmlmind.xml.load.SimpleInclusion;
import com.xmlmind.xml.load.SimpleInclusionScheme;
import com.xmlmind.xml.load.XInclusion;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import com.xmlmind.xml.validate.IdEntry;
import com.xmlmind.xml.xinclude.XInclude;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public final class XIncludeScheme
implements SimpleInclusionScheme {
    public static final XIncludeScheme INSTANCE = new XIncludeScheme();
    public static final SimpleInclusionScheme[] AS_LIST = new SimpleInclusionScheme[]{INSTANCE};
    private Attribute[] copiedAttributesWhenMultipleInstances;
    private Attribute[] copiedAttributes;

    public void setCopiedAttributesWhenMultipleInstances(String string) throws IllegalArgumentException {
        this.setCopiedAttributesWhenMultipleInstances(XIncludeScheme.parseAttributes(string));
    }

    public void setCopiedAttributesWhenMultipleInstances(Attribute[] attributeArray) {
        if (attributeArray != null && attributeArray.length == 0) {
            attributeArray = null;
        }
        this.copiedAttributesWhenMultipleInstances = attributeArray;
    }

    public void setCopiedAttributes(String string) throws IllegalArgumentException {
        this.setCopiedAttributes(XIncludeScheme.parseAttributes(string));
    }

    public void setCopiedAttributes(Attribute[] attributeArray) {
        if (attributeArray != null && attributeArray.length == 0) {
            attributeArray = null;
        }
        this.copiedAttributes = attributeArray;
    }

    private static Attribute[] parseAttributes(String string) throws IllegalArgumentException {
        int n;
        String[] stringArray;
        Attribute[] attributeArray = null;
        if (string != null && (stringArray = ProcessingInstruction.parsePseudoAttributes(string)) != null && (n = stringArray.length / 2) > 0) {
            attributeArray = new Attribute[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[2 * i];
                String string3 = stringArray[2 * i + 1];
                Name name = Name.fromString(string2);
                if (name == null) {
                    throw new IllegalArgumentException("cannot parse '" + string2 + "' as an attribute name");
                }
                attributeArray[i] = new Attribute(null, name, string3);
            }
        }
        return attributeArray;
    }

    public Attribute[] getCopiedAttributesWhenMultipleInstances() {
        return this.copiedAttributesWhenMultipleInstances;
    }

    public Attribute[] getCopiedAttributes() {
        return this.copiedAttributes;
    }

    @Override
    public String getSchemeName() {
        return "XInclude";
    }

    @Override
    public boolean detectXInclusion(Node[] nodeArray, boolean bl, XInclusion[] xInclusionArray) throws InclusionException {
        if (!bl || ((Element)nodeArray[0]).getName() != Name.XI_INCLUDE) {
            return false;
        }
        if (xInclusionArray != null) {
            xInclusionArray[0] = XInclude.fromElement((Element)nodeArray[0]);
        }
        return true;
    }

    @Override
    public boolean createSimpleInclusion(Node node, Node node2, boolean bl, String string, Map<Object, Object> map, SimpleInclusion[] simpleInclusionArray) {
        String string2;
        Serializable serializable;
        Object object;
        Document document = node.getDocument();
        if (document == null || document.getSourceURL() == null) {
            return false;
        }
        Element element = node.getParentElement();
        Element element2 = document.getRootElement();
        if (element == null && (node != node2 || node != element2)) {
            return false;
        }
        boolean bl2 = false;
        for (Node node3 = node; node3 != null; node3 = node3.getNextSibling()) {
            if (node3.getType() == Node.Type.ELEMENT && ((Element)node3).getNamespace() == Namespace.XI) {
                return false;
            }
            if (node3 != node2) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return false;
        }
        if (!XIncludeScheme.allowAdvancedXPointer(map)) {
            if (node == node2 && node.getType() == Node.Type.ELEMENT) {
                object = (Element)node;
                if (object != element2) {
                    serializable = DocumentTypeUtil.getIdAttributeName((Element)object);
                    if (serializable == null) {
                        return false;
                    }
                    string2 = ((Element)object).getAttribute((Name)serializable);
                    if (string2 == null || !XMLText.isName(string2)) {
                        return false;
                    }
                }
            } else {
                return false;
            }
        }
        if (simpleInclusionArray == null) {
            return true;
        }
        object = XIncludeScheme.computeXPointer(element2, element, node, node2);
        serializable = document.getSourceURL();
        string2 = null;
        if (bl) {
            string2 = string != null ? string : ((URL)serializable).toExternalForm();
        }
        try {
            simpleInclusionArray[0] = new XInclude((URL)serializable, string2, (String)object, null, false, null, XIncludeScheme.supportMultipleInstances(map) ? this.copiedAttributesWhenMultipleInstances : this.copiedAttributes, null);
            return true;
        }
        catch (InclusionException inclusionException) {
            return false;
        }
    }

    private static boolean allowAdvancedXPointer(Map<Object, Object> map) {
        return map != null && map.get((Object)Option.ALLOW_ADVANCED_XPOINTER) == Boolean.TRUE;
    }

    private static boolean supportMultipleInstances(Map<Object, Object> map) {
        return map != null && map.get((Object)Option.SUPPORT_MULTIPLE_INSTANCES) == Boolean.TRUE;
    }

    public static String computeXPointer(Node node, Node node2) {
        Document document = node.getDocument();
        if (document == null) {
            return null;
        }
        Element element = document.getRootElement();
        Element element2 = node.getParentElement();
        if (element2 == null && (node != node2 || node != element)) {
            return null;
        }
        return XIncludeScheme.computeXPointer(element, element2, node, node2);
    }

    private static String computeXPointer(Element element, Element element2, Node node, Node node2) {
        String string = null;
        if (node == node2 && node.getType() == Node.Type.ELEMENT) {
            Element element3 = (Element)node;
            if (element3 == element) {
                string = "element(/1)";
            } else {
                StringBuilder stringBuilder;
                IdentityHashMap<Element, String> identityHashMap = XIncludeScheme.elementToIdMap(element);
                boolean bl = XIncludeScheme.elementXPointer(element3, identityHashMap, stringBuilder = new StringBuilder());
                if (bl) {
                    stringBuilder.insert(0, "element(");
                    stringBuilder.append(')');
                }
                string = stringBuilder.toString();
            }
        } else {
            IdentityHashMap<Element, String> identityHashMap = XIncludeScheme.elementToIdMap(element);
            StringBuilder stringBuilder = new StringBuilder();
            XIncludeScheme.xpointerXPointer(element2, identityHashMap, stringBuilder);
            stringBuilder.insert(0, "xpointer(");
            if (node.getPreviousSibling() == null && node2.getNextSibling() == null) {
                stringBuilder.append("/node()");
            } else if (node == node2) {
                Node.Type type = node.getType();
                switch (type) {
                    case TEXT: {
                        stringBuilder.append("/text()[");
                        break;
                    }
                    case COMMENT: {
                        stringBuilder.append("/comment()[");
                        break;
                    }
                    case PROCESSING_INSTRUCTION: {
                        stringBuilder.append("/processing-instruction()[");
                        break;
                    }
                    default: {
                        stringBuilder.append("/*[");
                    }
                }
                stringBuilder.append(XIncludeScheme.indexOfNode(node, type));
                stringBuilder.append(']');
            } else if (XIncludeScheme.isElementRange(node, node2)) {
                stringBuilder.append("/*[position() >= ");
                stringBuilder.append(XIncludeScheme.indexOfNode(node, Node.Type.ELEMENT));
                stringBuilder.append(" and position() <= ");
                int n = XIncludeScheme.indexOfNode(node2, Node.Type.ELEMENT);
                String string2 = n == element2.getChildElementCount() ? "last()" : Integer.toString(n);
                stringBuilder.append(string2);
                stringBuilder.append(']');
            } else {
                stringBuilder.append("/node()[position() >= ");
                stringBuilder.append(XIncludeScheme.indexOfNode(node, null));
                stringBuilder.append(" and position() <= ");
                int n = XIncludeScheme.indexOfNode(node2, null);
                String string3 = n == element2.getChildCount() ? "last()" : Integer.toString(n);
                stringBuilder.append(string3);
                stringBuilder.append(']');
            }
            stringBuilder.append(')');
            string = stringBuilder.toString();
        }
        return string;
    }

    private static IdentityHashMap<Element, String> elementToIdMap(Element element) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
        DocumentTypeUtil.collectIds(documentType, element, hashMap);
        IdentityHashMap<Element, String> identityHashMap = new IdentityHashMap<Element, String>();
        for (IdEntry idEntry : hashMap.values()) {
            identityHashMap.put(idEntry.elements[0], idEntry.id);
        }
        return identityHashMap;
    }

    public static boolean elementXPointer(Element element, Map<Element, String> map, StringBuilder stringBuilder) {
        boolean bl = false;
        Element element2 = element;
        while (element2 != null) {
            Element element3 = element2.getParentElement();
            if (element3 == null) {
                stringBuilder.insert(0, "/1");
                break;
            }
            String string = map.get(element2);
            if (string != null && XMLText.isName(string)) {
                stringBuilder.insert(0, string);
                break;
            }
            stringBuilder.insert(0, XIncludeScheme.indexOfNode(element2, Node.Type.ELEMENT));
            stringBuilder.insert(0, '/');
            bl = true;
            element2 = element3;
        }
        return bl;
    }

    private static int indexOfNode(Node node, Node.Type type) {
        int n = 1;
        for (Node node2 = node.getParent().getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (type != null && node2.getType() != type) continue;
            if (node2 == node) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static void xpointerXPointer(Element element, IdentityHashMap<Element, String> identityHashMap, StringBuilder stringBuilder) {
        Element element2 = element;
        while (element2 != null) {
            Element element3 = element2.getParentElement();
            if (element3 == null) {
                stringBuilder.insert(0, "/*");
                break;
            }
            String string = identityHashMap.get(element2);
            if (string != null) {
                stringBuilder.insert(0, "')");
                stringBuilder.insert(0, string);
                stringBuilder.insert(0, "id('");
                break;
            }
            stringBuilder.insert(0, ']');
            stringBuilder.insert(0, XIncludeScheme.indexOfNode(element2, Node.Type.ELEMENT));
            stringBuilder.insert(0, "/*[");
            element2 = element3;
        }
    }

    private static boolean isElementRange(Node node, Node node2) {
        for (Node node3 = node; node3 != null; node3 = node3.getNextSibling()) {
            if (node3.getType() != Node.Type.ELEMENT) {
                return false;
            }
            if (node3 == node2) break;
        }
        return true;
    }

    @Override
    public Includable[] listIncludables(Document document) {
        DocumentType documentType = (DocumentType)document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY);
        if (documentType == null) {
            documentType = AnyDocumentType.INSTANCE;
        }
        Element element = document.getRootElement();
        HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
        DocumentTypeUtil.collectIds(documentType, element, hashMap);
        ArrayList<Includable> arrayList = new ArrayList<Includable>();
        boolean bl = true;
        if (hashMap.size() > 0) {
            for (IdEntry idEntry : hashMap.values()) {
                boolean bl2;
                Element element2 = idEntry.elements[0];
                if (element2.lookupInclusion() != null || !XMLText.isName(idEntry.id)) continue;
                boolean bl3 = bl2 = element2 == element;
                if (bl2) {
                    bl = false;
                }
                arrayList.add(new Includable(element2, element2, idEntry.id, XIncludeScheme.elementLabel(element2, bl2)));
            }
        }
        if (bl && element.getInclusion() == null) {
            arrayList.add(new Includable(element, element, "-", XIncludeScheme.elementLabel(element, true)));
        }
        Includable[] includableArray = new Includable[arrayList.size()];
        arrayList.toArray(includableArray);
        return includableArray;
    }

    private static final String elementLabel(Element element, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        stringBuilder.append(element.getName().format(false, element));
        stringBuilder.append('>');
        if (bl) {
            stringBuilder.append(' ');
            stringBuilder.append(Includable.ROOT_ELEMENT_PSEUDO_LABEL);
        } else {
            String string = element.getDescription(20, new Name[0]);
            if (string != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public static enum Option {
        ALLOW_ADVANCED_XPOINTER,
        SUPPORT_MULTIPLE_INSTANCES;

    }
}

