/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xed.Msg;
import com.xmlmind.xml.xed.XPathExpr;
import com.xmlmind.xml.xpath.ExprParser;
import com.xmlmind.xml.xpath.IllegalCharacterException;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.UnexpectedTokenException;
import com.xmlmind.xml.xpath.VariantExpr;

final class Scanner {
    public static final int EOF = -1;
    public static final int S = -2;
    public static final int COMMENT = -3;
    public static final int ENCODING_KEYWORD = -4;
    public static final int INCLUDE_KEYWORD = -5;
    public static final int NAMESPACE_KEYWORD = -6;
    public static final int MACRO_KEYWORD = -7;
    public static final int FOR_EACH_KEYWORD = -8;
    public static final int IF_KEYWORD = -9;
    public static final int ELSEIF_KEYWORD = -10;
    public static final int ELSE_KEYWORD = -11;
    public static final int STRING = -12;
    public static final int NCNAME = -13;
    public static final int XML_TEMPLATE = -14;
    private static final String[] tokenNames = new String[]{null, "end of data", "space", "comment", "'encoding'", "'include'", "'namespace'", "'macro'", "'for-each'", "'if'", "'elseif'", "'else'", "string", "NCName", "XML template"};
    public final String source;
    public final char[] sourceChars;
    public final int firstPos;
    public final int endPos;
    private int pos;
    private int lexemePos;
    private boolean[] emptyTag;
    private int cachedPos;
    private int lineNum;
    private int charNum;

    public Scanner(String string, int n, int n2) {
        this.source = string;
        this.sourceChars = string.toCharArray();
        this.firstPos = n;
        this.endPos = n + n2;
        this.lexemePos = this.pos = this.firstPos;
        this.emptyTag = new boolean[1];
        this.charNum = -1;
        this.lineNum = -1;
        this.cachedPos = -1;
    }

    public int getSourceCharCount() {
        return this.endPos - this.firstPos;
    }

    public int getNextToken() {
        if (this.pos >= this.endPos) {
            return -1;
        }
        char c = this.sourceChars[this.pos];
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.lexemePos = this.pos;
                this.skipSpace();
                return -2;
            }
            case '(': {
                if (this.match("(:") && this.skipComment()) {
                    return -3;
                }
                this.lexemePos = this.pos++;
                return c;
            }
            case '\"': 
            case '\'': {
                this.lexemePos = this.pos++;
                if (this.skipString(c)) {
                    return -12;
                }
                return c;
            }
            case '<': {
                this.lexemePos = this.pos++;
                if (this.skipXMLTemplate()) {
                    return -14;
                }
                return c;
            }
        }
        this.lexemePos = this.pos++;
        if (XMLText.isNCNameStartChar(c)) {
            this.skipNCName();
            if (this.lexemeEquals("for-each")) {
                return -8;
            }
            if (this.lexemeEquals("if")) {
                return -9;
            }
            if (this.lexemeEquals("elseif")) {
                return -10;
            }
            if (this.lexemeEquals("else")) {
                return -11;
            }
            if (this.lexemeEquals("macro")) {
                return -7;
            }
            if (this.lexemeEquals("namespace")) {
                return -6;
            }
            if (this.lexemeEquals("include")) {
                return -5;
            }
            if (this.lexemeEquals("encoding")) {
                return -4;
            }
            return -13;
        }
        return c;
    }

    private boolean match(String string) {
        int n = string.length();
        int n2 = this.pos;
        for (int i = 0; i < n; ++i) {
            if (n2 < this.endPos && this.sourceChars[n2++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean lexemeEquals(String string) {
        int n = string.length();
        if (n != this.pos - this.lexemePos) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == this.sourceChars[this.lexemePos + i]) continue;
            return false;
        }
        return true;
    }

    private void skipSpace() {
        block3: while (this.pos < this.endPos) {
            switch (this.sourceChars[this.pos]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private boolean skipComment() {
        int n = this.pos;
        this.pos += 2;
        int n2 = 1;
        block4: while (this.pos < this.endPos) {
            switch (this.sourceChars[this.pos]) {
                case '(': {
                    if (this.pos + 1 < this.endPos && this.sourceChars[this.pos + 1] == ':') {
                        this.pos += 2;
                        ++n2;
                        continue block4;
                    }
                    ++this.pos;
                    continue block4;
                }
                case ':': {
                    if (this.pos + 1 < this.endPos && this.sourceChars[this.pos + 1] == ')') {
                        this.pos += 2;
                        if (--n2 != 0) continue block4;
                        return true;
                    }
                    ++this.pos;
                    continue block4;
                }
            }
            ++this.pos;
        }
        this.pos = n;
        return false;
    }

    private boolean skipString(char c) {
        int n = this.pos++;
        while (this.pos < this.endPos) {
            if (this.sourceChars[this.pos++] != c) continue;
            return true;
        }
        this.pos = n;
        return false;
    }

    private boolean skipNCName() {
        int n = this.pos++;
        while (this.pos < this.endPos) {
            if (!XMLText.isNCNameChar(this.sourceChars[this.pos])) {
                return true;
            }
            ++this.pos;
        }
        this.pos = n;
        return false;
    }

    private boolean skipXMLTemplate() {
        int n = this.pos;
        int n2 = 0;
        block9: while (this.pos < this.endPos) {
            char c = this.sourceChars[this.pos];
            if (c == '<') {
                if (this.pos + 1 >= this.endPos) break;
                ++this.pos;
                char c2 = this.sourceChars[this.pos];
                switch (c2) {
                    case '/': {
                        if (!this.skipEndTag()) break block9;
                        if (--n2 != 0) continue block9;
                        return true;
                    }
                    case '?': {
                        if (this.skipPI()) continue block9;
                        break block9;
                    }
                    case '!': {
                        if (this.pos + 1 >= this.endPos) break;
                        ++this.pos;
                        char c3 = this.sourceChars[this.pos];
                        switch (c3) {
                            case '-': {
                                if (this.skipXMLComment()) continue block9;
                                break;
                            }
                            case '[': {
                                if (this.skipCDATA()) continue block9;
                                break;
                            }
                        }
                        break block9;
                    }
                    default: {
                        if (!this.skipStartTag()) break block9;
                        ++n2;
                        if (!this.emptyTag[0] || --n2 != 0) continue block9;
                        return true;
                    }
                }
                continue;
            }
            ++this.pos;
        }
        this.pos = n;
        return false;
    }

    private boolean skipStartTag() {
        this.emptyTag[0] = false;
        int n = 0;
        int n2 = 0;
        while (this.pos < this.endPos) {
            int n3 = this.sourceChars[this.pos++];
            if (n == 0) {
                switch (n3) {
                    case 34: 
                    case 39: {
                        n = n3;
                        break;
                    }
                    case 62: {
                        if (n2 == 47) {
                            this.emptyTag[0] = true;
                        }
                        return true;
                    }
                }
            } else if (n3 == n) {
                n = 0;
            }
            n2 = n3;
        }
        return false;
    }

    private boolean skipEndTag() {
        while (this.pos < this.endPos) {
            if (this.sourceChars[this.pos++] != '>') continue;
            return true;
        }
        return false;
    }

    private boolean skipPI() {
        char c = '\u0000';
        while (this.pos < this.endPos) {
            char c2;
            if ((c2 = this.sourceChars[this.pos++]) == '>' && c == '?') {
                return true;
            }
            c = c2;
        }
        return false;
    }

    private boolean skipXMLComment() {
        int n = 0;
        int n2 = 0;
        while (this.pos < this.endPos) {
            int n3;
            if ((n3 = this.sourceChars[this.pos++]) == 62 && n2 == 45 && n == 45) {
                return true;
            }
            n = n2;
            n2 = n3;
        }
        return false;
    }

    private boolean skipCDATA() {
        int n = 0;
        int n2 = 0;
        while (this.pos < this.endPos) {
            int n3;
            if ((n3 = this.sourceChars[this.pos++]) == 62 && n2 == 93 && n == 93) {
                return true;
            }
            n = n2;
            n2 = n3;
        }
        return false;
    }

    public String getLexeme() {
        return new String(this.sourceChars, this.lexemePos, this.pos - this.lexemePos);
    }

    public int getLineNumber() {
        if (this.cachedPos != this.pos) {
            this.locate(this.pos);
        }
        return 1 + this.lineNum;
    }

    public int getColumnNumber() {
        if (this.cachedPos != this.pos) {
            this.locate(this.pos);
        }
        return 1 + this.charNum;
    }

    private void locate(int n) {
        if (n > this.endPos) {
            n = this.endPos;
        }
        this.charNum = 0;
        this.lineNum = 0;
        int n2 = this.firstPos;
        block4: while (n2 < n) {
            char c = this.sourceChars[n2];
            switch (c) {
                case '\r': {
                    if (n2 + 1 < this.endPos && this.sourceChars[n2 + 1] == '\n') {
                        ++n2;
                    }
                }
                case '\n': 
                case '\f': {
                    ++this.lineNum;
                    this.charNum = 0;
                    ++n2;
                    continue block4;
                }
            }
            ++this.charNum;
            ++n2;
        }
        this.cachedPos = n;
    }

    public static String tokenName(int n) {
        if (n >= 0 && n < 65535) {
            return "'" + (char)n + "'";
        }
        if ((n = -n) >= 1 && n < tokenNames.length) {
            return tokenNames[n];
        }
        return "(unknown " + -n + ")";
    }

    public XPathExpr scanXPathExpr(PrefixToNamespace prefixToNamespace, int[] nArray) throws ParseException {
        int n;
        this.skipSpaceOrComment();
        switch (this.sourceChars[this.pos]) {
            case ')': 
            case '<': {
                return null;
            }
        }
        VariantExpr variantExpr = null;
        String string = null;
        boolean bl = false;
        ExprParser exprParser = Scanner.createExprParser(this.source, this.pos, this.endPos - this.pos, prefixToNamespace);
        try {
            variantExpr = exprParser.parseVariantExpr();
        }
        catch (IllegalCharacterException illegalCharacterException) {
        }
        catch (UnexpectedTokenException unexpectedTokenException) {
            bl = true;
        }
        if (variantExpr != null) {
            n = this.endPos;
        } else {
            n = exprParser.getSourceFirst();
            if (bl) {
                --n;
            }
            exprParser = Scanner.createExprParser(this.source, this.pos, n - this.pos, prefixToNamespace);
            variantExpr = exprParser.parseVariantExpr();
        }
        string = new String(this.sourceChars, this.pos, n - this.pos).trim();
        if (n < this.endPos) {
            this.lexemePos = n;
            this.pos = n + 1;
            nArray[0] = this.sourceChars[this.lexemePos];
        } else {
            this.pos = this.endPos;
            nArray[0] = -1;
        }
        return new XPathExpr(variantExpr, string);
    }

    private void skipSpaceOrComment() throws ParseException {
        block4: while (true) {
            if (this.pos >= this.endPos) {
                throw new ParseException(Msg.msg("reachedEOF"));
            }
            switch (this.sourceChars[this.pos]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.skipSpace();
                    continue block4;
                }
                case '(': {
                    if (this.pos + 1 >= this.endPos || this.sourceChars[this.pos + 1] != ':') break block4;
                    this.skipComment();
                    continue block4;
                }
            }
            break;
        }
    }

    private static ExprParser createExprParser(String string, int n, int n2, PrefixToNamespace prefixToNamespace) {
        ExprParser exprParser = new ExprParser(string, n, n2, prefixToNamespace);
        exprParser.setUnescapeLiterals(true);
        exprParser.setAllowDefaultNS(true);
        return exprParser;
    }
}

