/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.xed.Constants;

public final class NodeUtil {
    public static final int CONTENT_TYPE_WHITESPACE = 1;
    public static final int CONTENT_TYPE_ELEMENT = 2;
    public static final int CONTENT_TYPE_TEXT = 4;
    private static final int ELEMENT_AND_TEXT = 6;

    private NodeUtil() {
    }

    public static int getContentType(Element element) {
        int n = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case TEXT: {
                    if (((Text)node).getTextLength() <= 0) break;
                    int n2 = 1;
                    for (char c : ((Text)node).getTextChars()) {
                        if (Character.isWhitespace(c) || c == '\u00a0') continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 == 0) {
                        n &= 0xFFFFFFFE;
                        n |= 4;
                        break;
                    }
                    if ((n & 4) != 0) break;
                    n |= 1;
                    break;
                }
                case ELEMENT: {
                    n |= 2;
                    int n2 = NodeUtil.getContentType((Element)node);
                    if ((n2 & 4) != 0) {
                        n &= 0xFFFFFFFE;
                        n |= 4;
                        break;
                    }
                    if ((n2 & 1) == 0 || (n & 4) != 0) break;
                    n |= 1;
                }
            }
            if (n == 6) break;
        }
        return n;
    }

    public static void replace(Node node, Node[] nodeArray) {
        int n;
        if (nodeArray == null || (n = nodeArray.length) == 0) {
            NodeUtil.delete(node);
            return;
        }
        Tree tree = node.getParent();
        if (tree != null) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                tree.insertChild(node, nodeArray[n2]);
            }
            n2 = nodeArray[0].getType() == Node.Type.TEXT || nodeArray[n - 1].getType() == Node.Type.TEXT ? 1 : 0;
            tree.removeChild(node);
            if (n2 != 0) {
                NodeUtil.mergeContiguousText(tree);
            }
        }
    }

    public static void delete(Node node) {
        Tree tree = node.getParent();
        if (tree != null) {
            Node node2;
            Node node3 = node.getPreviousSibling();
            boolean bl = node3 != null && node3.getType() == Node.Type.TEXT || (node2 = node.getNextSibling()) != null && node2.getType() == Node.Type.TEXT;
            tree.removeChild(node);
            if (bl) {
                NodeUtil.mergeContiguousText(tree);
            }
        }
    }

    public static void mergeContiguousText(Tree tree, boolean bl) {
        NodeUtil.mergeContiguousText(tree);
        if (bl) {
            Node node = tree.getFirstChild();
            while (node != null) {
                Element element = node.getNextElement();
                if (node.getType() == Node.Type.ELEMENT) {
                    NodeUtil.mergeContiguousText((Element)node, true);
                }
                node = element;
            }
        }
    }

    public static void mergeContiguousText(Tree tree) {
        Node node = tree.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.TEXT) {
                Text text = (Text)node;
                int n = text.getTextLength();
                while (node2 != null && node2.getType() == Node.Type.TEXT) {
                    Text text2 = (Text)node2;
                    int n2 = text2.getTextLength();
                    if (n2 > 0) {
                        text.appendText(text2.getText());
                    }
                    Node node3 = node2;
                    node2 = node3.getNextSibling();
                    tree.removeChild(node3);
                }
            }
            node = node2;
        }
    }

    public static Node[] getNodes(Node[] nodeArray) {
        Element element;
        if (nodeArray.length == 1 && nodeArray[0].getType() == Node.Type.ELEMENT && (element = (Element)nodeArray[0]).getNamespace() == Constants.GROUP_NAMESPACE) {
            nodeArray = element.getChildren();
            element.removeAllChildren();
        }
        return nodeArray;
    }

    public static void insert(boolean bl, Node node, Node[] nodeArray) {
        Tree tree = node.getParent();
        if (tree != null) {
            if (!bl) {
                node = node.getNextSibling();
            }
            NodeUtil.insertBefore(tree, node, nodeArray);
        }
    }

    public static void insertBefore(Tree tree, Node node, Node[] nodeArray) {
        int n = nodeArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                tree.insertChild(node, nodeArray[i]);
            }
            if (nodeArray[0].getType() == Node.Type.TEXT || nodeArray[n - 1].getType() == Node.Type.TEXT) {
                NodeUtil.mergeContiguousText(tree);
            }
        }
    }
}

