/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.Console;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xed.Action;
import com.xmlmind.xml.xed.Command;
import com.xmlmind.xml.xed.Commands;
import com.xmlmind.xml.xed.MacroCmd;
import com.xmlmind.xml.xed.Msg;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xed.ScriptLoadException;
import com.xmlmind.xml.xpath.ExprContext;

final class CommandAction
extends Action {
    public final Object[] arguments;
    private Command command;

    public CommandAction(String string, Object[] objectArray) {
        super(string);
        this.arguments = objectArray;
    }

    @Override
    public void resolveCommands(Script script) throws ScriptLoadException {
        this.command = null;
        String string = null;
        MacroCmd macroCmd = script.getMacro(this.name);
        if (macroCmd != null) {
            this.command = macroCmd;
            if (this.arguments.length != macroCmd.parameterNames.length) {
                string = Msg.msg("wrongNumberOfArguments", this.arguments.length, this.name);
            }
        } else {
            Commands.Entry entry = Commands.get(this.name);
            if (entry != null) {
                this.command = entry.command;
                if (this.arguments.length < entry.minArgCount || this.arguments.length > entry.maxArgCount) {
                    string = Msg.msg("wrongNumberOfArguments", this.arguments.length, this.name);
                }
            } else {
                string = Msg.msg("unknownCommand", this.name);
            }
        }
        if (string != null) {
            throw new ScriptLoadException(this.scriptURL, this.lineNumber, this.columnNumber, string);
        }
    }

    public Command getCommand() {
        return this.command;
    }

    @Override
    public void performAction(XNode xNode, ExprContext exprContext, Script script, Console console) throws Exception {
        this.command.executeCommand(this.arguments, xNode, exprContext, script, console);
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        CommandAction.indent(n, stringBuilder);
        stringBuilder.append(this.name);
        stringBuilder.append('(');
        for (int i = 0; i < this.arguments.length; ++i) {
            Object object = this.arguments[i];
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object);
        }
        stringBuilder.append(");");
    }
}

