/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.datatype.AnyStringType;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.InvalidTypeException;
import com.xmlmind.xml.wxs.datatype.ListType;
import com.xmlmind.xml.wxs.datatype.Restriction;
import com.xmlmind.xml.wxs.datatype.UnionType;
import com.xmlmind.xml.wxs.datatype.Value;
import com.xmlmind.xml.wxs.validate.BuiltInType;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.Msg;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.ValidationError;
import com.xmlmind.xml.wxs.validate.ValidationErrors;
import java.io.ObjectStreamException;

public final class SimpleType
extends Type {
    public static final Name XSD_ANY_SIMPLE_TYPE = Name.get(Namespace.XSD, "anySimpleType");
    public static final SimpleType ANY = SimpleType.createAnySimpleType();
    private DataType dataType;

    private static final SimpleType createAnySimpleType() {
        DataType dataType;
        SimpleType simpleType = new SimpleType(XSD_ANY_SIMPLE_TYPE, ComplexType.ANY, 2, false, 0, 0);
        Restriction restriction = new Restriction(AnyStringType.BASE);
        try {
            dataType = restriction.derive(simpleType);
        }
        catch (InvalidTypeException invalidTypeException) {
            invalidTypeException.printStackTrace();
            dataType = null;
        }
        simpleType.setDataType(dataType);
        return simpleType;
    }

    public SimpleType(Name name, Type type, int n, boolean bl, int n2, int n3) {
        super(name, type, n, bl, n2, n3);
    }

    public void setDataType(DataType dataType) {
        if (dataType == null || dataType.getProperties() != this) {
            throw new IllegalArgumentException("bad dataType " + String.valueOf(dataType));
        }
        this.dataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public ValidationError validate(String string, Element element, Schema schema) {
        ValidationErrors validationErrors = new ValidationErrors();
        Value value = this.validate(string, element, schema, validationErrors);
        if (value == null) {
            return validationErrors.getLast();
        }
        return null;
    }

    public Value validate(String string, Element element, Schema schema, ValidationErrors validationErrors) {
        try {
            return this.dataType.valueOf(string, element);
        }
        catch (InvalidDataException invalidDataException) {
            validationErrors.append(null, invalidDataException.getConstraint(), invalidDataException.getMessage());
            return null;
        }
    }

    @Override
    protected Object validate(Element element, String string, boolean bl, Schema schema, ValidationErrors validationErrors) {
        Object object;
        XNode xNode;
        Object object2;
        if (this.isAbstract) {
            validationErrors.append(element, "cvc-type.2", Msg.msg("typeIsAbstract"));
            return null;
        }
        if (element.getAttributeCount() > 0) {
            object2 = element.getAttributes();
            while (object2.hasNext()) {
                xNode = object2.next();
                object = ((Attribute)xNode).name;
                if (object == Name.XSI_TYPE || object == Name.XSI_NIL || object == Name.XSI_SCHEMA_LOCATION || object == Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION) continue;
                validationErrors.append(element, "cvc-type.3.1.1", Msg.msg("elementHasAttributes"));
                return null;
            }
        }
        object2 = null;
        block7: for (xNode = element.getFirstChild(); xNode != null; xNode = ((Node)xNode).getNextSibling()) {
            switch (((Node)xNode).getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    continue block7;
                }
                case TEXT: {
                    if (object2 == null) {
                        object2 = new StringBuilder();
                    }
                    ((StringBuilder)object2).append(((Text)xNode).getTextChars());
                    continue block7;
                }
                default: {
                    validationErrors.append(element, "cvc-type.3.1.2", Msg.msg("elementHasChildElements"));
                    return null;
                }
            }
        }
        if (SimpleType.isNilled(element)) {
            return VALID;
        }
        object = object2 == null || ((StringBuilder)object2).length() == 0 ? (string == null ? "" : string) : ((StringBuilder)object2).toString();
        try {
            return this.dataType.valueOf((String)object, element);
        }
        catch (InvalidDataException invalidDataException) {
            validationErrors.append(element, "cvc-type.3.1.3", Msg.msg("elementContainsInvalidData", invalidDataException.getMessage(), invalidDataException.getConstraint()));
            return null;
        }
    }

    @Override
    public boolean isValidDerivation(Type type, int n) {
        if (this == type) {
            return true;
        }
        Type type2 = this.baseType;
        if ((n & 2) != 0 || (type2.prohibitedDerivations & 2) != 0) {
            return false;
        }
        if (type2 == type) {
            return true;
        }
        if (type2 != ComplexType.ANY && type2.isValidDerivation(type, n)) {
            return true;
        }
        DataType dataType = this.getDataType();
        if ((dataType instanceof ListType || dataType instanceof UnionType) && type == ANY) {
            return true;
        }
        DataType dataType2 = type.getDataType();
        if (dataType2 instanceof UnionType) {
            DataType[] dataTypeArray = ((UnionType)dataType2).getMemberTypes();
            for (int i = 0; i < dataTypeArray.length; ++i) {
                SimpleType simpleType = (SimpleType)dataTypeArray[i].getProperties();
                if (!this.isValidDerivation(simpleType, n)) continue;
                return true;
            }
        }
        return false;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.name == null) {
            return this;
        }
        Type type = BuiltInType.get(this.name);
        return type == null ? this : type;
    }
}

