/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.wxs.validate.AllParticle;
import com.xmlmind.xml.wxs.validate.ChoiceParticle;
import com.xmlmind.xml.wxs.validate.ElementParticle;
import com.xmlmind.xml.wxs.validate.Msg;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.SequenceParticle;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class ParticleParser {
    public final boolean isStrictSyntax;
    public final PrefixToNamespace prefixToNamespace;
    private String lookahead;
    private static final int PARENTHESE = 0;
    private static final int CONNECTOR_OR_PARENTHESE = 1;
    private static final int PCDATA = 2;
    private static final int NAME = 3;
    private static final int TERM = 4;
    private static final int OCCUR = 5;
    private static final int END = 6;
    private static final int OCCUR_OR_END = 7;
    private static final Particle[] NO_PARTICLES = new Particle[0];

    public ParticleParser(boolean bl, PrefixToNamespace prefixToNamespace) {
        this.isStrictSyntax = bl;
        this.prefixToNamespace = prefixToNamespace;
    }

    public Particle parseMixedContent(String string) throws ParseException {
        Particle[] particleArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(|)*", true);
        int n = 0;
        IdentityHashMap<Name, Name> identityHashMap = new IdentityHashMap<Name, Name>();
        boolean bl = false;
        block12: while (stringTokenizer.hasMoreTokens()) {
            particleArray = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    if (!particleArray.equals("(")) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "(", particleArray));
                    }
                    n = 2;
                    continue block12;
                }
                case 1: {
                    char c;
                    if (particleArray.length() != 1 || (c = particleArray.charAt(0)) != '|' && c != ')') {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "|)", particleArray));
                    }
                    n = c == '|' ? 3 : (bl ? 5 : 7);
                    continue block12;
                }
                case 5: {
                    if (!particleArray.equals("*")) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "*", particleArray));
                    }
                    n = 6;
                    continue block12;
                }
                case 2: {
                    if (!particleArray.equals("#PCDATA")) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "#PCDATA", particleArray));
                    }
                    n = 1;
                    continue block12;
                }
                case 3: {
                    Name name = this.getName((String)particleArray);
                    if (identityHashMap.put(name, name) != null) {
                        throw new ParseException(Msg.msg("PP.duplicateElementName", new Object[]{particleArray}));
                    }
                    bl = true;
                    n = 1;
                    continue block12;
                }
                case 7: {
                    if (!particleArray.equals("*")) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "*", particleArray));
                    }
                    n = 6;
                    continue block12;
                }
                case 6: {
                    throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.endOfSpec"), particleArray));
                }
            }
            throw new RuntimeException("internal error: unknown state " + n);
        }
        switch (n) {
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new ParseException(Msg.msg("PP.unexpectedEndOfSpec"));
            }
        }
        if (!bl) {
            return new SequenceParticle(NO_PARTICLES, 1, 1);
        }
        particleArray = new Particle[identityHashMap.size()];
        Iterator iterator = identityHashMap.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            particleArray[n2++] = new ElementParticle((Name)iterator.next(), 1, 1);
        }
        return new ChoiceParticle(particleArray, 0, -1);
    }

    private Name getName(String string) throws ParseException {
        if (!XMLText.isName(string)) {
            throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.elementName"), string));
        }
        Name name = Name.parse(string, false, this.prefixToNamespace);
        if (name == null) {
            name = Name.get(Namespace.NONE, string);
        }
        return name;
    }

    public Particle parseElementContent(String string) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(|,&)?*+{}", true);
        this.lookahead = stringTokenizer.nextToken();
        Particle particle = this.parseElementContent(stringTokenizer);
        if (this.lookahead != null) {
            throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.endOfSpec"), this.lookahead));
        }
        return particle;
    }

    private Particle parseElementContent(StringTokenizer stringTokenizer) throws ParseException {
        Particle.Type type;
        int n;
        int n2;
        Name name = null;
        Particle[] particleArray = null;
        if (this.lookahead.charAt(0) == '(') {
            n2 = 4;
            this.lookahead = ParticleParser.nextToken(stringTokenizer);
            n = 0;
            ArrayList<Particle> arrayList = new ArrayList<Particle>();
            block29: while (true) {
                switch (n2) {
                    case 4: {
                        arrayList.add(this.parseElementContent(stringTokenizer));
                        n2 = 1;
                        if (this.lookahead != null) continue block29;
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "|,&)", Msg.msg("PP.endOfSpec")));
                    }
                    case 1: {
                        if (this.lookahead.length() != 1) {
                            throw new ParseException(Msg.msg("PP.unexpectedToken", "|,&)", this.lookahead));
                        }
                        int n3 = this.lookahead.charAt(0);
                        switch (n3) {
                            case 38: 
                            case 44: 
                            case 124: {
                                if (n == 0) {
                                    n = n3;
                                } else if (n3 != n) {
                                    throw new ParseException(Msg.msg("PP.unexpectedToken", (char)n + ")", this.lookahead));
                                }
                                n2 = 4;
                                this.lookahead = ParticleParser.nextToken(stringTokenizer);
                                continue block29;
                            }
                            case 41: {
                                n2 = 6;
                                break block29;
                            }
                        }
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "|,&)", this.lookahead));
                    }
                    default: {
                        throw new RuntimeException("internal error: unknown state " + n2);
                    }
                }
                break;
            }
            if (n2 != 6) {
                throw new ParseException(Msg.msg("PP.unexpectedEndOfSpec"));
            }
            switch (n) {
                case 124: {
                    type = Particle.Type.CHOICE;
                    break;
                }
                case 38: {
                    if (this.isStrictSyntax) {
                        throw new ParseException(Msg.msg("PP.strictSyntaxError", "&"));
                    }
                    type = Particle.Type.ALL;
                    break;
                }
                case 44: {
                    type = Particle.Type.SEQUENCE;
                    break;
                }
                case 0: {
                    Particle particle = (Particle)arrayList.get(0);
                    if (particle.getMinOccurs() == 1 && particle.getMaxOccurs() == 1 && particle instanceof ElementParticle) {
                        name = ((ElementParticle)particle).elementName;
                        type = Particle.Type.ELEMENT;
                        break;
                    }
                    type = Particle.Type.SEQUENCE;
                    break;
                }
                default: {
                    throw new RuntimeException("internal error: unknown connector " + (char)n);
                }
            }
            if (type != Particle.Type.ELEMENT) {
                particleArray = new Particle[arrayList.size()];
                arrayList.toArray(particleArray);
            }
        } else {
            name = this.getName(this.lookahead);
            type = Particle.Type.ELEMENT;
        }
        n2 = 1;
        n = 1;
        this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
        if (this.lookahead != null) {
            switch (this.lookahead.charAt(0)) {
                case '?': {
                    n2 = 0;
                    n = 1;
                    this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
                    break;
                }
                case '*': {
                    n2 = 0;
                    n = -1;
                    this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
                    break;
                }
                case '+': {
                    n2 = 1;
                    n = -1;
                    this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
                    break;
                }
                case '{': {
                    if (this.isStrictSyntax) {
                        throw new ParseException(Msg.msg("PP.strictSyntaxError", "{m,n}"));
                    }
                    this.lookahead = ParticleParser.nextToken(stringTokenizer);
                    n2 = ParticleParser.parseOccur(this.lookahead);
                    this.lookahead = ParticleParser.nextToken(stringTokenizer);
                    switch (this.lookahead.charAt(0)) {
                        case ',': {
                            this.lookahead = ParticleParser.nextToken(stringTokenizer);
                            if (this.lookahead.charAt(0) == '}') {
                                n = -1;
                                break;
                            }
                            n = ParticleParser.parseOccur(this.lookahead);
                            this.lookahead = ParticleParser.nextToken(stringTokenizer);
                            if (this.lookahead.charAt(0) == '}') break;
                            throw new ParseException(Msg.msg("PP.unexpectedToken", "}", this.lookahead));
                        }
                        case '}': {
                            n = n2;
                            break;
                        }
                        default: {
                            throw new ParseException(Msg.msg("PP.unexpectedToken", ",}", this.lookahead));
                        }
                    }
                    if (n == 0 || n != -1 && n2 > n) {
                        throw new ParseException(Msg.msg("PP.invalidMinMaxOccurs"));
                    }
                    this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
                }
            }
        }
        if (type == Particle.Type.ELEMENT) {
            return new ElementParticle(name, n2, n);
        }
        if (particleArray.length == 1 && n2 == 1 && n == 1) {
            return particleArray[0];
        }
        switch (type) {
            case CHOICE: {
                return new ChoiceParticle(particleArray, n2, n);
            }
            case SEQUENCE: {
                return new SequenceParticle(particleArray, n2, n);
            }
            case ALL: {
                return new AllParticle(particleArray, n2, n);
            }
        }
        throw new RuntimeException("internal error: unknown particle type " + String.valueOf((Object)type));
    }

    private static String nextTokenIfAny(StringTokenizer stringTokenizer) {
        return stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
    }

    private static String nextToken(StringTokenizer stringTokenizer) throws ParseException {
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ParseException(Msg.msg("PP.unexpectedEndOfSpec"));
        }
        return stringTokenizer.nextToken();
    }

    private static int parseOccur(String string) throws ParseException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.occur"), string));
        }
        return n;
    }

    public static class ParseException
    extends Exception {
        public ParseException(String string) {
            super(string);
        }
    }
}

