/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.IDType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.validate.AllParticle;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.AttributeUse;
import com.xmlmind.xml.wxs.validate.ChoiceParticle;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementParticle;
import com.xmlmind.xml.wxs.validate.Msg;
import com.xmlmind.xml.wxs.validate.NameRE;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.SequenceParticle;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.ValidationError;
import com.xmlmind.xml.wxs.validate.ValidationErrors;
import com.xmlmind.xml.wxs.validate.Wildcard;
import com.xmlmind.xml.wxs.validate.WildcardParticle;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public final class ComplexType
extends Type {
    private static final SequenceParticle EMPTY_SEQUENCE = new SequenceParticle(new Particle[0], 1, 1);
    private static final AttributeUse[] NO_ATTRIBUTE_USES = new AttributeUse[0];
    private static final Name[] NO_NAMES = new Name[0];
    private static final Wildcard[] NO_WILDCARDS = new Wildcard[0];
    private static final Iterator<AttributeDeclaration> NO_ATTRIBUTE_DECLS = new IdentityLinearHashtable().elements();
    private static final Iterator<ElementDeclaration> NO_ELEMENT_DECLS = new IdentityLinearHashtable().elements();
    public static final Name XSD_ANY_TYPE = Name.get(Namespace.XSD, "anyType");
    public static final ComplexType ANY = ComplexType.createAnyType();
    private AttributeUse[] attributeUses = NO_ATTRIBUTE_USES;
    private Wildcard attributeWildcard = null;
    private IdentityLinearHashtable<Name, AttributeDeclaration> attributeDecls = null;
    private ContentType contentType = ContentType.EMPTY;
    private DataType dataType = null;
    private Particle particle = null;
    private Name[] elementFields = NO_NAMES;
    private Wildcard[] elementWildcards = NO_WILDCARDS;
    private IdentityLinearHashtable<Name, ElementDeclaration> elementDecls = null;
    private transient NameRE nameRE = null;

    private static final ComplexType createAnyType() {
        ComplexType complexType = new ComplexType(XSD_ANY_TYPE, null, 1, false, 0, 0);
        complexType.setAttributeWildcard(Wildcard.ANY_LAX);
        complexType.setContentType(new SequenceParticle(new Particle[]{new WildcardParticle(Wildcard.ANY_LAX, 1, 1)}, 0, -1), true);
        return complexType;
    }

    public ComplexType(Name name, Type type, int n, boolean bl, int n2, int n3) {
        super(name, type, n, bl, n2, n3);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.name == XSD_ANY_TYPE ? ANY : this;
    }

    public void setAttributeUses(AttributeUse[] attributeUseArray) {
        this.attributeUses = attributeUseArray;
    }

    public void setAttributeWildcard(Wildcard wildcard) {
        this.attributeWildcard = wildcard;
    }

    public AttributeDeclaration addAttributeDeclaration(AttributeDeclaration attributeDeclaration) {
        if (this.attributeDecls == null) {
            this.attributeDecls = new IdentityLinearHashtable();
        }
        return this.attributeDecls.put(attributeDeclaration.name, attributeDeclaration);
    }

    public void setContentType(Particle particle, boolean bl) {
        if ((particle = particle.simplify()) == null) {
            if (!bl) {
                this.resetContentType();
                return;
            }
            particle = EMPTY_SEQUENCE;
        }
        this.contentType = bl ? ContentType.MIXED : ContentType.ELEMENT_ONLY;
        this.particle = particle;
        this.dataType = null;
        IdentityHashMap<Name, Name> identityHashMap = new IdentityHashMap<Name, Name>();
        HashMap<Wildcard, Wildcard> hashMap = new HashMap<Wildcard, Wildcard>();
        ComplexType.traverseParticle(particle, identityHashMap, hashMap);
        int n = identityHashMap.size();
        if (n == 0) {
            this.elementFields = NO_NAMES;
        } else {
            this.elementFields = new Name[n];
            identityHashMap.values().toArray(this.elementFields);
        }
        n = hashMap.size();
        if (n == 0) {
            this.elementWildcards = NO_WILDCARDS;
        } else {
            this.elementWildcards = new Wildcard[n];
            hashMap.values().toArray(this.elementWildcards);
        }
    }

    private static final void traverseParticle(Particle particle, Map<Name, Name> map, Map<Wildcard, Wildcard> map2) {
        switch (particle.getType()) {
            case SEQUENCE: {
                ComplexType.traverseParticles(((SequenceParticle)particle).getParticles(), map, map2);
                break;
            }
            case CHOICE: {
                ComplexType.traverseParticles(((ChoiceParticle)particle).getParticles(), map, map2);
                break;
            }
            case ALL: {
                ComplexType.traverseParticles(((AllParticle)particle).getParticles(), map, map2);
                break;
            }
            case WILDCARD: {
                Wildcard wildcard = ((WildcardParticle)particle).wildcard;
                map2.put(wildcard, wildcard);
                break;
            }
            default: {
                Name name = ((ElementParticle)particle).elementName;
                map.put(name, name);
            }
        }
    }

    private static final void traverseParticles(Particle[] particleArray, Map<Name, Name> map, Map<Wildcard, Wildcard> map2) {
        for (int i = 0; i < particleArray.length; ++i) {
            ComplexType.traverseParticle(particleArray[i], map, map2);
        }
    }

    public void setContentType(DataType dataType) {
        this.contentType = ContentType.DATA;
        this.dataType = dataType;
        this.particle = null;
        this.elementFields = NO_NAMES;
        this.elementWildcards = NO_WILDCARDS;
    }

    public void resetContentType() {
        this.contentType = ContentType.EMPTY;
        this.dataType = null;
        this.particle = null;
        this.elementFields = NO_NAMES;
        this.elementWildcards = NO_WILDCARDS;
    }

    public void addElementDeclaration(ElementDeclaration elementDeclaration) {
        if (this.elementDecls == null) {
            this.elementDecls = new IdentityLinearHashtable();
        }
        this.elementDecls.put(elementDeclaration.name, elementDeclaration);
    }

    public AttributeUse getAttributeUse(Name name) {
        for (int i = 0; i < this.attributeUses.length; ++i) {
            if (this.attributeUses[i].name != name) continue;
            return this.attributeUses[i];
        }
        return null;
    }

    public AttributeUse[] getAttributeUses() {
        return this.attributeUses;
    }

    public Wildcard getAttributeWildcard() {
        return this.attributeWildcard;
    }

    public boolean containsAttributeField(Name name) {
        for (int i = 0; i < this.attributeUses.length; ++i) {
            if (this.attributeUses[i].name != name) continue;
            return true;
        }
        return this.attributeWildcard != null && this.attributeWildcard.match(name);
    }

    public AttributeDeclaration getAttributeDeclaration(Name name) {
        return this.attributeDecls == null ? null : this.attributeDecls.get(name);
    }

    public int getAttributeDeclarationCount() {
        return this.attributeDecls == null ? 0 : this.attributeDecls.size();
    }

    public Iterator<AttributeDeclaration> getAttributeDeclarations() {
        if (this.attributeDecls == null) {
            return NO_ATTRIBUTE_DECLS;
        }
        return this.attributeDecls.elements();
    }

    public Name[] getElementFields() {
        return this.elementFields;
    }

    public Wildcard[] getElementWildcards() {
        return this.elementWildcards;
    }

    public boolean containsElementField(Name name) {
        int n;
        for (n = 0; n < this.elementFields.length; ++n) {
            if (this.elementFields[n] != name) continue;
            return true;
        }
        for (n = 0; n < this.elementWildcards.length; ++n) {
            if (!this.elementWildcards[n].match(name)) continue;
            return true;
        }
        return false;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public ElementDeclaration getElementDeclaration(Name name) {
        return this.elementDecls == null ? null : this.elementDecls.get(name);
    }

    public int getElementDeclarationCount() {
        return this.elementDecls == null ? 0 : this.elementDecls.size();
    }

    public Iterator<ElementDeclaration> getElementDeclarations() {
        if (this.elementDecls == null) {
            return NO_ELEMENT_DECLS;
        }
        return this.elementDecls.elements();
    }

    @Override
    protected Object validate(Element element, String string, boolean bl, Schema schema, ValidationErrors validationErrors) {
        boolean bl2;
        int n;
        Serializable serializable;
        Comparable<Name> comparable;
        int n2;
        Node node;
        if (this.isAbstract) {
            validationErrors.append(element, "cvc-complex-type.1", Msg.msg("typeIsAbstract"));
            return null;
        }
        StringBuilder stringBuilder = null;
        Name[] nameArray = null;
        int n3 = 0;
        block23: for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    continue block23;
                }
                case TEXT: {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(((Text)node).getTextChars());
                    continue block23;
                }
                default: {
                    if (nameArray == null) {
                        nameArray = new Name[element.getChildCount()];
                    }
                    nameArray[n3++] = ((Element)node).getName();
                }
            }
        }
        Object object = VALID;
        if (!ComplexType.isNilled(element)) {
            switch (this.contentType) {
                case EMPTY: {
                    if (stringBuilder == null && nameArray == null) break;
                    validationErrors.append(element, "cvc-complex-type.2.1", Msg.msg("elementNotEmpty"));
                    object = null;
                    break;
                }
                case DATA: {
                    if (nameArray != null) {
                        validationErrors.append(element, "cvc-complex-type.2.2", Msg.msg("elementHasChildElements"));
                        return null;
                    }
                    String string2 = stringBuilder == null || stringBuilder.length() == 0 ? (string == null ? "" : string) : stringBuilder.toString();
                    try {
                        object = this.dataType.valueOf(string2, element);
                    }
                    catch (InvalidDataException invalidDataException) {
                        validationErrors.append(element, "cvc-complex-type.2.2", Msg.msg("elementContainsInvalidData", invalidDataException.getMessage(), invalidDataException.getConstraint()));
                        object = null;
                    }
                    break;
                }
                case ELEMENT_ONLY: {
                    String string2;
                    if (stringBuilder != null) {
                        string2 = stringBuilder.toString();
                        int n4 = string2.length();
                        block24: for (n2 = 0; n2 < n4; ++n2) {
                            switch (string2.charAt(n2)) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    continue block24;
                                }
                                default: {
                                    validationErrors.append(element, "cvc-complex-type.2.3", Msg.msg("elementContainsText"));
                                    object = null;
                                    break block24;
                                }
                            }
                        }
                    }
                    if (nameArray == null) {
                        nameArray = NO_NAMES;
                    }
                    if (this.checkNameSequence(nameArray, n3)) break;
                    validationErrors.append(element, "cvc-complex-type.2.4", Msg.msg("invalidChildElementSequence"));
                    object = null;
                    break;
                }
                case MIXED: {
                    if (nameArray == null) {
                        object = stringBuilder == null ? (string == null ? "" : string) : stringBuilder.toString();
                        nameArray = NO_NAMES;
                    }
                    if (this.checkNameSequence(nameArray, n3)) break;
                    validationErrors.append(element, "cvc-complex-type.2.4", Msg.msg("invalidChildElementSequence"));
                    object = null;
                }
            }
        }
        int n5 = 0;
        if (element.getAttributeCount() > 0) {
            Iterator<Attribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                comparable = attribute.name;
                if (comparable == Name.XSI_TYPE || comparable == Name.XSI_NIL || comparable == Name.XSI_SCHEMA_LOCATION || comparable == Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION) continue;
                serializable = null;
                boolean bl3 = false;
                for (n = 0; n < this.attributeUses.length; ++n) {
                    AttributeUse attributeUse = this.attributeUses[n];
                    if (attributeUse.name != comparable) continue;
                    bl3 = true;
                    serializable = this.getAttributeDeclaration((Name)comparable);
                    if (serializable != null) break;
                    serializable = schema.getAttributeDeclaration((Name)comparable);
                    break;
                }
                n = 0;
                bl2 = false;
                if (!bl3 && this.attributeWildcard != null && this.attributeWildcard.match((Name)comparable)) {
                    bl2 = true;
                    switch (this.attributeWildcard.processContents) {
                        case SKIP: {
                            n = 1;
                            break;
                        }
                        case LAX: {
                            serializable = this.getAttributeDeclaration((Name)comparable);
                            if (serializable == null) {
                                serializable = schema.getAttributeDeclaration((Name)comparable);
                            }
                            if (serializable != null) break;
                            n = 1;
                            break;
                        }
                        default: {
                            serializable = this.getAttributeDeclaration((Name)comparable);
                            if (serializable != null) break;
                            serializable = schema.getAttributeDeclaration((Name)comparable);
                        }
                    }
                }
                if (serializable == null) {
                    if (n != 0) continue;
                    if (bl3 || bl2) {
                        validationErrors.append(element, "cvc-attribute.1", Msg.msg("undeclaredAttribute", ((Name)comparable).format(true, element)));
                    } else {
                        validationErrors.append(element, "cvc-complex-type.3", Msg.msg("notAnAttribute", ((Name)comparable).format(true, element)));
                    }
                    object = null;
                    continue;
                }
                if (((AttributeDeclaration)serializable).validate(attribute.value, element, schema, validationErrors) == null) {
                    ValidationError validationError = validationErrors.getLast();
                    validationErrors.setLast(new ValidationError(element, validationError.constraint, validationError.message));
                    object = null;
                }
                if (bl3 || !(((AttributeDeclaration)serializable).dataType instanceof IDType)) continue;
                ++n5;
            }
        }
        if (n5 > 1) {
            validationErrors.append(element, "cvc-complex-type.5.1", Msg.msg("severalIDAttributes"));
            object = null;
        }
        boolean bl4 = false;
        for (n2 = 0; n2 < this.attributeUses.length; ++n2) {
            comparable = this.attributeUses[n2];
            serializable = ((AttributeUse)comparable).name;
            if (((AttributeUse)comparable).isRequired && element.getAttribute((Name)serializable) == null) {
                validationErrors.append(element, "cvc-complex-type.4", Msg.msg("missingRequiredAttribute", serializable.format(true, element)));
                object = null;
            }
            if (n5 != true || bl4) continue;
            AttributeDeclaration attributeDeclaration = this.getAttributeDeclaration((Name)serializable);
            if (attributeDeclaration == null) {
                attributeDeclaration = schema.getAttributeDeclaration((Name)serializable);
            }
            if (attributeDeclaration == null || !(attributeDeclaration.dataType instanceof IDType)) continue;
            bl4 = true;
        }
        if (n5 == 1 && bl4) {
            validationErrors.append(element, "cvc-complex-type.5.2", Msg.msg("idAttributeSuppliedByWildcard"));
            object = null;
        }
        if (bl) {
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != Node.Type.ELEMENT) continue;
                Element element2 = (Element)node;
                comparable = element2.getName();
                serializable = null;
                boolean bl5 = false;
                for (n = 0; n < this.elementFields.length; ++n) {
                    if (comparable != this.elementFields[n]) continue;
                    bl5 = true;
                    serializable = this.getElementDeclaration((Name)comparable);
                    if (serializable != null) break;
                    serializable = schema.getElementDeclaration((Name)comparable);
                    break;
                }
                n = 0;
                bl2 = false;
                if (!bl5) {
                    block30: for (int i = 0; i < this.elementWildcards.length; ++i) {
                        Wildcard wildcard = this.elementWildcards[i];
                        if (!wildcard.match((Name)comparable)) continue;
                        bl2 = true;
                        switch (wildcard.processContents) {
                            case SKIP: {
                                n = 1;
                                break;
                            }
                            case LAX: {
                                serializable = this.getElementDeclaration((Name)comparable);
                                if (serializable == null) {
                                    serializable = schema.getElementDeclaration((Name)comparable);
                                }
                                if (serializable != null) break block30;
                                n = 1;
                                break;
                            }
                            default: {
                                serializable = this.getElementDeclaration((Name)comparable);
                                if (serializable != null) break block30;
                                serializable = schema.getElementDeclaration((Name)comparable);
                                break;
                            }
                        }
                        break;
                    }
                }
                if (serializable == null) {
                    if (n != 0) continue;
                    if (bl5 || bl2) {
                        validationErrors.append(element, "cvc-elt.1", Msg.msg("undeclaredChild", ((Name)comparable).format(false, element)));
                    } else {
                        validationErrors.append(element, "cvc-complex-type", Msg.msg("notAChild", ((Name)comparable).format(false, element)));
                    }
                    object = null;
                    continue;
                }
                if (((ElementDeclaration)serializable).validate(element2, true, schema, validationErrors) != null) continue;
                object = null;
            }
        }
        return object;
    }

    public final boolean checkNameSequence(Name[] nameArray, int n) {
        if (this.nameRE == null) {
            try {
                this.nameRE = new NameRE(this.particle);
            }
            catch (NameRE.InvalidParticleException invalidParticleException) {
                invalidParticleException.printStackTrace();
            }
        }
        return this.nameRE.match(nameArray, n);
    }

    @Override
    public boolean isValidDerivation(Type type, int n) {
        if (this == type) {
            return true;
        }
        if ((n & this.derivationMethod) != 0) {
            return false;
        }
        if (this.baseType == null) {
            return false;
        }
        if (this.baseType == type) {
            return true;
        }
        return this.baseType != ANY && this.baseType.isValidDerivation(type, n);
    }

    public static enum ContentType {
        EMPTY,
        DATA,
        ELEMENT_ONLY,
        MIXED;

    }
}

