/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.InvalidTypeException;
import com.xmlmind.xml.wxs.datatype.Pattern;
import com.xmlmind.xml.wxs.datatype.QNameValue;
import com.xmlmind.xml.wxs.datatype.Restriction;
import com.xmlmind.xml.wxs.datatype.Value;
import com.xmlmind.xml.wxs.load.FacetInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.Msg;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.WXSchema;
import java.util.ArrayList;

abstract class TypeInfo
extends Info {
    protected TypeInfo(Info info) {
        super(info);
    }

    public abstract Type toType(LoadState var1);

    protected static boolean checkNotations(DataType dataType, Info info, String string, LoadState loadState) {
        boolean bl = true;
        WXSchema wXSchema = loadState.schema;
        Value[] valueArray = dataType.getEnumeration();
        for (int i = 0; i < valueArray.length; ++i) {
            Name name = ((QNameValue)valueArray[i]).getName();
            if (wXSchema.getNotation(name) != null) continue;
            bl = false;
            loadState.errors.append(info, string, "undeclaredNotation", name.format(false, info));
        }
        return bl;
    }

    protected static void applyFacets(Restriction restriction, FacetInfo[] facetInfoArray) throws InvalidDataException, InvalidTypeException {
        StringBuilder stringBuilder = null;
        ArrayList<Value> arrayList = null;
        block16: for (int i = 0; i < facetInfoArray.length; ++i) {
            FacetInfo facetInfo = facetInfoArray[i];
            switch (facetInfo.facet) {
                case 1: {
                    restriction.setLength(TypeInfo.parseNonNegativeInt(facetInfo.value, "length"), facetInfo.fixed);
                    continue block16;
                }
                case 2: {
                    restriction.setMinLength(TypeInfo.parseNonNegativeInt(facetInfo.value, "minLength"), facetInfo.fixed);
                    continue block16;
                }
                case 4: {
                    restriction.setMaxLength(TypeInfo.parseNonNegativeInt(facetInfo.value, "maxLength"), facetInfo.fixed);
                    continue block16;
                }
                case 8: {
                    int n = facetInfo.value.length();
                    if (n == 0) continue block16;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    } else {
                        stringBuilder.append('|');
                    }
                    stringBuilder.append('(');
                    stringBuilder.append(facetInfo.value);
                    stringBuilder.append(')');
                    continue block16;
                }
                case 16: {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Value>();
                    }
                    arrayList.add(restriction.getBaseType().valueOf(facetInfo.value, facetInfo));
                    continue block16;
                }
                case 32: {
                    restriction.setWhiteSpace(TypeInfo.parseWhiteSpace(facetInfo.value), facetInfo.fixed);
                    continue block16;
                }
                case 64: {
                    restriction.setMaxInclusive(facetInfo.value, facetInfo, null, facetInfo.fixed);
                    continue block16;
                }
                case 128: {
                    restriction.setMaxExclusive(facetInfo.value, facetInfo, null, facetInfo.fixed);
                    continue block16;
                }
                case 256: {
                    restriction.setMinExclusive(facetInfo.value, facetInfo, null, facetInfo.fixed);
                    continue block16;
                }
                case 512: {
                    restriction.setMinInclusive(facetInfo.value, facetInfo, null, facetInfo.fixed);
                    continue block16;
                }
                case 1024: {
                    restriction.setTotalDigits(TypeInfo.parseNonNegativeInt(facetInfo.value, "totalDigits"), facetInfo.fixed);
                    continue block16;
                }
                case 2048: {
                    restriction.setFractionDigits(TypeInfo.parseNonNegativeInt(facetInfo.value, "fractionDigits"), facetInfo.fixed);
                }
            }
        }
        if (stringBuilder != null) {
            Pattern pattern;
            try {
                pattern = new Pattern(stringBuilder.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(Msg.msg("invalidFacet2", stringBuilder.toString(), "pattern", illegalArgumentException.getMessage()));
            }
            restriction.setPattern(pattern);
        }
        if (arrayList != null) {
            Value[] valueArray = new Value[arrayList.size()];
            arrayList.toArray(valueArray);
            restriction.setEnumeration(valueArray);
        }
    }

    protected static DataType.WhiteSpace parseWhiteSpace(String string) {
        if ((string = string.trim()).equals("preserve")) {
            return DataType.WhiteSpace.PRESERVE;
        }
        if (string.equals("replace")) {
            return DataType.WhiteSpace.REPLACE;
        }
        if (string.equals("collapse")) {
            return DataType.WhiteSpace.COLLAPSE;
        }
        throw new IllegalArgumentException(Msg.msg("invalidFacet", string, "whiteSpace"));
    }

    protected static int parseNonNegativeInt(String string, String string2) {
        int n = -1;
        string = string.trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 0) {
            throw new IllegalArgumentException(Msg.msg("invalidFacet", string, string2));
        }
        return n;
    }
}

