/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.load.LoadError;
import java.net.URL;

public final class SchemaError
implements LoadError {
    public final Element element;
    public final String constraint;
    public final String message;

    public SchemaError(Element element, String string, String string2) {
        this.element = element;
        this.constraint = string;
        this.message = string2;
    }

    public URL getLocation() {
        return this.element.getSourceURL();
    }

    public int getLineNumber() {
        int[] nArray = (int[])this.element.getProperty(Constants.LINE_COLUMN_PROPERTY);
        return nArray == null ? -1 : nArray[0];
    }

    public int getColumnNumber() {
        int[] nArray = (int[])this.element.getProperty(Constants.LINE_COLUMN_PROPERTY);
        return nArray == null ? -1 : nArray[1];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLocation());
        stringBuilder.append(':');
        int n = this.getLineNumber();
        if (n >= 0) {
            stringBuilder.append(n);
        }
        stringBuilder.append(':');
        n = this.getColumnNumber();
        if (n >= 0) {
            stringBuilder.append(n);
        }
        stringBuilder.append(": ");
        stringBuilder.append(this.message);
        if (this.constraint != null) {
            stringBuilder.append(" [");
            stringBuilder.append(this.constraint);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public LoadError.Type getErrorType() {
        return LoadError.Type.DOCUMENT_TYPE;
    }

    @Override
    public URL getErrorLocation() {
        return this.getLocation();
    }

    @Override
    public int getErrorLineNumber() {
        return this.getLineNumber();
    }

    @Override
    public int getErrorColumnNumber() {
        return this.getColumnNumber();
    }

    @Override
    public Node getNodeInError() {
        return this.element;
    }

    @Override
    public String getErrorMessage() {
        if (this.constraint == null) {
            return this.message;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.message);
        stringBuilder.append(" [");
        stringBuilder.append(this.constraint);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

