/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.wxs.load.AllInfo;
import com.xmlmind.xml.wxs.load.AnyInfo;
import com.xmlmind.xml.wxs.load.ChoiceInfo;
import com.xmlmind.xml.wxs.load.ElementInfo;
import com.xmlmind.xml.wxs.load.GroupInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.SequenceInfo;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.Particle;
import java.util.IdentityHashMap;

abstract class ModelGroupInfo
extends Info {
    public Info[] particleInfo = null;
    public int minOccurs = 1;
    public int maxOccurs = 1;
    private static final Info[] NO_PARTICLE_INFO = new Info[0];

    protected ModelGroupInfo(Info info) {
        super(info);
    }

    public void add(Info info) {
        if (this.particleInfo == null) {
            this.particleInfo = new Info[]{info};
        } else {
            Info[] infoArray = new Info[this.particleInfo.length + 1];
            System.arraycopy(this.particleInfo, 0, infoArray, 0, this.particleInfo.length);
            infoArray[this.particleInfo.length] = info;
            this.particleInfo = infoArray;
        }
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.minOccurs = ModelGroupInfo.getNonNegativeIntAttribute(element, _MIN_OCCURS, 1);
        this.maxOccurs = ModelGroupInfo.getMaxOccursAttribute(element, _MAX_OCCURS, 1);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Info info;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_ELEMENT) {
                info = new ElementInfo(this);
                ((ElementInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add(info);
                continue;
            }
            if (name == XSD_SEQUENCE) {
                info = new SequenceInfo(this);
                ((ModelGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add(info);
                continue;
            }
            if (name == XSD_CHOICE) {
                info = new ChoiceInfo(this);
                ((ModelGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add(info);
                continue;
            }
            if (name == XSD_ALL) {
                info = new AllInfo(this);
                ((ModelGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add(info);
                continue;
            }
            if (name == XSD_GROUP) {
                info = new GroupInfo(this);
                ((GroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add(info);
                continue;
            }
            if (name != XSD_ANY) continue;
            info = new AnyInfo(this);
            ((AnyInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            this.add(info);
        }
    }

    @Override
    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        if (!this.checkOccurs(this.minOccurs, this.maxOccurs, loadState)) {
            return false;
        }
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            particleArray[n] = null;
            return true;
        }
        Info[] infoArray = this.particleInfo;
        if (infoArray == null) {
            infoArray = NO_PARTICLE_INFO;
        }
        Particle[] particleArray2 = new Particle[infoArray.length];
        int n2 = 0;
        for (int i = 0; i < infoArray.length; ++i) {
            if (!infoArray[i].toParticle(particleArray2, n2, loadState)) {
                return false;
            }
            if (particleArray2[n2] == null) continue;
            ++n2;
        }
        if (n2 == 0) {
            particleArray[n] = null;
        } else {
            if (n2 != particleArray2.length) {
                Particle[] particleArray3 = new Particle[n2];
                System.arraycopy(particleArray2, 0, particleArray3, 0, n2);
                particleArray2 = particleArray3;
            }
            particleArray[n] = this.createParticle(particleArray2, this.minOccurs, this.maxOccurs, loadState);
            if (particleArray[n] == null) {
                return false;
            }
        }
        return true;
    }

    protected abstract Particle createParticle(Particle[] var1, int var2, int var3, LoadState var4);

    @Override
    public boolean toParticle2(IdentityHashMap<Name, ElementDeclaration> identityHashMap, LoadState loadState) {
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            return true;
        }
        if (this.particleInfo != null) {
            for (int i = 0; i < this.particleInfo.length; ++i) {
                if (this.particleInfo[i].toParticle2(identityHashMap, loadState)) continue;
                return false;
            }
        }
        return true;
    }
}

