/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.util.LinearHashtable;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import java.net.URL;
import java.util.IdentityHashMap;
import java.util.Stack;

final class LoadContext {
    private IdentityHashMap<Namespace, LinearHashtable<URL, SchemaInfo>> importedSchemas = new IdentityHashMap();
    private Stack<URL> schemasBeingLoaded = new Stack();

    LoadContext() {
    }

    public void registerImportedSchema(Namespace namespace, URL uRL, SchemaInfo schemaInfo) {
        LinearHashtable<URL, SchemaInfo> linearHashtable = this.importedSchemas.get(namespace);
        if (linearHashtable == null) {
            linearHashtable = new LinearHashtable();
            this.importedSchemas.put(namespace, linearHashtable);
        }
        linearHashtable.put(uRL, schemaInfo);
    }

    public LinearHashtable<URL, SchemaInfo> getImportedSchemas(Namespace namespace) {
        return this.importedSchemas.get(namespace);
    }

    public void pushSchemaBeingLoaded(URL uRL) {
        this.schemasBeingLoaded.push(uRL);
    }

    public void popSchemaBeingLoaded() {
        this.schemasBeingLoaded.pop();
    }

    public boolean isSchemaBeingLoaded(URL uRL) {
        return this.schemasBeingLoaded.search(uRL) != -1;
    }
}

