/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.sxpath.Path;
import com.xmlmind.xml.sxpath.XPath;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.validate.IdentityConstraint;

abstract class IdentityConstraintInfo
extends Info {
    public XPath selector = null;
    public XPath[] fields = null;

    protected IdentityConstraintInfo(Info info) {
        super(info);
    }

    public void add(XPath xPath) {
        if (this.fields == null) {
            this.fields = new XPath[]{xPath};
        } else {
            XPath[] xPathArray = new XPath[this.fields.length + 1];
            System.arraycopy(this.fields, 0, xPathArray, 0, this.fields.length);
            xPathArray[this.fields.length] = xPath;
            this.fields = xPathArray;
        }
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.name = IdentityConstraintInfo.getNCNameAttribute(element, _NAME, schemaInfo.targetNamespace, null);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_FIELD) {
                string = element2.getAttribute(_XPATH);
                if (string == null) continue;
                XPath xPath = XPath.fromString(string, element2);
                if (xPath == null || !IdentityConstraintInfo.checkXPath(xPath, false)) {
                    schemaErrors2.append(this, "c-fields-xpaths", "invalidXPath", string);
                    continue;
                }
                this.add(xPath);
                continue;
            }
            if (name != XSD_SELECTOR || (string = element2.getAttribute(_XPATH)) == null) continue;
            this.selector = XPath.fromString(string, element2);
            if (this.selector != null && IdentityConstraintInfo.checkXPath(this.selector, true)) continue;
            schemaErrors2.append(this, "c-selector-xpath", "invalidXPath", string);
        }
    }

    private static boolean checkXPath(XPath xPath, boolean bl) {
        Path[] pathArray = xPath.getPaths();
        for (int i = 0; i < pathArray.length; ++i) {
            Path path = pathArray[i];
            if (!path.isAbsolute() && (!bl || !path.isSelectingAttributes())) continue;
            return false;
        }
        return true;
    }

    protected boolean sameXPaths(IdentityConstraintInfo identityConstraintInfo) {
        if (this.selector == null && identityConstraintInfo.selector != null || this.selector != null && !this.selector.equals(identityConstraintInfo.selector)) {
            return false;
        }
        if (this.fields == null || identityConstraintInfo.fields == null) {
            return this.fields == identityConstraintInfo.fields;
        }
        if (this.fields.length != identityConstraintInfo.fields.length) {
            return false;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            XPath xPath = this.fields[i];
            boolean bl = false;
            for (int j = 0; j < identityConstraintInfo.fields.length; ++j) {
                if (!xPath.equals(identityConstraintInfo.fields[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public abstract IdentityConstraint toIdentityConstraint(LoadState var1);
}

