/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.regex.RegexSyntaxException;
import com.xmlmind.xml.wxs.datatype.regex.Translator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.regex.PatternSyntaxException;

public final class Pattern
implements Serializable {
    private final String pattern;
    private transient java.util.regex.Pattern regexp;

    public Pattern(String string) {
        this.pattern = string;
        this.regexp = Pattern.createRegexp(string);
    }

    private static java.util.regex.Pattern createRegexp(String string) {
        try {
            return java.util.regex.Pattern.compile(Translator.translate(string));
        }
        catch (RegexSyntaxException regexSyntaxException) {
            throw new IllegalArgumentException(regexSyntaxException.getMessage());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException(patternSyntaxException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.regexp = Pattern.createRegexp(this.pattern);
    }

    public boolean matches(String string) {
        return this.regexp.matcher(string).matches();
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Pattern)) {
            return false;
        }
        return this.pattern.equals(((Pattern)object).pattern);
    }

    public String toString() {
        return this.pattern;
    }
}

