/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.util.StringUtil;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.validate.ListDataType;
import com.xmlmind.xml.validate.UnparsedEntities;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.InvalidTypeException;
import com.xmlmind.xml.wxs.datatype.ListValue;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.NonStringType;
import com.xmlmind.xml.wxs.datatype.UnionType;
import com.xmlmind.xml.wxs.datatype.Value;

public class ListType
extends NonStringType
implements ListDataType {
    protected DataType itemType;
    private static final ListValue EMPTY_LIST = new ListValue(new Value[0]);

    public ListType(DataType dataType) {
        this.itemType = dataType;
    }

    public DataType getItemType() {
        return this.itemType;
    }

    @Override
    public int getSupportedFacets() {
        return 63;
    }

    @Override
    public void checkFacets() throws InvalidTypeException {
        if (ListType.findListType(this.itemType)) {
            throw new InvalidTypeException("cos-list-of-atomic", Msg.msg("nonAtomicListItem"));
        }
    }

    private static final boolean findListType(DataType dataType) {
        if (dataType instanceof ListType) {
            return true;
        }
        if (dataType instanceof UnionType) {
            DataType[] dataTypeArray = ((UnionType)dataType).getMemberTypes();
            for (int i = 0; i < dataTypeArray.length; ++i) {
                DataType dataType2 = dataTypeArray[i];
                if (!ListType.findListType(dataType2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected int rootTypeHashCode() {
        return this.itemType.hashCode();
    }

    @Override
    protected boolean sameRootType(DataType dataType) {
        if (!(dataType instanceof ListType)) {
            return false;
        }
        return this.itemType.equals(((ListType)dataType).itemType);
    }

    @Override
    protected Value doParse(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException {
        if (string.length() == 0) {
            return EMPTY_LIST;
        }
        String[] stringArray = StringUtil.split(string, ' ');
        Value[] valueArray = new Value[stringArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = this.itemType.parse(stringArray[i], prefixToNamespace, unparsedEntities);
        }
        return new ListValue(valueArray);
    }

    @Override
    public boolean isContextDependentDataType() {
        return this.itemType.isContextDependentDataType();
    }

    @Override
    public String getDataTypeLabel(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Msg.msg("list"));
        stringBuilder.append(" ");
        stringBuilder.append(this.itemType.getDataTypeLabel(namespaceToPrefixes));
        UnionType.appendEnumeration(this.itemType, namespaceToPrefixes, stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public com.xmlmind.xml.validate.DataType getItemDataType() {
        return this.itemType;
    }

    @Override
    public int getListMinLength() {
        if ((this.facets & 2) != 0) {
            return this.minLength;
        }
        return 0;
    }

    @Override
    public int getListMaxLength() {
        if ((this.facets & 4) != 0) {
            return this.maxLength;
        }
        return -1;
    }
}

