/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.NumericValue;
import com.xmlmind.xml.wxs.datatype.Value;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntegerValue
extends NumericValue {
    private final BigInteger number;

    public static IntegerValue parseInteger(String string) throws InvalidDataException {
        BigInteger bigInteger;
        if (string.length() > 0 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        try {
            bigInteger = new BigInteger(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("integerSyntax", string));
        }
        return new IntegerValue(bigInteger);
    }

    public IntegerValue(BigInteger bigInteger) {
        this.number = bigInteger;
    }

    public BigInteger getBigInteger() {
        return this.number;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.number, 0);
    }

    @Override
    public String toString() {
        return this.number.toString();
    }

    @Override
    public int hashCode() {
        return this.number.intValue();
    }

    @Override
    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        if (value instanceof IntegerValue) {
            BigInteger bigInteger = ((IntegerValue)value).number;
            return this.number.compareTo(bigInteger);
        }
        return this.toBigDecimal().compareTo(((NumericValue)value).toBigDecimal());
    }

    @Override
    public int totalDigits() {
        return this.number.toString().length();
    }

    @Override
    public int fractionDigits() {
        return 0;
    }
}

