/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.DateTimeUtil;
import com.xmlmind.xml.wxs.datatype.DateTimeValue;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.Value;
import java.util.Date;
import java.util.TimeZone;

public class GYearMonthValue
extends Value {
    private final DateTimeValue dateTime;

    public static GYearMonthValue parseGYearMonth(String string) throws InvalidDataException {
        GYearMonthValue gYearMonthValue;
        int n;
        int[] nArray = new int[3];
        int n2 = string.length();
        if (n2 == 0) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gYearMonthSyntax", string));
        }
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(n3) == '-') {
            bl = true;
            ++n3;
        }
        if ((n = string.indexOf(45, n3)) < n3 + 4) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gYearMonthSyntax", string));
        }
        int n4 = DateTimeUtil.parseInt(string, n3, n);
        if (bl) {
            n4 = -n4;
        }
        if ((n = DateTimeUtil.parseTimeZone(string, n3 = n + 1, nArray)) != n3 + 2) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gYearMonthSyntax", string));
        }
        int n5 = DateTimeUtil.parseInt(string, n3, n);
        try {
            gYearMonthValue = new GYearMonthValue(n4, n5, nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gYearMonthSyntax", string));
        }
        return gYearMonthValue;
    }

    public GYearMonthValue(int n, int n2, int n3, int n4, int n5) {
        this.dateTime = new DateTimeValue();
        this.dateTime.day = 1;
        this.dateTime.hour = 0;
        this.dateTime.minute = 0;
        this.dateTime.second = 0.0;
        if (n == 0) {
            throw new IllegalArgumentException("no year 0000");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("invalid month");
        }
        switch (n3) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tzSign");
            }
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException("invalid tzHour");
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException("invalid tzMinute");
        }
        if (n3 == -1 && n4 == 0 && n5 == 0) {
            n3 = 1;
        }
        this.dateTime.year = n;
        this.dateTime.month = (byte)n2;
        this.dateTime.tzSign = (byte)n3;
        this.dateTime.tzHour = (byte)n4;
        this.dateTime.tzMinute = (byte)n5;
    }

    private GYearMonthValue(DateTimeValue dateTimeValue) {
        this.dateTime = dateTimeValue;
    }

    public DateTimeValue getDateTime() {
        return this.dateTime;
    }

    public Date toDate() {
        return this.toDate(null);
    }

    public Date toDate(TimeZone timeZone) {
        return this.dateTime.toDate(timeZone);
    }

    public static GYearMonthValue fromDate(Date date) {
        return GYearMonthValue.fromDate(date, false, null);
    }

    public static GYearMonthValue fromDate(Date date, boolean bl, TimeZone timeZone) {
        DateTimeValue dateTimeValue = DateTimeValue.fromDate(date, bl, timeZone);
        dateTimeValue.day = 1;
        dateTimeValue.hour = 0;
        dateTimeValue.minute = 0;
        dateTimeValue.second = 0.0;
        return new GYearMonthValue(dateTimeValue);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.dateTime.year < 0) {
            stringBuilder.append('-');
            DateTimeUtil.appendPadded(-this.dateTime.year, 4, stringBuilder);
        } else {
            DateTimeUtil.appendPadded(this.dateTime.year, 4, stringBuilder);
        }
        stringBuilder.append('-');
        DateTimeUtil.appendPadded(this.dateTime.month, 2, stringBuilder);
        DateTimeUtil.appendTimeZone(this.dateTime.tzSign, this.dateTime.tzHour, this.dateTime.tzMinute, stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        return this.dateTime.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof GYearMonthValue)) {
            return false;
        }
        GYearMonthValue gYearMonthValue = (GYearMonthValue)object;
        return this.dateTime.equals(gYearMonthValue.dateTime);
    }

    @Override
    public int compareTo(Value value) {
        if (value == null || !(value instanceof GYearMonthValue)) {
            return -2;
        }
        GYearMonthValue gYearMonthValue = (GYearMonthValue)value;
        return this.dateTime.compareTo(gYearMonthValue.dateTime);
    }
}

