/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.Value;

public class FloatValue
extends Value {
    public static final FloatValue NaN = new FloatValue(Float.NaN);
    public static final FloatValue POSITIVE_INFINITY = new FloatValue(Float.POSITIVE_INFINITY);
    public static final FloatValue NEGATIVE_INFINITY = new FloatValue(Float.NEGATIVE_INFINITY);
    private final float number;

    public static FloatValue parseFloat(String string) throws InvalidDataException {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (Exception exception) {
            if (string.equals("NaN")) {
                return NaN;
            }
            if (string.equals("INF")) {
                return POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                return NEGATIVE_INFINITY;
            }
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("floatSyntax", string));
        }
        return new FloatValue(f);
    }

    public FloatValue(float f) {
        this.number = f;
    }

    public float getFloat() {
        return this.number;
    }

    @Override
    public String toString() {
        if (this.number == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (this.number == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return Float.toString(this.number);
    }

    @Override
    public int hashCode() {
        return (int)this.number;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof FloatValue)) {
            return false;
        }
        FloatValue floatValue = (FloatValue)object;
        return this.number == floatValue.number;
    }

    @Override
    public int compareTo(Value value) {
        if (value == null || !(value instanceof FloatValue)) {
            return -2;
        }
        FloatValue floatValue = (FloatValue)value;
        return this.number < floatValue.number ? -1 : (this.number > floatValue.number ? 1 : 0);
    }
}

