/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.StringList;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.validate.AttributeDefaultValue;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.AttributeUtil;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.DiagnosticImpl;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.IdEntry;
import com.xmlmind.xml.validate.IdRefItem;
import com.xmlmind.xml.validate.Item;
import com.xmlmind.xml.validate.Msg;
import com.xmlmind.xml.validate.SchemaKind;
import com.xmlmind.xml.validate.Structure;
import com.xmlmind.xml.validate.SubDocumentType;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class MultiDocumentType
implements DocumentType {
    public final SubDocumentType mainDocumentType;
    public final SubDocumentType[] auxDocumentTypes;
    public final Namespace[] auxNamespaces;
    public final URL[] schemaURLs;
    public final PrefixEntry[] schemaDeclaredPrefixes;
    private boolean checkIDs = false;
    private SubDocumentType subDocumentType = null;
    private ValidationRoots validationRoots = new ValidationRoots();

    public MultiDocumentType(SubDocumentType subDocumentType, SubDocumentType[] subDocumentTypeArray, Namespace[] namespaceArray) {
        int n;
        PrefixEntry[] prefixEntryArray;
        this.mainDocumentType = subDocumentType;
        this.auxDocumentTypes = subDocumentTypeArray;
        this.auxNamespaces = namespaceArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        URL[] uRLArray = subDocumentType.getSchemaURLs();
        if (uRLArray != null) {
            for (int i = 0; i < uRLArray.length; ++i) {
                arrayList.add(uRLArray[i]);
            }
        }
        if ((prefixEntryArray = subDocumentType.getSchemaDeclaredPrefixes()) != null) {
            for (n = 0; n < prefixEntryArray.length; ++n) {
                arrayList2.add(prefixEntryArray[n]);
            }
        }
        for (n = 0; n < subDocumentTypeArray.length; ++n) {
            Serializable serializable;
            int n2;
            SubDocumentType subDocumentType2 = subDocumentTypeArray[n];
            uRLArray = subDocumentType2.getSchemaURLs();
            if (uRLArray != null) {
                for (n2 = 0; n2 < uRLArray.length; ++n2) {
                    serializable = uRLArray[n2];
                    if (arrayList.contains(serializable)) continue;
                    arrayList.add((URL)serializable);
                }
            }
            if ((prefixEntryArray = subDocumentType2.getSchemaDeclaredPrefixes()) == null) continue;
            for (n2 = 0; n2 < prefixEntryArray.length; ++n2) {
                serializable = prefixEntryArray[n2];
                if (arrayList2.contains(serializable)) continue;
                arrayList2.add(serializable);
            }
        }
        n = arrayList.size();
        if (n == 0) {
            this.schemaURLs = null;
        } else {
            this.schemaURLs = new URL[n];
            arrayList.toArray(this.schemaURLs);
        }
        n = arrayList2.size();
        if (n == 0) {
            this.schemaDeclaredPrefixes = null;
        } else {
            this.schemaDeclaredPrefixes = new PrefixEntry[n];
            arrayList2.toArray(this.schemaDeclaredPrefixes);
        }
    }

    public void setCheckIDs(boolean bl) {
        this.checkIDs = bl;
    }

    public boolean getCheckIDs() {
        return this.checkIDs;
    }

    public ValidationRoot getValidationRoot(Element element) {
        Element element2 = this.doGetValidationRoot(element);
        return new ValidationRoot(element2, this.subDocumentType);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MultiDocumentType)) {
            return false;
        }
        MultiDocumentType multiDocumentType = (MultiDocumentType)object;
        if (this.mainDocumentType != multiDocumentType.mainDocumentType) {
            return false;
        }
        int n = this.auxDocumentTypes.length;
        if (n != multiDocumentType.auxDocumentTypes.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.auxDocumentTypes[i] == multiDocumentType.auxDocumentTypes[i] && this.auxNamespaces[i] == multiDocumentType.auxNamespaces[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public SchemaKind getSchemaKind() {
        return this.mainDocumentType.getSchemaKind();
    }

    @Override
    public Namespace[] getTargetNamespaces() {
        return this.mainDocumentType.getTargetNamespaces();
    }

    @Override
    public URL[] getSchemaURLs() {
        return this.schemaURLs;
    }

    @Override
    public PrefixEntry[] getSchemaDeclaredPrefixes() {
        return this.schemaDeclaredPrefixes;
    }

    @Override
    public Diagnostic[] checkDocument(Document document) {
        int n;
        Diagnostic[] diagnosticArray = null;
        Element element = document.getRootElement();
        this.collectValidationRoots(element);
        int n2 = this.validationRoots.size;
        ValidationRoot[] validationRootArray = this.validationRoots.list;
        block0: for (int i = 0; i < n2; ++i) {
            ValidationRoot validationRoot = validationRootArray[i];
            Diagnostic[] object = validationRoot.subDocumentType.checkDocument(validationRoot.validationRoot);
            if (diagnosticArray == null) {
                int n3 = object.length;
                diagnosticArray = new Diagnostic[n3];
                System.arraycopy(object, 0, diagnosticArray, 0, n3);
                for (n = 0; n < n3; ++n) {
                    if (object[n].getDiagnosticSeverity() == Diagnostic.Severity.INVALID_STRUCTURE) break block0;
                }
                continue;
            }
            diagnosticArray = ArrayUtil.insert(diagnosticArray, diagnosticArray.length, object);
        }
        if (this.checkIDs && (diagnosticArray == null || diagnosticArray.length == 0)) {
            diagnosticArray = null;
            HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
            MultiDocumentType.doCollectIds(element, this.validationRoots, hashMap);
            for (IdEntry idEntry : hashMap.values()) {
                if (idEntry.elements.length <= 1) continue;
                Element[] elementArray = idEntry.elements;
                for (n = 1; n < elementArray.length; ++n) {
                    DiagnosticImpl diagnosticImpl = new DiagnosticImpl(elementArray[n], Msg.msg("MDT.multiplyDefinedID", idEntry.id), Diagnostic.Severity.INVALID_REFERENCE, "DUPLICATE_ID", idEntry.id);
                    diagnosticArray = diagnosticArray == null ? new Diagnostic[]{diagnosticImpl} : (Diagnostic[])ArrayUtil.append(diagnosticArray, diagnosticImpl);
                }
            }
            if (diagnosticArray == null) {
                diagnosticArray = DiagnosticImpl.NO_DIAGNOSTICS;
            }
        }
        this.validationRoots.clear();
        return diagnosticArray;
    }

    @Override
    public Name[] getRootElementNames() {
        return this.mainDocumentType.getRootElementNames();
    }

    @Override
    public ElementType[] getElementType(Name name) {
        int n;
        ArrayList arrayList = new ArrayList();
        ElementType[] elementTypeArray = this.mainDocumentType.getElementType(name);
        if (elementTypeArray != null) {
            Collections.addAll(arrayList, elementTypeArray);
        }
        SubDocumentType[] subDocumentTypeArray = this.auxDocumentTypes;
        int n2 = subDocumentTypeArray.length;
        for (n = 0; n < n2; ++n) {
            SubDocumentType subDocumentType = subDocumentTypeArray[n];
            elementTypeArray = subDocumentType.getElementType(name);
            if (elementTypeArray == null) continue;
            Collections.addAll(arrayList, elementTypeArray);
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            return null;
        }
        ElementType[] elementTypeArray2 = new ElementType[n3];
        for (n = 0; n < n3; ++n) {
            elementTypeArray2[n] = new ElementTypeWrapper((ElementType)arrayList.get(n));
        }
        return elementTypeArray2;
    }

    @Override
    public ElementType getElementType(Element element) {
        Document document = element.getDocument();
        if (document == null) {
            return null;
        }
        Element element2 = this.doGetValidationRoot(element);
        ElementType elementType = this.subDocumentType.getElementType(element, element2);
        if (elementType == null) {
            return null;
        }
        return new ElementTypeWrapper(elementType);
    }

    @Override
    public String getElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        Document document = element.getDocument();
        if (document == null) {
            return AttributeUtil.getAttribute(element, name, attributeDefaultValue);
        }
        Element element2 = this.doGetValidationRoot(element);
        return this.subDocumentType.getElementAttribute(element, element2, name, attributeDefaultValue);
    }

    @Override
    public String lookupElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        Document document = element.getDocument();
        if (document == null) {
            return AttributeUtil.lookupAttribute(element, name, attributeDefaultValue);
        }
        Element element2 = this.doGetValidationRoot(element);
        return this.subDocumentType.lookupElementAttribute(element, element2, name, attributeDefaultValue);
    }

    @Override
    public Element[] findElementById(Element element, String string, boolean bl) {
        Document document = element.getDocument();
        if (document == null) {
            return null;
        }
        this.collectValidationRoots(element);
        int n = this.validationRoots.size;
        ValidationRoot[] validationRootArray = this.validationRoots.list;
        ValidationRoot validationRoot = validationRootArray[0];
        Element[] elementArray = validationRoot.subDocumentType.findElementById(element, validationRoot.validationRoot, string, bl);
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                validationRoot = validationRootArray[i];
                Element[] elementArray2 = validationRoot.subDocumentType.findElementById(validationRoot.validationRoot, validationRoot.validationRoot, string, bl);
                if (elementArray2 == null) continue;
                if (elementArray == null) {
                    elementArray = elementArray2;
                    continue;
                }
                for (int j = 0; j < elementArray2.length; ++j) {
                    if (ArrayUtil.find(elementArray, elementArray2[j]) >= 0) continue;
                    elementArray = ArrayUtil.append(elementArray, elementArray2[j]);
                }
            }
        }
        this.validationRoots.clear();
        return elementArray;
    }

    @Override
    public void collectIds(Element element, Map<String, IdEntry> map) {
        Document document = element.getDocument();
        if (document == null) {
            return;
        }
        this.collectValidationRoots(element);
        MultiDocumentType.doCollectIds(element, this.validationRoots, map);
        this.validationRoots.clear();
    }

    private static void doCollectIds(Element element, ValidationRoots validationRoots, Map<String, IdEntry> map) {
        int n = validationRoots.size;
        ValidationRoot[] validationRootArray = validationRoots.list;
        ValidationRoot validationRoot = validationRootArray[0];
        validationRoot.subDocumentType.collectIds(element, validationRoot.validationRoot, map);
        if (n > 1) {
            HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
            for (int i = 1; i < n; ++i) {
                validationRoot = validationRootArray[i];
                hashMap.clear();
                validationRoot.subDocumentType.collectIds(validationRoot.validationRoot, validationRoot.validationRoot, hashMap);
                for (IdEntry idEntry : hashMap.values()) {
                    IdEntry idEntry2 = map.get(idEntry.id);
                    if (idEntry2 == null) {
                        map.put(idEntry.id, idEntry);
                        continue;
                    }
                    Element[] elementArray = idEntry.elements;
                    for (int j = 0; j < elementArray.length; ++j) {
                        Element element2 = elementArray[j];
                        if (MultiDocumentType.containsElement(idEntry2.elements, element2)) continue;
                        idEntry2.addElement(element2);
                    }
                }
            }
        }
    }

    @Override
    public void collectIdRefs(Element element, List<IdRefItem> list) {
        Document document = element.getDocument();
        if (document == null) {
            return;
        }
        this.collectValidationRoots(element);
        int n = this.validationRoots.size;
        ValidationRoot[] validationRootArray = this.validationRoots.list;
        ValidationRoot validationRoot = validationRootArray[0];
        validationRoot.subDocumentType.collectIdRefs(element, validationRoot.validationRoot, list);
        if (n > 1) {
            IdentityHashMap<Element, IdRefItem> identityHashMap = new IdentityHashMap<Element, IdRefItem>();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                IdRefItem idRefItem = list.get(i);
                identityHashMap.put(idRefItem.element, idRefItem);
            }
            list.clear();
            ArrayList<IdRefItem> arrayList = new ArrayList<IdRefItem>();
            for (int i = 1; i < n; ++i) {
                validationRoot = validationRootArray[i];
                arrayList.clear();
                validationRoot.subDocumentType.collectIdRefs(validationRoot.validationRoot, validationRoot.validationRoot, arrayList);
                n2 = arrayList.size();
                for (int j = 0; j < n2; ++j) {
                    IdRefItem idRefItem = arrayList.get(j);
                    IdRefItem idRefItem2 = (IdRefItem)identityHashMap.get(idRefItem.element);
                    if (idRefItem2 == null) {
                        identityHashMap.put(idRefItem.element, idRefItem);
                        continue;
                    }
                    String[] stringArray = idRefItem.idRefs;
                    for (int k = 0; k < stringArray.length; ++k) {
                        if (StringList.contains(idRefItem2.idRefs, stringArray[k])) continue;
                        idRefItem2.addIdRef(stringArray[k]);
                    }
                }
            }
            list.addAll(identityHashMap.values());
        }
        this.validationRoots.clear();
    }

    private Element doGetValidationRoot(Element element) {
        Tree tree;
        Element element2 = null;
        Namespace namespace = null;
        this.subDocumentType = null;
        while ((tree = element.getParent()) != null && tree.getType() == Node.Type.ELEMENT) {
            Namespace namespace2;
            int n;
            Element element3 = (Element)tree;
            if (element2 == null && (n = MultiDocumentType.indexOfNamespace(this.auxNamespaces, namespace2 = element.getNamespace())) >= 0) {
                element2 = element;
                namespace = namespace2;
                this.subDocumentType = this.auxDocumentTypes[n];
            }
            if (element2 != null) {
                namespace2 = element3.getNamespace();
                if (namespace2 != namespace) break;
                element2 = element3;
            }
            element = element3;
        }
        if (element2 == null) {
            element2 = element;
            this.subDocumentType = this.mainDocumentType;
        }
        return element2;
    }

    private static final int indexOfNamespace(Namespace[] namespaceArray, Namespace namespace) {
        int n = namespaceArray.length;
        for (int i = 0; i < n; ++i) {
            if (namespace != namespaceArray[i]) continue;
            return i;
        }
        return -1;
    }

    private void collectValidationRoots(Element element) {
        this.validationRoots.clear();
        Element element2 = this.doGetValidationRoot(element);
        this.validationRoots.add(element2, this.subDocumentType);
        if (this.subDocumentType == this.mainDocumentType) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != Node.Type.ELEMENT) continue;
                this.doCollectValidationRoots((Element)node);
            }
        }
    }

    private void doCollectValidationRoots(Element element) {
        Namespace namespace = element.getNamespace();
        int n = MultiDocumentType.indexOfNamespace(this.auxNamespaces, namespace);
        if (n >= 0) {
            this.validationRoots.add(element, this.auxDocumentTypes[n]);
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            this.doCollectValidationRoots((Element)node);
        }
    }

    private static final boolean containsElement(Element[] elementArray, Element element) {
        int n = elementArray.length;
        for (int i = 0; i < n; ++i) {
            if (element != elementArray[i]) continue;
            return true;
        }
        return false;
    }

    private final class ElementTypeWrapper
    implements ElementType {
        public final ElementType delegate;

        public ElementTypeWrapper(ElementType elementType) {
            this.delegate = elementType;
        }

        @Override
        public ContentType getElementContentType() {
            return this.delegate.getElementContentType();
        }

        @Override
        public DataType getElementDataType() {
            return this.delegate.getElementDataType();
        }

        @Override
        public Object getElementFixedValue() {
            return this.delegate.getElementFixedValue();
        }

        @Override
        public Object getElementDefaultValue() {
            return this.delegate.getElementDefaultValue();
        }

        @Override
        public Field[] getAttributeFields() {
            return this.delegate.getAttributeFields();
        }

        @Override
        public void getAttributeFields(Name name, List<Field> list) {
            this.delegate.getAttributeFields(name, list);
        }

        @Override
        public boolean isRequiredAttribute(Field field) {
            return this.delegate.isRequiredAttribute(field);
        }

        @Override
        public Data getAttributeDefaultValue(Name name) {
            return this.delegate.getAttributeDefaultValue(name);
        }

        @Override
        public Field[] getChildElementFields() {
            return this.delegate.getChildElementFields();
        }

        @Override
        public void getChildElementFields(Name name, List<Field> list) {
            this.delegate.getChildElementFields(name, list);
        }

        @Override
        public boolean canCheckAttributeStructure() {
            return this.delegate.canCheckAttributeStructure();
        }

        @Override
        public boolean checkStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
            return this.delegate.checkStructure(fieldArray, n, itemArray, n2);
        }

        @Override
        public boolean checkAttributeStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
            return this.delegate.checkAttributeStructure(fieldArray, n, itemArray, n2);
        }

        @Override
        public boolean checkElementStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
            return this.delegate.checkElementStructure(fieldArray, n, itemArray, n2);
        }

        @Override
        public boolean getStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
            return this.delegate.getStructure(attributeArray, n, nodeArray, n2, bl, structure);
        }

        @Override
        public boolean getStructure(Element element, boolean bl, Structure structure) {
            return this.delegate.getStructure(element, bl, structure);
        }

        @Override
        public boolean getAttributeStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
            return this.delegate.getAttributeStructure(attributeArray, n, nodeArray, n2, bl, structure);
        }

        @Override
        public boolean getAttributeStructure(Element element, boolean bl, Structure structure) {
            return this.delegate.getAttributeStructure(element, bl, structure);
        }

        @Override
        public boolean getElementStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
            return this.delegate.getElementStructure(attributeArray, n, nodeArray, n2, bl, structure);
        }

        @Override
        public boolean getElementStructure(Element element, boolean bl, Structure structure) {
            return this.delegate.getElementStructure(element, bl, structure);
        }

        @Override
        public AttributeType getAttributeType(Field field, Name name) {
            return this.delegate.getAttributeType(field, name);
        }

        @Override
        public ElementType getChildElementType(Field field, Name name) {
            ElementType elementType = this.delegate.getChildElementType(field, name);
            if (elementType == null) {
                return null;
            }
            return new ElementTypeWrapper(elementType);
        }

        @Override
        public ElementType getChildElementType(Field field, Element element) {
            Element element2;
            ElementType elementType = null;
            Namespace namespace = element.getNamespace();
            int n = MultiDocumentType.indexOfNamespace(MultiDocumentType.this.auxNamespaces, namespace);
            if (n >= 0 && (element2 = element.getParentElement()) != null && element2.getNamespace() != namespace) {
                elementType = MultiDocumentType.this.auxDocumentTypes[n].getElementType(element, element);
            }
            if (elementType == null) {
                elementType = this.delegate.getChildElementType(field, element);
            }
            if (elementType == null) {
                return null;
            }
            return new ElementTypeWrapper(elementType);
        }

        @Override
        public Element createInstance(Name name, int n) {
            return this.delegate.createInstance(name, n);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ElementTypeWrapper)) {
                return false;
            }
            ElementTypeWrapper elementTypeWrapper = (ElementTypeWrapper)object;
            return this.delegate.equals(elementTypeWrapper.delegate);
        }
    }

    private static final class ValidationRoots {
        public ValidationRoot[] list = new ValidationRoot[10];
        public int size = 0;

        public ValidationRoots() {
            for (int i = 0; i < this.list.length; ++i) {
                this.list[i] = new ValidationRoot(null, null);
            }
        }

        public void clear() {
            if (this.size > 0) {
                for (int i = 0; i < this.size; ++i) {
                    ValidationRoot validationRoot = this.list[i];
                    validationRoot.validationRoot = null;
                    validationRoot.subDocumentType = null;
                }
                this.size = 0;
            }
        }

        public void add(Element element, SubDocumentType subDocumentType) {
            Object object;
            if (this.size == this.list.length) {
                object = new ValidationRoot[2 * this.size];
                System.arraycopy(this.list, 0, object, 0, this.size);
                for (int i = this.size; i < ((ValidationRoot[])object).length; ++i) {
                    object[i] = new ValidationRoot(null, null);
                }
                this.list = object;
            }
            object = this.list[this.size++];
            object.validationRoot = element;
            object.subDocumentType = subDocumentType;
        }
    }

    public static final class ValidationRoot {
        public Element validationRoot;
        public SubDocumentType subDocumentType;

        public ValidationRoot(Element element, SubDocumentType subDocumentType) {
            this.validationRoot = element;
            this.subDocumentType = subDocumentType;
        }
    }
}

