/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.util.StringList;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.AnyElementType;
import com.xmlmind.xml.validate.AttributeDefaultValue;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.AttributeUtil;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.IDDataType;
import com.xmlmind.xml.validate.IdEntry;
import com.xmlmind.xml.validate.IdRefItem;
import com.xmlmind.xml.validate.PreserveSpaceDefaultValue;
import com.xmlmind.xml.validate.Structure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class DocumentTypeUtil {
    private static ArrayList<Field> fieldList = new ArrayList();
    private static Structure structure = new Structure();
    public static final int DEFAULT_CREATE_INSTANCE_OPTIONS = 29;
    private static int uniqueId = 0;
    public static final SortByInclusion sortByInclusion = new SortByInclusion();
    private static final Element[] NO_ID_REFS = new Element[0];

    private DocumentTypeUtil() {
    }

    public static DocumentType getDocumentType(Node node) {
        Document document = node.getDocument();
        if (document == null) {
            return null;
        }
        return DocumentTypeUtil.getDocumentType(document);
    }

    public static DocumentType getDocumentType(Document document) {
        return (DocumentType)document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY);
    }

    public static boolean isActualDocumentType(DocumentType documentType) {
        return documentType != null && !(documentType instanceof AnyDocumentType);
    }

    public static String getElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        if (documentType == null) {
            return AttributeUtil.getAttribute(element, name, attributeDefaultValue);
        }
        return documentType.getElementAttribute(element, name, attributeDefaultValue);
    }

    public static String lookupElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        if (documentType == null) {
            return AttributeUtil.lookupAttribute(element, name, attributeDefaultValue);
        }
        return documentType.lookupElementAttribute(element, name, attributeDefaultValue);
    }

    public static String getElementSpaceAttribute(Element element) {
        return DocumentTypeUtil.getElementAttribute(element, Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE);
    }

    public static boolean hasPreserveSpace(Element element) {
        String string = DocumentTypeUtil.lookupElementAttribute(element, Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE);
        if (string == null) {
            return false;
        }
        return string.trim().equals("preserve");
    }

    public static ElementType getElementType(Element element) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(element);
        if (documentType == null) {
            return null;
        }
        return documentType.getElementType(element);
    }

    public static AttributeType getAttributeType(Element element, Name name) {
        return DocumentTypeUtil.getAttributeType(element, name, null);
    }

    public static AttributeType getAttributeType(Element element, Name name, boolean[] blArray) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        elementType.getAttributeFields(name, fieldList);
        switch (fieldList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return DocumentTypeUtil.attributeType(elementType, fieldList.get(0), name, blArray);
            }
        }
        if (!elementType.getAttributeStructure(element, false, structure)) {
            return null;
        }
        int n = DocumentTypeUtil.structure.attributeFieldCount;
        Name[] nameArray = DocumentTypeUtil.structure.attributeNames;
        Field[] fieldArray = DocumentTypeUtil.structure.attributeFields;
        for (int i = 0; i < n; ++i) {
            if (!nameArray[i].equals(name)) continue;
            return DocumentTypeUtil.attributeType(elementType, fieldArray[i], name, blArray);
        }
        Field[] fieldArray2 = new Field[n + 1];
        if (n > 0) {
            System.arraycopy(fieldArray, 0, fieldArray2, 0, n);
        }
        int n2 = fieldList.size();
        for (int i = 0; i < n2; ++i) {
            Field field;
            fieldArray2[n] = field = fieldList.get(i);
            if (!elementType.checkAttributeStructure(fieldArray2, n + 1, DocumentTypeUtil.structure.childNodeItems, DocumentTypeUtil.structure.childNodeItemCount)) continue;
            return DocumentTypeUtil.attributeType(elementType, field, name, blArray);
        }
        return null;
    }

    private static AttributeType attributeType(ElementType elementType, Field field, Name name, boolean[] blArray) {
        AttributeType attributeType = elementType.getAttributeType(field, name);
        if (blArray != null) {
            blArray[0] = elementType.isRequiredAttribute(field);
        }
        return attributeType;
    }

    public static Name getIdAttributeName(Element element) {
        if (element.getAttributeCount() == 0) {
            return null;
        }
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            elementType = AnyElementType.INSTANCE;
        }
        if (!elementType.getAttributeStructure(element, false, structure)) {
            return null;
        }
        int n = DocumentTypeUtil.structure.attributeFieldCount;
        Name[] nameArray = DocumentTypeUtil.structure.attributeNames;
        Field[] fieldArray = DocumentTypeUtil.structure.attributeFields;
        for (int i = 0; i < n; ++i) {
            AttributeType attributeType = elementType.getAttributeType(fieldArray[i], nameArray[i]);
            if (attributeType == null || !(attributeType.getAttributeDataType() instanceof IDDataType)) continue;
            return nameArray[i];
        }
        return null;
    }

    public static Element createInstance(Element element) {
        return DocumentTypeUtil.createInstance(element, 29);
    }

    public static Element createInstance(Element element, int n) {
        Element element2 = DocumentTypeUtil.doCreateInstance(element, n);
        if (element2 == null) {
            element2 = new Element(element.getName());
        }
        return element2;
    }

    public static Element doCreateInstance(Element element, int n) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        return elementType.createInstance(element.getName(), n);
    }

    public static String generateUniqueId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("___");
        stringBuilder.append(Long.toString(System.currentTimeMillis(), 36));
        stringBuilder.append(".");
        stringBuilder.append(Integer.toString(uniqueId++, 36));
        return stringBuilder.toString();
    }

    public static DataType getDataType(Element element, Name name) {
        DataType dataType = name != null ? DocumentTypeUtil.getAttributeDataType(element, name) : DocumentTypeUtil.getElementDataType(element);
        return dataType;
    }

    public static DataType getElementDataType(Element element) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        return elementType.getElementDataType();
    }

    public static DataType getAttributeDataType(Element element, Name name) {
        AttributeType attributeType = DocumentTypeUtil.getAttributeType(element, name);
        if (attributeType == null) {
            return null;
        }
        return attributeType.getAttributeDataType();
    }

    public static String getDefaultValue(Element element, Name name) {
        String string = name != null ? DocumentTypeUtil.getAttributeDefaultValue(element, name) : DocumentTypeUtil.getElementDefaultValue(element);
        return string;
    }

    public static String getElementDefaultValue(Element element) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        if (elementType.getElementContentType() == ContentType.DATA) {
            Data data = (Data)elementType.getElementDefaultValue();
            if (data == null) {
                return null;
            }
            return data.formatData(element);
        }
        return (String)elementType.getElementDefaultValue();
    }

    public static String getAttributeDefaultValue(Element element, Name name) {
        ElementType elementType = DocumentTypeUtil.getElementType(element);
        if (elementType == null) {
            return null;
        }
        Data data = elementType.getAttributeDefaultValue(name);
        if (data == null) {
            return null;
        }
        return data.formatData(element);
    }

    public static Element[] findElementById(DocumentType documentType, Element element, String string, boolean bl) {
        Element[] elementArray;
        if (documentType == null) {
            documentType = AnyDocumentType.INSTANCE;
        }
        if ((elementArray = documentType.findElementById(element, string, bl)) == null) {
            return null;
        }
        if (elementArray.length > 1) {
            Arrays.sort(elementArray, sortByInclusion);
        }
        return elementArray;
    }

    public static void collectIds(DocumentType documentType, Element element, Map<String, IdEntry> map) {
        if (documentType == null) {
            documentType = AnyDocumentType.INSTANCE;
        }
        documentType.collectIds(element, map);
        for (IdEntry idEntry : map.values()) {
            if (idEntry.elements.length <= 1) continue;
            Arrays.sort(idEntry.elements, sortByInclusion);
        }
    }

    public static String[] getIds(Document document) {
        return DocumentTypeUtil.getIds(document.getRootElement());
    }

    public static String[] getIds(Element element) {
        return DocumentTypeUtil.getIds(element, DocumentTypeUtil.getDocumentType(element));
    }

    public static String[] getIds(Document document, DocumentType documentType) {
        return DocumentTypeUtil.getIds(document.getRootElement(), documentType);
    }

    public static String[] getIds(Element element, DocumentType documentType) {
        if (documentType == null) {
            documentType = AnyDocumentType.INSTANCE;
        }
        HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
        documentType.collectIds(element, hashMap);
        String[] stringArray = new String[hashMap.size()];
        int n = 0;
        for (IdEntry idEntry : hashMap.values()) {
            stringArray[n++] = idEntry.id;
        }
        return stringArray;
    }

    public static Element[] getIdRefs(Document document, String string) {
        return DocumentTypeUtil.getIdRefs(document.getRootElement(), string);
    }

    public static Element[] getIdRefs(Element element, String string) {
        return DocumentTypeUtil.getIdRefs(element, string, DocumentTypeUtil.getDocumentType(element));
    }

    public static Element[] getIdRefs(Document document, String string, DocumentType documentType) {
        return DocumentTypeUtil.getIdRefs(document.getRootElement(), string, documentType);
    }

    public static Element[] getIdRefs(Element element, String string, DocumentType documentType) {
        if (!DocumentTypeUtil.isActualDocumentType(documentType)) {
            return NO_ID_REFS;
        }
        ArrayList<IdRefItem> arrayList = new ArrayList<IdRefItem>();
        documentType.collectIdRefs(element, arrayList);
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            IdRefItem idRefItem = arrayList.get(i);
            if (!StringList.contains(idRefItem.idRefs, string)) continue;
            arrayList2.add(idRefItem.element);
        }
        Element[] elementArray = new Element[arrayList2.size()];
        arrayList2.toArray(elementArray);
        return elementArray;
    }

    public static final class SortByInclusion
    implements Comparator<Element> {
        @Override
        public int compare(Element element, Element element2) {
            int n = element.lookupInclusion() == null ? 0 : 1;
            int n2 = element2.lookupInclusion() == null ? 0 : 1;
            return n - n2;
        }
    }
}

