/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.AttributeEvent;
import com.xmlmind.xml.doc.Comment;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentEvent;
import com.xmlmind.xml.doc.DocumentListener;
import com.xmlmind.xml.doc.EditEvent;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.ElementNameEvent;
import com.xmlmind.xml.doc.InclusionUpdatedEvent;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.ProcessingInstructionEvent;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.TextEvent;
import com.xmlmind.xml.doc.Traversal;
import com.xmlmind.xml.doc.TreeEvent;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.validate.AnyAttributeType;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.AnyElementType;
import com.xmlmind.xml.validate.AnyField;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.NameClass;
import com.xmlmind.xml.validate.Structure;
import com.xmlmind.xml.validate.XMLIDAttributeType;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class AutoDocumentType
extends AnyDocumentType
implements Traversal.Handler,
DocumentListener {
    private IdentityHashMap<Name, ElementTypeImpl> elementTypes;
    private boolean editSequence = false;
    private IdentityHashMap<Element, Name[]> pendingElementAttributes = new IdentityHashMap();
    private IdentityHashMap<Element, Name[]> pendingElementChildren = new IdentityHashMap();
    private IdentityHashMap<Element, Element> pendingNewElements = new IdentityHashMap();
    private static final Field[] NO_FIELDS = new Field[0];

    public AutoDocumentType(Document document) {
        this.initElementTypes(document);
        document.addDocumentListener(this, false);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    private void initElementTypes(Document document) {
        this.elementTypes = new IdentityHashMap();
        this.updateElement(document.getRootElement());
    }

    private void updateElement(Element element) {
        Traversal.traverse(element, this);
    }

    @Override
    public ElementType[] getElementType(Name name) {
        ElementType[] elementTypeArray;
        ElementType elementType = this.doGetElementType(name);
        if (elementType == null) {
            elementTypeArray = null;
        } else {
            ElementType[] elementTypeArray2 = new ElementType[1];
            elementTypeArray = elementTypeArray2;
            elementTypeArray2[0] = elementType;
        }
        return elementTypeArray;
    }

    @Override
    public ElementType getElementType(Element element) {
        return this.doGetElementType(element.getName());
    }

    private ElementType doGetElementType(Name name) {
        return this.elementTypes.get(name);
    }

    @Override
    public Object enterElement(Element element) {
        ElementTypeImpl elementTypeImpl = this.getElementTypeImpl(element);
        AutoDocumentType.updateElementAttributes(elementTypeImpl, element);
        AutoDocumentType.updateElementChildren(elementTypeImpl, element);
        return null;
    }

    private ElementTypeImpl getElementTypeImpl(Element element) {
        Name name = element.getName();
        ElementTypeImpl elementTypeImpl = this.elementTypes.get(name);
        if (elementTypeImpl == null) {
            elementTypeImpl = new ElementTypeImpl();
            this.elementTypes.put(name, elementTypeImpl);
        }
        return elementTypeImpl;
    }

    private static final void updateElementAttributes(ElementTypeImpl elementTypeImpl, Element element) {
        if (element.getAttributeCount() > 0) {
            Iterator<Attribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                elementTypeImpl.addAttribute(attribute.name);
            }
        }
    }

    private static final void updateElementChildren(ElementTypeImpl elementTypeImpl, Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            elementTypeImpl.addChildElement(((Element)node).getName());
        }
    }

    @Override
    public Object processText(Text text) {
        return null;
    }

    @Override
    public Object processPI(ProcessingInstruction processingInstruction) {
        return null;
    }

    @Override
    public Object processComment(Comment comment) {
        return null;
    }

    @Override
    public Object leaveElement(Element element) {
        return null;
    }

    @Override
    public void editStarted(EditEvent editEvent, int n) {
        this.editSequence = true;
    }

    @Override
    public void editCompleted(EditEvent editEvent, int n) {
        int n2;
        ElementTypeImpl elementTypeImpl;
        Name[] nameArray;
        Element element;
        this.editSequence = false;
        if (this.pendingElementAttributes.size() > 0) {
            for (Map.Entry<Element, Name[]> object : this.pendingElementAttributes.entrySet()) {
                element = object.getKey();
                nameArray = object.getValue();
                elementTypeImpl = this.getElementTypeImpl(element);
                for (n2 = 0; n2 < nameArray.length; ++n2) {
                    elementTypeImpl.addAttribute(nameArray[n2]);
                }
            }
            this.pendingElementAttributes.clear();
        }
        if (this.pendingElementChildren.size() > 0) {
            for (Map.Entry<Element, Name[]> entry : this.pendingElementChildren.entrySet()) {
                element = entry.getKey();
                nameArray = entry.getValue();
                elementTypeImpl = this.getElementTypeImpl(element);
                for (n2 = 0; n2 < nameArray.length; ++n2) {
                    elementTypeImpl.addChildElement(nameArray[n2]);
                }
            }
            this.pendingElementChildren.clear();
        }
        if (this.pendingNewElements.size() > 0) {
            for (Element element2 : this.pendingNewElements.values()) {
                this.updateElement(element2);
            }
            this.pendingNewElements.clear();
        }
    }

    @Override
    public void attributeChanged(AttributeEvent attributeEvent, int n) {
        if (attributeEvent.getType() == DocumentEvent.Type.ATTRIBUTE_ADDED) {
            Element element = attributeEvent.getElementSource();
            Name name = attributeEvent.getName();
            if (this.editSequence) {
                this.pendingAttribute(element, name);
            } else {
                ElementTypeImpl elementTypeImpl = this.getElementTypeImpl(element);
                elementTypeImpl.addAttribute(name);
            }
        }
    }

    private void pendingAttribute(Element element, Name name) {
        Name[] nameArray = this.pendingElementAttributes.get(element);
        if (nameArray == null) {
            nameArray = new Name[]{name};
        } else {
            Name[] nameArray2 = new Name[nameArray.length + 1];
            System.arraycopy(nameArray, 0, nameArray2, 0, nameArray.length);
            nameArray2[nameArray.length] = name;
            nameArray = nameArray2;
        }
        this.pendingElementAttributes.put(element, nameArray);
    }

    @Override
    public void inclusionUpdated(InclusionUpdatedEvent inclusionUpdatedEvent, int n) {
        Node[] nodeArray;
        Element element = inclusionUpdatedEvent.getElementSource();
        if (element != null && (nodeArray = inclusionUpdatedEvent.getNewChildren()) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                if (node.getType() != Node.Type.ELEMENT) continue;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (this.editSequence) {
                    this.pendingChildElement(element, name);
                    this.pendingNewElements.put(element2, element2);
                    continue;
                }
                ElementTypeImpl elementTypeImpl = this.getElementTypeImpl(element);
                elementTypeImpl.addChildElement(name);
                this.updateElement(element2);
            }
        }
    }

    @Override
    public void treeChanged(TreeEvent treeEvent, int n) {
        Node node;
        Element element = treeEvent.getElementSource();
        if (element != null && (node = treeEvent.getNewChild()) != null && node.getType() == Node.Type.ELEMENT) {
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (this.editSequence) {
                this.pendingChildElement(element, name);
                this.pendingNewElements.put(element2, element2);
            } else {
                ElementTypeImpl elementTypeImpl = this.getElementTypeImpl(element);
                elementTypeImpl.addChildElement(name);
                this.updateElement(element2);
            }
        }
    }

    private void pendingChildElement(Element element, Name name) {
        Name[] nameArray = this.pendingElementChildren.get(element);
        if (nameArray == null) {
            nameArray = new Name[]{name};
        } else {
            Name[] nameArray2 = new Name[nameArray.length + 1];
            System.arraycopy(nameArray, 0, nameArray2, 0, nameArray.length);
            nameArray2[nameArray.length] = name;
            nameArray = nameArray2;
        }
        this.pendingElementChildren.put(element, nameArray);
    }

    @Override
    public void textChanged(TextEvent textEvent, int n) {
    }

    @Override
    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
    }

    @Override
    public void elementNameChanged(ElementNameEvent elementNameEvent, int n) {
    }

    @Override
    public void eventHappened(DocumentEvent documentEvent, int n) {
    }

    private final class ElementTypeImpl
    extends AnyElementType {
        private IdentityLinearHashtable<Name, Field> attributeFieldMap;
        private IdentityLinearHashtable<Name, Field> childElementFieldMap;

        private ElementTypeImpl() {
        }

        public void addAttribute(Name name) {
            if (this.attributeFieldMap == null) {
                this.attributeFieldMap = new IdentityLinearHashtable();
            }
            if (!this.attributeFieldMap.containsKey(name)) {
                NamedField namedField = new NamedField(name);
                this.attributeFieldMap.put(name, namedField);
            }
        }

        public void addChildElement(Name name) {
            if (this.childElementFieldMap == null) {
                this.childElementFieldMap = new IdentityLinearHashtable();
            }
            if (!this.childElementFieldMap.containsKey(name)) {
                NamedField namedField = new NamedField(name);
                this.childElementFieldMap.put(name, namedField);
            }
        }

        @Override
        public Field[] getAttributeFields() {
            if (this.attributeFieldMap == null) {
                return ANY_FIELDS_1;
            }
            int n = this.attributeFieldMap.size();
            Field[] fieldArray = new Field[n + 1];
            this.attributeFieldMap.copyElementsInto((Field[])fieldArray);
            fieldArray[n] = AnyField.INSTANCE;
            return fieldArray;
        }

        @Override
        public void getAttributeFields(Name name, List<Field> list) {
            Field field;
            list.clear();
            if (this.attributeFieldMap != null && (field = this.attributeFieldMap.get(name)) != null) {
                list.add(field);
            }
            list.add(AnyField.INSTANCE);
        }

        @Override
        public Field[] getChildElementFields() {
            if (this.childElementFieldMap == null) {
                return ANY_FIELDS_1;
            }
            int n = this.childElementFieldMap.size();
            Field[] fieldArray = new Field[n + 1];
            this.childElementFieldMap.copyElementsInto((Field[])fieldArray);
            fieldArray[n] = AnyField.INSTANCE;
            return fieldArray;
        }

        @Override
        public void getChildElementFields(Name name, List<Field> list) {
            Field field;
            list.clear();
            if (this.childElementFieldMap != null && (field = this.childElementFieldMap.get(name)) != null) {
                list.add(field);
            }
            list.add(AnyField.INSTANCE);
        }

        @Override
        public boolean getStructure(Element element, boolean bl, Structure structure) {
            Attribute[] attributeArray = element.getAllAttributes();
            Node[] nodeArray = element.getChildren();
            return this.getStructure(attributeArray, attributeArray.length, nodeArray, nodeArray.length, bl, structure);
        }

        @Override
        public boolean getStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
            Object object;
            Comparable<Name> comparable;
            int n3;
            structure.clear();
            if (this.attributeFieldMap == null) {
                for (n3 = 0; n3 < n; ++n3) {
                    structure.addAttributeField(attributeArray[n3].name, AnyField.INSTANCE);
                }
            } else {
                for (n3 = 0; n3 < n; ++n3) {
                    comparable = attributeArray[n3].name;
                    object = this.attributeFieldMap.get((Name)comparable);
                    if (object == null) {
                        object = AnyField.INSTANCE;
                    }
                    structure.addAttributeField((Name)comparable, (Field)object);
                }
            }
            block7: for (n3 = 0; n3 < n2; ++n3) {
                comparable = nodeArray[n3];
                switch (((Node)comparable).getType()) {
                    case TEXT: {
                        structure.addTextItem();
                        continue block7;
                    }
                    case COMMENT: {
                        structure.addCommentItem();
                        continue block7;
                    }
                    case PROCESSING_INSTRUCTION: {
                        structure.addProcessingInstructionItem();
                        continue block7;
                    }
                    default: {
                        if (this.childElementFieldMap == null) {
                            structure.addChildNodeItem(AnyField.INSTANCE);
                            continue block7;
                        }
                        object = (Element)comparable;
                        Field field = this.childElementFieldMap.get(((Element)object).getName());
                        if (field == null) {
                            field = AnyField.INSTANCE;
                        }
                        structure.addChildNodeItem(field);
                    }
                }
            }
            return true;
        }

        @Override
        public AttributeType getAttributeType(Field field, Name name) {
            if (name == Name.XML_ID) {
                return XMLIDAttributeType.INSTANCE;
            }
            return AnyAttributeType.INSTANCE;
        }

        @Override
        public ElementType getChildElementType(Field field, Element element) {
            return this.getChildElementType(field, element.getName());
        }

        @Override
        public ElementType getChildElementType(Field field, Name name) {
            return AutoDocumentType.this.doGetElementType(name);
        }
    }

    private static final class NamedField
    implements Field {
        public final Name name;

        public NamedField(Name name) {
            this.name = name;
        }

        @Override
        public Name getFieldName() {
            return this.name;
        }

        @Override
        public NameClass getFieldNameClass() {
            return null;
        }

        @Override
        public String getFieldLabel(boolean bl, NamespaceToPrefixes namespaceToPrefixes) {
            return this.name.format(bl, namespaceToPrefixes);
        }
    }
}

