/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.validate.AttributeDefaultValue;
import com.xmlmind.xml.validate.PreserveSpaceDefaultValue;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    public static String getAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        String string = element.getAttribute(name);
        if (string == null && attributeDefaultValue != null) {
            string = attributeDefaultValue.getAttributeDefaultValue(element, name);
        }
        return string;
    }

    public static String lookupAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        if (attributeDefaultValue == null) {
            return element.lookupAttribute(name);
        }
        do {
            String string;
            if ((string = AttributeUtil.getAttribute(element, name, attributeDefaultValue)) == null) continue;
            return string;
        } while ((element = element.getParentElement()) != null);
        return null;
    }

    public static String lookupAttribute(Element element, Name[] nameArray, AttributeDefaultValue attributeDefaultValue) {
        if (attributeDefaultValue == null) {
            do {
                for (Name name : nameArray) {
                    String string = element.getAttribute(name);
                    if (string == null) continue;
                    return string;
                }
            } while ((element = element.getParentElement()) != null);
        } else {
            do {
                for (Name name : nameArray) {
                    String string = AttributeUtil.getAttribute(element, name, attributeDefaultValue);
                    if (string == null) continue;
                    return string;
                }
            } while ((element = element.getParentElement()) != null);
        }
        return null;
    }

    public static String getSpaceAttribute(Element element) {
        return AttributeUtil.getAttribute(element, Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE);
    }

    public static boolean hasPreserveSpace(Element element) {
        String string = AttributeUtil.lookupAttribute(element, Name.XML_SPACE, (AttributeDefaultValue)PreserveSpaceDefaultValue.INSTANCE);
        if (string == null) {
            return false;
        }
        return string.trim().equals("preserve");
    }
}

