/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.validate.AttributeDefaultValue;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.DiagnosticImpl;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.IdEntry;
import com.xmlmind.xml.validate.IdRefItem;
import com.xmlmind.xml.validate.Msg;
import com.xmlmind.xml.validate.SchemaKind;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnyDocumentType
implements DocumentType {
    public static final AnyDocumentType INSTANCE = new AnyDocumentType();

    public boolean equals(Object object) {
        return object != null && object instanceof AnyDocumentType;
    }

    @Override
    public SchemaKind getSchemaKind() {
        return SchemaKind.NONE;
    }

    @Override
    public Namespace[] getTargetNamespaces() {
        return null;
    }

    @Override
    public URL[] getSchemaURLs() {
        return null;
    }

    @Override
    public PrefixEntry[] getSchemaDeclaredPrefixes() {
        return null;
    }

    @Override
    public Diagnostic[] checkDocument(Document document) {
        HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
        AnyDocumentType.doCollectIds(document.getRootElement(), hashMap);
        ArrayList<DiagnosticImpl> arrayList = new ArrayList<DiagnosticImpl>();
        for (IdEntry diagnosticArray2 : hashMap.values()) {
            if (!XMLText.isNCName(diagnosticArray2.id)) {
                arrayList.add(new DiagnosticImpl(diagnosticArray2.elements[0], Msg.msg("ADT.notAnID", diagnosticArray2.id), Diagnostic.Severity.INVALID_DATA));
                continue;
            }
            if (diagnosticArray2.elements.length <= 1) continue;
            Element[] elementArray = diagnosticArray2.elements;
            for (int i = 1; i < elementArray.length; ++i) {
                arrayList.add(new DiagnosticImpl(elementArray[i], Msg.msg("ADT.multiplyDefinedID", diagnosticArray2.id), Diagnostic.Severity.INVALID_REFERENCE, "DUPLICATE_ID", diagnosticArray2.id));
            }
        }
        Diagnostic[] diagnosticArray = new DiagnosticImpl[arrayList.size()];
        arrayList.toArray(diagnosticArray);
        return diagnosticArray;
    }

    @Override
    public Name[] getRootElementNames() {
        return Name.EMPTY_LIST;
    }

    @Override
    public ElementType[] getElementType(Name name) {
        return null;
    }

    @Override
    public ElementType getElementType(Element element) {
        return null;
    }

    @Override
    public String getElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        return AnyDocumentType.getAttribute(element, name, attributeDefaultValue);
    }

    protected static final String getAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        String string = element.getAttribute(name);
        if (string == null && attributeDefaultValue != null) {
            string = attributeDefaultValue.getAttributeDefaultValue(element, name);
        }
        return string;
    }

    @Override
    public String lookupElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        return AnyDocumentType.lookupAttribute(element, name, attributeDefaultValue);
    }

    protected static final String lookupAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        Tree tree = element;
        while (((Node)tree).getType() == Node.Type.ELEMENT) {
            String string = AnyDocumentType.getAttribute(tree, name, attributeDefaultValue);
            if (string != null) {
                return string;
            }
            tree = tree.getParent();
        }
        return null;
    }

    @Override
    public Element[] findElementById(Element element, String string, boolean bl) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        AnyDocumentType.doFindElementById(element, string, arrayList);
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        Element[] elementArray = new Element[n];
        arrayList.toArray(elementArray);
        return elementArray;
    }

    private static final void doFindElementById(Element element, String string, ArrayList<Element> arrayList) {
        String string2 = element.getAttribute(Name.XML_ID);
        if (string2 != null && (string2 = XMLText.collapseWhiteSpace(string2)).equals(string)) {
            arrayList.add(element);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            AnyDocumentType.doFindElementById((Element)node, string, arrayList);
        }
    }

    @Override
    public void collectIds(Element element, Map<String, IdEntry> map) {
        if (!map.isEmpty()) {
            map.clear();
        }
        AnyDocumentType.doCollectIds(element, map);
    }

    private static final void doCollectIds(Element element, Map<String, IdEntry> map) {
        Object object;
        String string = element.getAttribute(Name.XML_ID);
        if (string != null) {
            object = map.get(string = XMLText.collapseWhiteSpace(string));
            if (object == null) {
                object = new IdEntry(string, element);
                map.put(string, (IdEntry)object);
            } else {
                ((IdEntry)object).addElement(element);
            }
        }
        for (object = element.getFirstChild(); object != null; object = ((Node)object).getNextSibling()) {
            if (((Node)object).getType() != Node.Type.ELEMENT) continue;
            AnyDocumentType.doCollectIds((Element)object, map);
        }
    }

    @Override
    public void collectIdRefs(Element element, List<IdRefItem> list) {
        if (!list.isEmpty()) {
            list.clear();
        }
    }
}

