/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.sxpath;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.sxpath.Path;
import com.xmlmind.xml.sxpath.Step;
import com.xmlmind.xml.sxpath.XPath;
import java.util.IdentityHashMap;

public final class AttributeMatcher {
    public final XPath[] xpaths;
    private final IdentityHashMap<Name, Entry> entries;

    public AttributeMatcher(XPath[] xPathArray) {
        this.xpaths = xPathArray;
        this.entries = new IdentityHashMap();
        for (XPath xPath : xPathArray) {
            for (Path path : xPath.getPaths()) {
                Step[] stepArray = path.getSteps();
                Step step = stepArray[stepArray.length - 1];
                if (step.getAxis() != Step.Axis.ATTRIBUTE || step.getTest() != Step.Test.NAME) continue;
                Name name = step.getTestedName();
                Entry entry = this.entries.get(name);
                if (entry == null) {
                    entry = new Entry(name);
                    this.entries.put(name, entry);
                }
                entry.addPath(path);
            }
        }
    }

    public boolean match(Element element, Name name) {
        boolean bl = false;
        Entry entry = this.entries.get(name);
        if (entry != null) {
            if (entry.basicTest) {
                bl = true;
            } else {
                Name[] nameArray = entry.elementNames;
                if (nameArray.length > 0) {
                    Path[] pathArray = element.getName();
                    Name[] nameArray2 = nameArray;
                    int n = nameArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Name name2 = nameArray2[i];
                        if (name2 != pathArray) continue;
                        bl = true;
                        break;
                    }
                }
                for (Path path : entry.paths) {
                    if (!path.match(element)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private static final class Entry {
        public final Name attributeName;
        public Name[] elementNames;
        public Path[] paths;
        public boolean basicTest;

        public Entry(Name name) {
            this.attributeName = name;
            this.elementNames = new Name[0];
            this.paths = new Path[0];
            this.basicTest = false;
        }

        public void addPath(Path path) {
            Object object;
            if (this.basicTest) {
                return;
            }
            boolean bl = true;
            Step[] stepArray = path.getSteps();
            switch (stepArray.length) {
                case 1: {
                    this.basicTest = true;
                    bl = false;
                    break;
                }
                case 2: {
                    Step step = stepArray[0];
                    if (step.getAxis() != Step.Axis.CHILD || step.getTest() != Step.Test.NAME) break;
                    object = step.getTestedName();
                    int n = this.elementNames.length;
                    Name[] nameArray = new Name[n + 1];
                    System.arraycopy(this.elementNames, 0, nameArray, 0, n);
                    nameArray[n] = object;
                    this.elementNames = nameArray;
                    bl = false;
                }
            }
            if (bl) {
                int n = this.paths.length;
                object = new Path[n + 1];
                System.arraycopy(this.paths, 0, object, 0, n);
                object[n] = path;
                this.paths = object;
            }
        }
    }
}

