/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.util.XMLUtil;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.schematron.Assertion;
import com.xmlmind.xml.schematron.Constants;
import com.xmlmind.xml.schematron.KeySpec;
import com.xmlmind.xml.schematron.LetVariable;
import com.xmlmind.xml.schematron.Message;
import com.xmlmind.xml.schematron.Msg;
import com.xmlmind.xml.schematron.Pattern;
import com.xmlmind.xml.schematron.Phase;
import com.xmlmind.xml.schematron.Rule;
import com.xmlmind.xml.schematron.Schematron;
import com.xmlmind.xml.schematron.SchematronError;
import com.xmlmind.xml.xpath.BooleanExpr;
import com.xmlmind.xml.xpath.ExprParser;
import com.xmlmind.xml.xpath.NodeSetExpr;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.PathPattern;
import com.xmlmind.xml.xpath.StringExpr;
import com.xmlmind.xml.xpath.VariantExpr;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SchematronLoader
extends DefaultHandler
implements Constants {
    private SchematronError[] errors = SchematronError.NO_ERRORS;
    private URL schemaURL;
    private PrefixToNamespaceImpl prefixToNs = new PrefixToNamespaceImpl();
    private SchemaInfo schemaInfo;
    private ArrayList<KeyInfo> keyList;
    private ArrayList<LetInfo> letList;
    private HashMap<String, PhaseInfo> phaseMap;
    private HashMap<String, PatternInfo> patternMap;
    private HashMap<String, Pattern> idToPattern;
    private boolean preProcessPatterns;
    private ArrayList<SchematronError> errorList;
    private Stack<Locator> locatorStack;
    private Stack<Info> infoStack;
    private static final LetVariable[] NO_LET_VARIABLES = new LetVariable[0];

    public Schematron load(File file) {
        return this.load(FileUtil.fileToURL(file));
    }

    public Schematron load(URL uRL) {
        this.schemaURL = uRL;
        this.prefixToNs = new PrefixToNamespaceImpl();
        this.schemaInfo = null;
        this.keyList = new ArrayList();
        this.letList = new ArrayList();
        this.phaseMap = new HashMap();
        this.patternMap = new HashMap();
        this.idToPattern = null;
        this.preProcessPatterns = false;
        this.errorList = new ArrayList();
        this.errors = SchematronError.NO_ERRORS;
        this.locatorStack = new Stack();
        this.infoStack = new Stack();
        boolean bl = this.parse(uRL);
        if (this.errorList.size() == 0 && this.patternMap.size() == 0) {
            this.errorList.add(new SchematronError(uRL.toExternalForm(), -1, -1, Msg.msg("emptySchema")));
        }
        this.locatorStack = null;
        this.infoStack = null;
        Schematron schematron = null;
        if (bl && this.errorList.size() == 0) {
            schematron = this.createSchematron();
        }
        this.errors = this.errorList.toArray(SchematronError.NO_ERRORS);
        this.errorList = null;
        this.schemaURL = null;
        this.prefixToNs = null;
        this.schemaInfo = null;
        this.keyList = null;
        this.letList = null;
        this.phaseMap = null;
        this.patternMap = null;
        this.idToPattern = null;
        this.preProcessPatterns = false;
        return schematron;
    }

    public SchematronError[] getErrors() {
        return this.errors;
    }

    private Schematron createSchematron() {
        if (!this.createPatterns()) {
            return null;
        }
        LinearHashtable<String, Phase> linearHashtable = this.createPhases();
        if (linearHashtable == null) {
            return null;
        }
        KeySpec[] keySpecArray = this.createKeySpecs(this.keyList);
        LetVariable[] letVariableArray = this.createLetVariables(this.letList);
        if (keySpecArray == null || letVariableArray == null) {
            return null;
        }
        PrefixEntry[] prefixEntryArray = this.prefixToNs.prefixPrefs2.getAll();
        for (int i = 0; i < prefixEntryArray.length; ++i) {
            PrefixEntry prefixEntry = prefixEntryArray[i];
            this.prefixToNs.prefixPrefs.add(prefixEntry.namespace, prefixEntry.prefix);
        }
        return new Schematron(this.prefixToNs.prefixPrefs.getAll(), keySpecArray, letVariableArray, linearHashtable, this.schemaURL);
    }

    private KeySpec[] createKeySpecs(ArrayList<KeyInfo> arrayList) {
        int n = arrayList.size();
        KeySpec[] keySpecArray = new KeySpec[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            KeyInfo keyInfo = arrayList.get(i);
            PathPattern pathPattern = null;
            try {
                pathPattern = ExprParser.parsePattern(keyInfo.matchString, this.prefixToNs);
            }
            catch (ParseException parseException) {
                this.addError(keyInfo, Msg.msg("invalidAttribute2", "match", ThrowableUtil.reason(parseException)));
                bl = true;
            }
            VariantExpr variantExpr = null;
            try {
                variantExpr = ExprParser.parseVariantExpr(keyInfo.useString, this.prefixToNs);
            }
            catch (ParseException parseException) {
                this.addError(keyInfo, Msg.msg("invalidAttribute2", "use", ThrowableUtil.reason(parseException)));
                bl = true;
            }
            if (bl) continue;
            keySpecArray[i] = new KeySpec(keyInfo.name, pathPattern, keyInfo.matchString, variantExpr, keyInfo.useString, keyInfo.url);
        }
        return bl ? null : keySpecArray;
    }

    private void addError(Info info, String string) {
        this.errorList.add(new SchematronError(info.location, info.lineNumber, info.columnNumber, string));
    }

    private LetVariable[] createLetVariables(ArrayList<LetInfo> arrayList) {
        int n = arrayList.size();
        if (n == 0) {
            return NO_LET_VARIABLES;
        }
        LetVariable[] letVariableArray = new LetVariable[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            LetInfo letInfo = arrayList.get(i);
            VariantExpr variantExpr = null;
            try {
                variantExpr = ExprParser.parseVariantExpr(letInfo.valueString, this.prefixToNs);
            }
            catch (ParseException parseException) {
                this.addError(letInfo, Msg.msg("invalidAttribute2", "value", ThrowableUtil.reason(parseException)));
                bl = true;
            }
            if (bl) continue;
            letVariableArray[i] = new LetVariable(letInfo.name, variantExpr, letInfo.valueString, letInfo.url);
        }
        return bl ? null : letVariableArray;
    }

    private boolean createPatterns() {
        if (this.preProcessPatterns && !this.preProcessPatterns()) {
            return false;
        }
        if (!this.preProcessRules()) {
            return false;
        }
        return this.doCreatePatterns();
    }

    private boolean preProcessPatterns() {
        HashMap<String, PatternInfo> hashMap = new HashMap<String, PatternInfo>(this.patternMap.size());
        boolean bl = false;
        for (PatternInfo patternInfo : this.patternMap.values()) {
            if (patternInfo.isAbstract) continue;
            if (patternInfo.templatePattern == null) {
                hashMap.put(patternInfo.id, patternInfo);
                continue;
            }
            PatternInfo patternInfo2 = this.patternMap.get(patternInfo.templatePattern);
            if (patternInfo2 == null) {
                this.addError(patternInfo, Msg.msg("elementNotFound", "pattern", patternInfo.templatePattern));
                bl = true;
                continue;
            }
            if (!patternInfo2.isAbstract) {
                this.addError(patternInfo, Msg.msg("notAbstract", "pattern", patternInfo.templatePattern));
                bl = true;
                continue;
            }
            PatternInfo patternInfo3 = this.expandPatternInfo(patternInfo2, patternInfo);
            hashMap.put(patternInfo3.id, patternInfo3);
        }
        if (bl) {
            return false;
        }
        this.patternMap = hashMap;
        return true;
    }

    private PatternInfo expandPatternInfo(PatternInfo patternInfo, PatternInfo patternInfo2) {
        PatternInfo patternInfo3 = new PatternInfo();
        patternInfo3.location = patternInfo2.location;
        patternInfo3.url = patternInfo2.url;
        patternInfo3.lineNumber = patternInfo2.lineNumber;
        patternInfo3.columnNumber = patternInfo2.columnNumber;
        patternInfo3.id = patternInfo2.id;
        patternInfo3.isAbstract = false;
        patternInfo3.templatePattern = null;
        patternInfo3.letList = new ArrayList();
        patternInfo3.ruleList = new ArrayList();
        patternInfo3.preProcessRules = patternInfo.preProcessRules;
        patternInfo3.paramList = null;
        ArrayList<ParamInfo> arrayList = patternInfo2.paramList;
        Object[] objectArray = new ParamInfo[arrayList.size()];
        arrayList.toArray(objectArray);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        ArrayList<LetInfo> arrayList2 = patternInfo.letList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            LetInfo letInfo = arrayList2.get(i);
            patternInfo3.letList.add(this.expandLetInfo(letInfo, (ParamInfo[])objectArray));
        }
        ArrayList<RuleInfo> arrayList3 = patternInfo.ruleList;
        n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            RuleInfo ruleInfo = arrayList3.get(i);
            patternInfo3.ruleList.add(this.expandRuleInfo(ruleInfo, (ParamInfo[])objectArray));
        }
        return patternInfo3;
    }

    private LetInfo expandLetInfo(LetInfo letInfo, ParamInfo[] paramInfoArray) {
        LetInfo letInfo2 = new LetInfo();
        letInfo2.location = letInfo.location;
        letInfo2.url = letInfo.url;
        letInfo2.lineNumber = letInfo.lineNumber;
        letInfo2.columnNumber = letInfo.columnNumber;
        letInfo2.name = letInfo.name;
        letInfo2.valueString = SchematronLoader.substituteParams(letInfo.valueString, paramInfoArray);
        return letInfo2;
    }

    private static final String substituteParams(String string, ParamInfo[] paramInfoArray) {
        if (string.indexOf(36) < 0) {
            return string;
        }
        String string2 = string;
        for (int i = 0; i < paramInfoArray.length; ++i) {
            ParamInfo paramInfo = paramInfoArray[i];
            string2 = StringUtil.replaceAll(string2, "$" + paramInfo.name, paramInfo.value);
        }
        return string2;
    }

    private RuleInfo expandRuleInfo(RuleInfo ruleInfo, ParamInfo[] paramInfoArray) {
        RuleInfo ruleInfo2 = new RuleInfo();
        ruleInfo2.location = ruleInfo.location;
        ruleInfo2.url = ruleInfo.url;
        ruleInfo2.lineNumber = ruleInfo.lineNumber;
        ruleInfo2.columnNumber = ruleInfo.columnNumber;
        ruleInfo2.id = ruleInfo.id;
        ruleInfo2.isAbstract = ruleInfo.isAbstract;
        ruleInfo2.contextString = ruleInfo.contextString == null ? null : SchematronLoader.substituteParams(ruleInfo.contextString, paramInfoArray);
        ruleInfo2.letList = new ArrayList();
        ruleInfo2.assertOrExtendsList = new ArrayList();
        ruleInfo2.containsExtends = ruleInfo.containsExtends;
        ArrayList<LetInfo> arrayList = ruleInfo.letList;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            LetInfo letInfo = arrayList.get(i);
            ruleInfo2.letList.add(this.expandLetInfo(letInfo, paramInfoArray));
        }
        ArrayList<Info> arrayList2 = ruleInfo.assertOrExtendsList;
        n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Info info = arrayList2.get(i);
            if (info instanceof AssertInfo) {
                ruleInfo2.assertOrExtendsList.add(this.expandAssertInfo((AssertInfo)info, paramInfoArray));
                continue;
            }
            ruleInfo2.assertOrExtendsList.add(info);
        }
        return ruleInfo2;
    }

    private AssertInfo expandAssertInfo(AssertInfo assertInfo, ParamInfo[] paramInfoArray) {
        AssertInfo assertInfo2 = assertInfo instanceof ReportInfo ? new ReportInfo() : new AssertInfo();
        assertInfo2.location = assertInfo.location;
        assertInfo2.url = assertInfo.url;
        assertInfo2.lineNumber = assertInfo.lineNumber;
        assertInfo2.columnNumber = assertInfo.columnNumber;
        assertInfo2.testString = SchematronLoader.substituteParams(assertInfo.testString, paramInfoArray);
        assertInfo2.messagePartList = new ArrayList();
        ArrayList<Object> arrayList = assertInfo.messagePartList;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3 = arrayList.get(i);
            if (object3 instanceof NameInfo) {
                object2 = (NameInfo)object3;
                object = ((NameInfo)object2).pathString == null ? object2 : new NameInfo(SchematronLoader.substituteParams(((NameInfo)object2).pathString, paramInfoArray));
            } else if (object3 instanceof ValueOfInfo) {
                object2 = (ValueOfInfo)object3;
                object = new ValueOfInfo(SchematronLoader.substituteParams(((ValueOfInfo)object2).selectString, paramInfoArray));
            } else {
                object = SchematronLoader.substituteParams((String)object3, paramInfoArray);
            }
            assertInfo2.messagePartList.add(object);
        }
        return assertInfo2;
    }

    private boolean preProcessRules() {
        boolean bl = false;
        for (PatternInfo patternInfo : this.patternMap.values()) {
            if (!patternInfo.preProcessRules || this.doPreProcessRules(patternInfo)) continue;
            bl = true;
        }
        return !bl;
    }

    private boolean doPreProcessRules(PatternInfo patternInfo) {
        patternInfo.preProcessRules = false;
        ArrayList<RuleInfo> arrayList = new ArrayList<RuleInfo>();
        boolean bl = false;
        RuleInfo[] ruleInfoArray = new RuleInfo[patternInfo.ruleList.size()];
        patternInfo.ruleList.toArray(ruleInfoArray);
        for (int i = 0; i < ruleInfoArray.length; ++i) {
            RuleInfo ruleInfo = ruleInfoArray[i];
            if (ruleInfo.isAbstract) continue;
            if (!ruleInfo.containsExtends) {
                arrayList.add(ruleInfo);
                continue;
            }
            RuleInfo ruleInfo2 = this.preProcessRule(ruleInfo, ruleInfoArray);
            if (ruleInfo2 == null) {
                bl = true;
                continue;
            }
            arrayList.add(ruleInfo2);
        }
        if (bl) {
            return false;
        }
        patternInfo.ruleList = arrayList;
        return true;
    }

    private RuleInfo preProcessRule(RuleInfo ruleInfo, RuleInfo[] ruleInfoArray) {
        RuleInfo ruleInfo2 = new RuleInfo();
        ruleInfo2.location = ruleInfo.location;
        ruleInfo2.url = ruleInfo.url;
        ruleInfo2.lineNumber = ruleInfo.lineNumber;
        ruleInfo2.columnNumber = ruleInfo.columnNumber;
        ruleInfo2.id = ruleInfo.id;
        ruleInfo2.isAbstract = false;
        ruleInfo2.contextString = ruleInfo.contextString;
        ruleInfo2.letList = ruleInfo.letList;
        ruleInfo2.assertOrExtendsList = new ArrayList();
        ruleInfo2.containsExtends = false;
        if (!this.collectAssertions(ruleInfo.assertOrExtendsList, ruleInfoArray, new Stack<String>(), ruleInfo2.assertOrExtendsList)) {
            return null;
        }
        return ruleInfo2;
    }

    private boolean collectAssertions(ArrayList<Info> arrayList, RuleInfo[] ruleInfoArray, Stack<String> stack, ArrayList<Info> arrayList2) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Info info = arrayList.get(i);
            if (info instanceof ExtendsInfo) {
                int n2;
                String string = ((ExtendsInfo)info).rule;
                RuleInfo ruleInfo = null;
                for (n2 = 0; n2 < ruleInfoArray.length; ++n2) {
                    if (!string.equals(ruleInfoArray[n2].id)) continue;
                    ruleInfo = ruleInfoArray[n2];
                    break;
                }
                if (ruleInfo == null) {
                    this.addError(info, Msg.msg("elementNotFound", "rule", string));
                    return false;
                }
                if (!ruleInfo.isAbstract) {
                    this.addError(info, Msg.msg("notAbstract", "rule", string));
                    return false;
                }
                for (n2 = stack.size() - 1; n2 >= 0; --n2) {
                    String string2 = (String)stack.get(n2);
                    if (!string.equals(string2)) continue;
                    this.addError(info, Msg.msg("infiniteLoop", "extends"));
                    return false;
                }
                stack.push(string);
                n2 = this.collectAssertions(ruleInfo.assertOrExtendsList, ruleInfoArray, stack, arrayList2) ? 1 : 0;
                stack.pop();
                if (n2 != 0) continue;
                return false;
            }
            arrayList2.add(info);
        }
        return true;
    }

    private boolean doCreatePatterns() {
        boolean bl = false;
        HashMap<String, Pattern> hashMap = new HashMap<String, Pattern>();
        for (PatternInfo patternInfo : this.patternMap.values()) {
            Pattern pattern = this.createPattern(patternInfo);
            if (pattern == null) {
                bl = true;
                continue;
            }
            hashMap.put(patternInfo.id, pattern);
        }
        if (bl) {
            return false;
        }
        this.idToPattern = hashMap;
        return true;
    }

    private Pattern createPattern(PatternInfo patternInfo) {
        Object object;
        ArrayList<RuleInfo> arrayList = patternInfo.ruleList;
        int n = arrayList.size();
        Rule[] ruleArray = new Rule[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            object = arrayList.get(i);
            Rule rule = this.createRule((RuleInfo)object);
            if (rule == null) {
                bl = true;
                continue;
            }
            ruleArray[i] = rule;
        }
        LetVariable[] letVariableArray = this.createLetVariables(patternInfo.letList);
        if (letVariableArray == null) {
            bl = true;
        }
        if (bl) {
            return null;
        }
        object = patternInfo.id.startsWith("#") ? null : patternInfo.id;
        return new Pattern((String)object, letVariableArray, ruleArray);
    }

    private Rule createRule(RuleInfo ruleInfo) {
        boolean bl = false;
        PathPattern pathPattern = null;
        try {
            pathPattern = ExprParser.parsePattern(ruleInfo.contextString, this.prefixToNs);
        }
        catch (ParseException parseException) {
            this.addError(ruleInfo, Msg.msg("invalidAttribute2", "context", ThrowableUtil.reason(parseException)));
            bl = true;
        }
        ArrayList<Info> arrayList = ruleInfo.assertOrExtendsList;
        int n = arrayList.size();
        Assertion[] assertionArray = new Assertion[n];
        for (int i = 0; i < n; ++i) {
            AssertInfo assertInfo = (AssertInfo)arrayList.get(i);
            Assertion assertion = this.createAssertion(assertInfo);
            if (assertion == null) {
                bl = true;
                continue;
            }
            assertionArray[i] = assertion;
        }
        LetVariable[] letVariableArray = this.createLetVariables(ruleInfo.letList);
        if (letVariableArray == null) {
            bl = true;
        }
        if (bl) {
            return null;
        }
        return new Rule(pathPattern, ruleInfo.contextString, letVariableArray, assertionArray);
    }

    private Assertion createAssertion(AssertInfo assertInfo) {
        boolean bl = false;
        BooleanExpr booleanExpr = null;
        try {
            booleanExpr = ExprParser.parseBooleanExpr(assertInfo.testString, this.prefixToNs);
        }
        catch (ParseException parseException) {
            this.addError(assertInfo, Msg.msg("invalidAttribute2", "test", ThrowableUtil.reason(parseException)));
            bl = true;
        }
        ArrayList<Object> arrayList = assertInfo.messagePartList;
        int n = arrayList.size();
        Message.Part[] partArray = new Message.Part[n];
        for (int i = 0; i < n; ++i) {
            Message.Part part;
            Object object;
            Object object2;
            Object object3 = arrayList.get(i);
            if (object3 instanceof NameInfo) {
                object2 = (NameInfo)object3;
                object = null;
                if (((NameInfo)object2).pathString != null) {
                    try {
                        object = ExprParser.parseNodeSetExpr(((NameInfo)object2).pathString, this.prefixToNs);
                    }
                    catch (ParseException parseException) {
                        this.addError(assertInfo, Msg.msg("invalidAttribute2", "path", ThrowableUtil.reason(parseException)));
                        bl = true;
                    }
                }
                part = new Message.Name((NodeSetExpr)object, ((NameInfo)object2).pathString);
            } else if (object3 instanceof ValueOfInfo) {
                object2 = (ValueOfInfo)object3;
                object = null;
                try {
                    object = ExprParser.parseStringExpr(((ValueOfInfo)object2).selectString, this.prefixToNs);
                }
                catch (ParseException parseException) {
                    this.addError(assertInfo, Msg.msg("invalidAttribute2", "select", ThrowableUtil.reason(parseException)));
                    bl = true;
                }
                part = new Message.ValueOf((StringExpr)object, ((ValueOfInfo)object2).selectString);
            } else {
                part = new Message.Text((String)object3);
            }
            partArray[i] = part;
        }
        if (bl) {
            return null;
        }
        Message message = partArray.length == 0 ? null : new Message(partArray, assertInfo.url);
        return new Assertion(booleanExpr, assertInfo.testString, assertInfo instanceof ReportInfo, message, assertInfo.url);
    }

    private LinearHashtable<String, Phase> createPhases() {
        LinearHashtable<String, Phase> linearHashtable = new LinearHashtable<String, Phase>();
        boolean bl = false;
        for (PhaseInfo object2 : this.phaseMap.values()) {
            ArrayList<ActiveInfo> arrayList = object2.activeList;
            int n = arrayList.size();
            Pattern[] patternArray = new Pattern[n];
            for (int i = 0; i < n; ++i) {
                ActiveInfo activeInfo = arrayList.get(i);
                Pattern pattern = this.idToPattern.get(activeInfo.pattern);
                if (pattern == null) {
                    this.addError(activeInfo, Msg.msg("elementNotFound", "pattern", activeInfo.pattern));
                    bl = true;
                    continue;
                }
                patternArray[i] = pattern;
            }
            LetVariable[] letVariableArray = this.createLetVariables(object2.letList);
            if (letVariableArray == null) {
                bl = true;
            }
            if (bl) continue;
            linearHashtable.put(object2.id, new Phase(object2.id, letVariableArray, patternArray));
        }
        if (this.schemaInfo != null && this.schemaInfo.defaultPhase != null) {
            Phase phase = (Phase)linearHashtable.get(this.schemaInfo.defaultPhase);
            if (phase == null) {
                this.addError(this.schemaInfo, Msg.msg("elementNotFound", "phase", this.schemaInfo.defaultPhase));
                bl = true;
            } else {
                linearHashtable.put("#DEFAULT", phase);
            }
        }
        if (bl) {
            return null;
        }
        Pattern[] patternArray = new Pattern[this.idToPattern.size()];
        this.idToPattern.values().toArray(patternArray);
        linearHashtable.put("#ALL", new Phase("#ALL", NO_LET_VARIABLES, patternArray));
        return linearHashtable;
    }

    private boolean parse(URL uRL) {
        SAXParser sAXParser = null;
        try {
            sAXParser = XMLUtil.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(XMLCatalogs.getEntityResolver());
        }
        catch (Exception exception) {
            this.errorList.add(new SchematronError(uRL.toExternalForm(), -1, -1, Msg.msg("cannotCreateParser", ThrowableUtil.reason(exception))));
            return false;
        }
        boolean bl = false;
        try {
            sAXParser.parse(uRL.toExternalForm(), (DefaultHandler)this);
            bl = true;
        }
        catch (IOException iOException) {
            this.errorList.add(new SchematronError(uRL.toExternalForm(), -1, -1, Msg.msg("cannotParse", uRL, ThrowableUtil.reason(iOException))));
        }
        catch (SAXException sAXException) {
        }
        catch (StopParsingException stopParsingException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locatorStack.push(locator);
    }

    @Override
    public void endDocument() throws SAXException {
        this.locatorStack.pop();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.prefixToNs.prefixPrefs2.add(Namespace.get(string2), string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Info info = this.topInfo();
        if (info != null) {
            info.startElement(string, string2, attributes);
        } else {
            Info info2 = null;
            if (SchematronLoader.isISONsOrPreISONs(string)) {
                if ("pattern".equals(string2)) {
                    info2 = new PatternInfo();
                } else if ("phase".equals(string2)) {
                    info2 = new PhaseInfo();
                } else if ("ns".equals(string2)) {
                    info2 = new NsInfo();
                } else if ("let".equals(string2)) {
                    info2 = new LetInfo();
                } else if ("schema".equals(string2)) {
                    info2 = new SchemaInfo();
                } else if ("include".equals(string2)) {
                    if (this.pushInclude(attributes.getValue("href"), new String[]{"ns", "let", "key", "phase", "pattern"})) {
                        return;
                    }
                    info2 = new Skip(string, "include");
                }
            } else if (SchematronLoader.isXSLTNs(string) && "key".equals(string2)) {
                info2 = new KeyInfo();
            }
            if (info2 != null) {
                this.infoStack.push(info2);
                ((Info)info2).startElement(string, string2, attributes);
            }
        }
    }

    private Locator topLocator() {
        return this.locatorStack.empty() ? null : this.locatorStack.peek();
    }

    private Info topInfo() {
        return this.infoStack.empty() ? null : this.infoStack.peek();
    }

    private static final boolean isISONsOrPreISONs(String string) {
        return "http://purl.oclc.org/dsdl/schematron".equals(string) || SchematronLoader.isPreISONs(string);
    }

    private static final boolean isPreISONs(String string) {
        return "http://www.ascc.net/xml/schematron".equals(string);
    }

    private static final boolean isXSLTNs(String string) {
        return "http://www.w3.org/1999/XSL/Transform".equals(string);
    }

    private boolean pushInclude(String string, String[] stringArray) {
        URL uRL = null;
        if (string != null && (string = string.trim()).length() > 0) {
            try {
                uRL = XMLCatalogs.resolveURI(string, this.getLocatorURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            this.addError(Msg.msg("missingOrInvalidAttribute", "href"));
            return false;
        }
        boolean bl = false;
        if (uRL.equals(this.schemaURL)) {
            bl = true;
        } else {
            for (int i = this.infoStack.size() - 1; i >= 0; --i) {
                Info info = (Info)this.infoStack.get(i);
                if (!(info instanceof IncludeInfo) || !uRL.equals(((IncludeInfo)info).includeURL)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.addError(Msg.msg("infiniteLoop", "include"));
            return false;
        }
        this.infoStack.push(new IncludeInfo(uRL, stringArray));
        if (!this.parse(uRL)) {
            throw new StopParsingException();
        }
        return true;
    }

    private URL getLocatorURL() {
        URL uRL = null;
        Locator locator = this.topLocator();
        if (locator != null) {
            try {
                uRL = URLUtil.newURL(locator.getSystemId());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    private void addError(String string) {
        int n;
        int n2;
        String string2;
        Locator locator = this.topLocator();
        if (locator != null) {
            string2 = locator.getSystemId();
            n2 = locator.getLineNumber();
            n = locator.getColumnNumber();
        } else {
            string2 = this.schemaURL.toExternalForm();
            n = -1;
            n2 = -1;
        }
        this.errorList.add(new SchematronError(string2, n2, n, string));
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Info info = this.topInfo();
        if (info != null) {
            info.characters(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Info info = this.topInfo();
        if (info != null) {
            info.endElement(string, string2);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.fatalError(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errorList.add(new SchematronError(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), Msg.msg("xmlSyntax", sAXParseException.getMessage())));
        throw sAXParseException;
    }

    private static final boolean hasAttribute(Attributes attributes, String string) {
        return attributes.getValue(string) != null;
    }

    private static final Boolean getBoolean(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        if ("true".equals(string2 = string2.trim())) {
            return Boolean.TRUE;
        }
        if ("false".equals(string2)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static final String getId(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        if (!XMLText.isName(string2 = string2.trim())) {
            return null;
        }
        return string2;
    }

    private static final String getNCName(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        if (!XMLText.isNCName(string2 = string2.trim())) {
            return null;
        }
        return string2;
    }

    private static final String getAnyURI(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        string2 = string2.trim();
        try {
            new URI(string2);
            return string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private static final String getNonEmptyString(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        return string2;
    }

    private static final String getNonEmptyToken(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        if ((string2 = XMLText.collapseWhiteSpace(string2)).length() == 0) {
            return null;
        }
        return string2;
    }

    private Name getName(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        return Name.parse(string2.trim(), true, this.prefixToNs);
    }

    private Info findInfo(Class<?> clazz) {
        for (int i = this.infoStack.size() - 1; i >= 0; --i) {
            Info info = (Info)this.infoStack.get(i);
            if (info.getClass() != clazz) continue;
            return info;
        }
        return null;
    }

    private final class ReportInfo
    extends AssertInfo {
        public ReportInfo() {
            super("report");
        }
    }

    private static final class ValueOfInfo {
        public final String selectString;

        public ValueOfInfo(String string) {
            this.selectString = string;
        }
    }

    private static final class NameInfo {
        public final String pathString;

        public NameInfo(String string) {
            this.pathString = string;
        }
    }

    private class AssertInfo
    extends Info {
        public String testString;
        public ArrayList<Object> messagePartList;
        private String elementLocalName;
        private StringBuilder buffer;

        public AssertInfo() {
            this("assert");
        }

        protected AssertInfo(String string) {
            this.messagePartList = new ArrayList();
            this.elementLocalName = string;
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Object object;
            boolean bl = false;
            if (SchematronLoader.isISONsOrPreISONs(string)) {
                if (this.elementLocalName.equals(string2)) {
                    if (this.location == null) {
                        this.initLocation();
                        this.testString = SchematronLoader.getNonEmptyString(attributes, "test");
                        if (this.testString == null) {
                            SchematronLoader.this.addError(Msg.msg("missingOrEmptyAttribute", "test"));
                        } else {
                            RuleInfo ruleInfo = (RuleInfo)SchematronLoader.this.findInfo(RuleInfo.class);
                            ruleInfo.assertOrExtendsList.add(this);
                        }
                        this.buffer = new StringBuilder();
                        return;
                    }
                    bl = true;
                } else if ("name".equals(string2)) {
                    if (this.buffer.length() > 0) {
                        this.messagePartList.add(this.buffer.toString());
                        this.buffer = new StringBuilder();
                    }
                    object = null;
                    if (SchematronLoader.hasAttribute(attributes, "path") && (object = SchematronLoader.getNonEmptyString(attributes, "path")) == null) {
                        SchematronLoader.this.addError(Msg.msg("missingOrEmptyAttribute", "path"));
                    }
                    this.messagePartList.add(new NameInfo((String)object));
                } else if ("value-of".equals(string2)) {
                    if (this.buffer.length() > 0) {
                        this.messagePartList.add(this.buffer.toString());
                        this.buffer = new StringBuilder();
                    }
                    if ((object = SchematronLoader.getNonEmptyString(attributes, "select")) == null) {
                        SchematronLoader.this.addError(Msg.msg("missingOrEmptyAttribute", "select"));
                    } else {
                        this.messagePartList.add(new ValueOfInfo((String)object));
                    }
                } else if (!("emph".equals(string2) || "dir".equals(string2) || "span".equals(string2))) {
                    bl = true;
                }
            }
            if (bl) {
                object = new Skip(string, string2);
                SchematronLoader.this.infoStack.push((Info)object);
                ((Info)object).startElement(string, string2, attributes);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.buffer.append(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2) {
            if (SchematronLoader.isISONsOrPreISONs(string) && this.elementLocalName.equals(string2)) {
                if (this.buffer.length() > 0) {
                    this.messagePartList.add(this.buffer.toString());
                }
                this.buffer = null;
                SchematronLoader.this.infoStack.pop();
                int n = this.messagePartList.size() - 1;
                for (int i = 0; i <= n; ++i) {
                    int n2;
                    Object object = this.messagePartList.get(i);
                    if (!(object instanceof String)) continue;
                    String string3 = XMLText.compressWhiteSpace((String)object);
                    if (i == 0 && string3.length() > 0 && string3.charAt(0) == ' ') {
                        string3 = string3.substring(1);
                    }
                    if (i == n && (n2 = string3.length()) > 0 && string3.charAt(n2 - 1) == ' ') {
                        string3 = string3.substring(0, n2 - 1);
                    }
                    this.messagePartList.set(i, string3);
                }
            }
        }
    }

    private final class ExtendsInfo
    extends Info {
        public String rule;

        private ExtendsInfo() {
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Skip skip = null;
            if (SchematronLoader.isISONsOrPreISONs(string) && "extends".equals(string2) && this.location == null) {
                this.initLocation();
                this.rule = SchematronLoader.getId(attributes, "rule");
                if (this.rule == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "rule"));
                } else {
                    RuleInfo ruleInfo = (RuleInfo)SchematronLoader.this.findInfo(RuleInfo.class);
                    ruleInfo.assertOrExtendsList.add(this);
                    ruleInfo.containsExtends = true;
                }
                return;
            }
            if (skip == null) {
                skip = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(skip);
            ((Info)skip).startElement(string, string2, attributes);
        }
    }

    private final class RuleInfo
    extends Info {
        public String id;
        public boolean isAbstract;
        public String contextString;
        public ArrayList<LetInfo> letList;
        public ArrayList<Info> assertOrExtendsList;
        public boolean containsExtends;

        private RuleInfo() {
            this.letList = new ArrayList();
            this.assertOrExtendsList = new ArrayList();
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Info info = null;
            if (SchematronLoader.isISONsOrPreISONs(string)) {
                if ("rule".equals(string2)) {
                    if (this.location == null) {
                        Object object;
                        this.initLocation();
                        boolean bl = false;
                        if (SchematronLoader.hasAttribute(attributes, "id")) {
                            this.id = SchematronLoader.getId(attributes, "id");
                            if (this.id == null) {
                                SchematronLoader.this.addError(Msg.msg("invalidAttribute", "id"));
                                bl = true;
                            }
                        }
                        if (SchematronLoader.hasAttribute(attributes, "abstract")) {
                            object = SchematronLoader.getBoolean(attributes, "abstract");
                            if (object == null) {
                                SchematronLoader.this.addError(Msg.msg("invalidAttribute", "abstract"));
                                bl = true;
                            } else {
                                this.isAbstract = (Boolean)object;
                            }
                        }
                        if (SchematronLoader.hasAttribute(attributes, "context")) {
                            this.contextString = SchematronLoader.getNonEmptyString(attributes, "context");
                            if (this.contextString == null) {
                                SchematronLoader.this.addError(Msg.msg("invalidAttribute", "context"));
                                bl = true;
                            }
                        }
                        if (!bl) {
                            if (this.isAbstract) {
                                if (this.id == null) {
                                    SchematronLoader.this.addError(Msg.msg("missingAttribute", "id"));
                                    bl = true;
                                }
                                if (this.contextString != null) {
                                    SchematronLoader.this.addError(Msg.msg("abstractRuleHavingContext"));
                                    bl = true;
                                }
                            } else if (this.contextString == null) {
                                SchematronLoader.this.addError(Msg.msg("missingAttribute", "context"));
                                bl = true;
                            }
                        }
                        if (!bl) {
                            object = (PatternInfo)SchematronLoader.this.findInfo(PatternInfo.class);
                            ((PatternInfo)object).ruleList.add(this);
                        }
                        return;
                    }
                } else if ("assert".equals(string2)) {
                    info = new AssertInfo();
                } else if ("report".equals(string2)) {
                    info = new ReportInfo();
                } else if ("let".equals(string2)) {
                    info = new LetInfo();
                } else if ("extends".equals(string2)) {
                    info = new ExtendsInfo();
                } else if ("key".equals(string2) && SchematronLoader.isPreISONs(string)) {
                    info = new KeyInfo();
                } else if ("include".equals(string2)) {
                    String[] stringArray = SchematronLoader.isPreISONs(string) ? new String[]{"let", "extends", "assert", "report", "key"} : new String[]{"let", "extends", "assert", "report"};
                    if (SchematronLoader.this.pushInclude(attributes.getValue("href"), stringArray)) {
                        return;
                    }
                }
            }
            if (info == null) {
                info = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(info);
            ((Info)info).startElement(string, string2, attributes);
        }

        @Override
        public void endElement(String string, String string2) {
            SchematronLoader.this.infoStack.pop();
            if (this.assertOrExtendsList.size() == 0) {
                SchematronLoader.this.addError(Msg.msg("emptyRule"));
            }
            if (this.isAbstract || this.containsExtends) {
                PatternInfo patternInfo = (PatternInfo)SchematronLoader.this.findInfo(PatternInfo.class);
                patternInfo.preProcessRules = true;
            }
        }
    }

    private final class ParamInfo
    extends Info
    implements Comparable<ParamInfo> {
        public String name;
        public String value;

        private ParamInfo() {
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Skip skip = null;
            if (SchematronLoader.isISONsOrPreISONs(string) && "param".equals(string2) && this.location == null) {
                this.initLocation();
                this.name = SchematronLoader.getNCName(attributes, "name");
                if (this.name == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "name"));
                }
                this.value = SchematronLoader.getNonEmptyToken(attributes, "value");
                if (this.value == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "value"));
                }
                if (this.name != null && this.value != null) {
                    PatternInfo patternInfo = (PatternInfo)SchematronLoader.this.findInfo(PatternInfo.class);
                    patternInfo.paramList.add(this);
                }
                return;
            }
            if (skip == null) {
                skip = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(skip);
            ((Info)skip).startElement(string, string2, attributes);
        }

        @Override
        public int compareTo(ParamInfo paramInfo) {
            return paramInfo.name.compareTo(this.name);
        }
    }

    private final class PatternInfo
    extends Info {
        public String id;
        public boolean isAbstract;
        public String templatePattern;
        public ArrayList<LetInfo> letList;
        public ArrayList<RuleInfo> ruleList;
        public boolean preProcessRules;
        public ArrayList<ParamInfo> paramList;

        private PatternInfo() {
            this.letList = new ArrayList();
            this.ruleList = new ArrayList();
            this.paramList = new ArrayList();
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Info info = null;
            if (SchematronLoader.isISONsOrPreISONs(string)) {
                if ("pattern".equals(string2)) {
                    if (this.location == null) {
                        this.initLocation();
                        boolean bl = false;
                        if (SchematronLoader.hasAttribute(attributes, "id")) {
                            this.id = SchematronLoader.getId(attributes, "id");
                            if (this.id == null) {
                                SchematronLoader.this.addError(Msg.msg("invalidAttribute", "id"));
                                bl = true;
                            }
                        }
                        if (SchematronLoader.hasAttribute(attributes, "abstract")) {
                            Boolean bl2 = SchematronLoader.getBoolean(attributes, "abstract");
                            if (bl2 == null) {
                                SchematronLoader.this.addError(Msg.msg("invalidAttribute", "abstract"));
                                bl = true;
                            } else {
                                this.isAbstract = bl2;
                            }
                        }
                        if (SchematronLoader.hasAttribute(attributes, "is-a")) {
                            this.templatePattern = SchematronLoader.getId(attributes, "is-a");
                            if (this.templatePattern == null) {
                                SchematronLoader.this.addError(Msg.msg("invalidAttribute", "is-a"));
                                bl = true;
                            }
                        }
                        if (!bl && this.isAbstract) {
                            if (this.id == null) {
                                SchematronLoader.this.addError(Msg.msg("missingAttribute", "id"));
                                bl = true;
                            }
                            if (this.templatePattern != null) {
                                SchematronLoader.this.addError(Msg.msg("invalidInstanceOfAbstractPattern1"));
                                bl = true;
                            }
                        }
                        if (!bl) {
                            if (this.id == null) {
                                this.id = "#" + Integer.toString(SchematronLoader.this.patternMap.size());
                            }
                            SchematronLoader.this.patternMap.put(this.id, this);
                            if (this.isAbstract || this.templatePattern != null) {
                                SchematronLoader.this.preProcessPatterns = true;
                            }
                        }
                        return;
                    }
                } else if ("rule".equals(string2)) {
                    info = new RuleInfo();
                } else if ("let".equals(string2)) {
                    info = new LetInfo();
                } else if ("param".equals(string2)) {
                    info = new ParamInfo();
                } else if ("include".equals(string2) && SchematronLoader.this.pushInclude(attributes.getValue("href"), new String[]{"let", "rule", "param"})) {
                    return;
                }
            }
            if (info == null) {
                info = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(info);
            ((Info)info).startElement(string, string2, attributes);
        }

        @Override
        public void endElement(String string, String string2) {
            SchematronLoader.this.infoStack.pop();
            if (this.templatePattern != null) {
                if (this.ruleList.size() > 0 || this.letList.size() > 0) {
                    SchematronLoader.this.addError(Msg.msg("invalidInstanceOfAbstractPattern2"));
                }
            } else if (this.paramList.size() > 0) {
                SchematronLoader.this.addError(Msg.msg("cannotContainParam"));
            }
        }
    }

    private final class ActiveInfo
    extends Info {
        public String pattern;

        private ActiveInfo() {
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Skip skip = null;
            if (SchematronLoader.isISONsOrPreISONs(string) && "active".equals(string2) && this.location == null) {
                this.initLocation();
                this.pattern = SchematronLoader.getId(attributes, "pattern");
                if (this.pattern == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "pattern"));
                } else {
                    PhaseInfo phaseInfo = (PhaseInfo)SchematronLoader.this.findInfo(PhaseInfo.class);
                    phaseInfo.activeList.add(this);
                }
                return;
            }
            if (skip == null) {
                skip = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(skip);
            ((Info)skip).startElement(string, string2, attributes);
        }
    }

    private final class PhaseInfo
    extends Info {
        public String id;
        public ArrayList<LetInfo> letList;
        public ArrayList<ActiveInfo> activeList;

        private PhaseInfo() {
            this.letList = new ArrayList();
            this.activeList = new ArrayList();
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Info info = null;
            if (SchematronLoader.isISONsOrPreISONs(string)) {
                if ("phase".equals(string2)) {
                    if (this.location == null) {
                        this.initLocation();
                        this.id = SchematronLoader.getId(attributes, "id");
                        if (this.id == null) {
                            SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "id"));
                        } else {
                            SchematronLoader.this.phaseMap.put(this.id, this);
                        }
                        return;
                    }
                } else if ("active".equals(string2)) {
                    info = new ActiveInfo();
                } else if ("let".equals(string2)) {
                    info = new LetInfo();
                } else if ("include".equals(string2) && SchematronLoader.this.pushInclude(attributes.getValue("href"), new String[]{"let", "active"})) {
                    return;
                }
            }
            if (info == null) {
                info = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(info);
            ((Info)info).startElement(string, string2, attributes);
        }
    }

    private final class LetInfo
    extends Info {
        public String name;
        public String valueString;

        private LetInfo() {
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Skip skip = null;
            if (SchematronLoader.isISONsOrPreISONs(string) && "let".equals(string2) && this.location == null) {
                this.initLocation();
                this.name = SchematronLoader.getNCName(attributes, "name");
                if (this.name == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "name"));
                }
                this.valueString = SchematronLoader.getNonEmptyString(attributes, "value");
                if (this.valueString == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrEmptyAttribute", "value"));
                }
                if (this.name != null && this.valueString != null) {
                    ArrayList<LetInfo> arrayList = this.findLetList();
                    arrayList.add(this);
                }
                return;
            }
            if (skip == null) {
                skip = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(skip);
            ((Info)skip).startElement(string, string2, attributes);
        }

        private ArrayList<LetInfo> findLetList() {
            for (int i = SchematronLoader.this.infoStack.size() - 1; i >= 0; --i) {
                Info info = (Info)SchematronLoader.this.infoStack.get(i);
                Class<?> clazz = info.getClass();
                if (clazz == RuleInfo.class) {
                    return ((RuleInfo)info).letList;
                }
                if (clazz == PatternInfo.class) {
                    return ((PatternInfo)info).letList;
                }
                if (clazz != PhaseInfo.class) continue;
                return ((PhaseInfo)info).letList;
            }
            return SchematronLoader.this.letList;
        }
    }

    private final class KeyInfo
    extends Info {
        public Name name;
        public String matchString;
        public String useString;

        private KeyInfo() {
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Skip skip = null;
            boolean bl = false;
            if ((SchematronLoader.isXSLTNs(string) || (bl = SchematronLoader.isPreISONs(string))) && "key".equals(string2) && this.location == null) {
                RuleInfo ruleInfo;
                this.initLocation();
                this.name = SchematronLoader.this.getName(attributes, "name");
                if (this.name == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "name"));
                }
                String string3 = bl ? "context" : "match";
                this.matchString = SchematronLoader.getNonEmptyString(attributes, string3);
                if (this.matchString == null && bl && !SchematronLoader.hasAttribute(attributes, "context") && (ruleInfo = (RuleInfo)SchematronLoader.this.findInfo(RuleInfo.class)) != null) {
                    this.matchString = ruleInfo.contextString;
                }
                if (this.matchString == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrEmptyAttribute", string3));
                }
                string3 = bl ? "path" : "use";
                this.useString = SchematronLoader.getNonEmptyString(attributes, string3);
                if (this.useString == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrEmptyAttribute", string3));
                }
                if (this.name != null && this.matchString != null && this.useString != null) {
                    SchematronLoader.this.keyList.add(this);
                }
                return;
            }
            if (skip == null) {
                skip = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(skip);
            ((Info)skip).startElement(string, string2, attributes);
        }
    }

    private final class NsInfo
    extends Info {
        private NsInfo() {
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Skip skip = null;
            if (SchematronLoader.isISONsOrPreISONs(string) && "ns".equals(string2) && this.location == null) {
                String string3;
                this.initLocation();
                String string4 = SchematronLoader.getNCName(attributes, "prefix");
                if (string4 == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "prefix"));
                }
                if ((string3 = SchematronLoader.getAnyURI(attributes, "uri")) == null) {
                    SchematronLoader.this.addError(Msg.msg("missingOrInvalidAttribute", "uri"));
                }
                if (string4 != null && string3 != null) {
                    SchematronLoader.this.prefixToNs.prefixPrefs.add(Namespace.get(string3), string4);
                }
                return;
            }
            if (skip == null) {
                skip = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(skip);
            ((Info)skip).startElement(string, string2, attributes);
        }
    }

    private final class SchemaInfo
    extends Info {
        public String defaultPhase;

        private SchemaInfo() {
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Info info = null;
            if (SchematronLoader.isISONsOrPreISONs(string)) {
                if ("schema".equals(string2)) {
                    if (this.location == null) {
                        String string3;
                        this.initLocation();
                        if (SchematronLoader.hasAttribute(attributes, "defaultPhase")) {
                            this.defaultPhase = SchematronLoader.getId(attributes, "defaultPhase");
                            if (this.defaultPhase == null) {
                                SchematronLoader.this.addError(Msg.msg("invalidAttribute", "defaultPhase"));
                            }
                        }
                        if ((string3 = SchematronLoader.getNonEmptyToken(attributes, "queryBinding")) != null && !"xslt".equalsIgnoreCase(string3)) {
                            SchematronLoader.this.addError(Msg.msg("unsupportedQueryBinding", string3));
                        }
                        SchematronLoader.this.schemaInfo = this;
                        return;
                    }
                } else if ("pattern".equals(string2)) {
                    info = new PatternInfo();
                } else if ("phase".equals(string2)) {
                    info = new PhaseInfo();
                } else if ("ns".equals(string2)) {
                    info = new NsInfo();
                } else if ("let".equals(string2)) {
                    info = new LetInfo();
                } else if ("include".equals(string2) && SchematronLoader.this.pushInclude(attributes.getValue("href"), new String[]{"ns", "let", "key", "phase", "pattern"})) {
                    return;
                }
            } else if (SchematronLoader.isXSLTNs(string) && "key".equals(string2)) {
                info = new KeyInfo();
            }
            if (info == null) {
                info = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(info);
            ((Info)info).startElement(string, string2, attributes);
        }
    }

    private final class IncludeInfo
    extends Info {
        public URL includeURL;
        private String[] allowedNames;
        private boolean allowKey;

        public IncludeInfo(URL uRL, String[] stringArray) {
            this.includeURL = uRL;
            if (StringList.contains(stringArray, "key")) {
                this.allowKey = true;
                this.allowedNames = StringList.remove(stringArray, "key");
            } else {
                this.allowKey = false;
                this.allowedNames = stringArray;
            }
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            Info info = null;
            if (SchematronLoader.isISONsOrPreISONs(string)) {
                if (StringList.contains(this.allowedNames, string2)) {
                    if ("pattern".equals(string2)) {
                        info = new PatternInfo();
                    } else if ("phase".equals(string2)) {
                        info = new PhaseInfo();
                    } else if ("rule".equals(string2)) {
                        info = new RuleInfo();
                    } else if ("assert".equals(string2)) {
                        info = new AssertInfo();
                    } else if ("report".equals(string2)) {
                        info = new ReportInfo();
                    } else if ("active".equals(string2)) {
                        info = new ActiveInfo();
                    } else if ("key".equals(string2)) {
                        info = new KeyInfo();
                    } else if ("let".equals(string2)) {
                        info = new LetInfo();
                    } else if ("ns".equals(string2)) {
                        info = new NsInfo();
                    } else if ("extends".equals(string2)) {
                        info = new ExtendsInfo();
                    } else if ("param".equals(string2)) {
                        info = new ParamInfo();
                    } else if ("schema".equals(string2)) {
                        info = new SchemaInfo();
                    } else if ("key".equals(string2) && this.allowKey && SchematronLoader.isPreISONs(string)) {
                        info = new KeyInfo();
                    }
                } else if ("include".equals(string2)) {
                    String[] stringArray = this.allowedNames;
                    if (this.allowKey) {
                        stringArray = StringList.append(stringArray, "key");
                    }
                    if (SchematronLoader.this.pushInclude(attributes.getValue("href"), stringArray)) {
                        return;
                    }
                }
            } else if (SchematronLoader.isXSLTNs(string) && this.allowKey && "key".equals(string2)) {
                info = new KeyInfo();
            }
            if (info == null) {
                info = new Skip(string, string2);
            }
            SchematronLoader.this.infoStack.push(info);
            ((Info)info).startElement(string, string2, attributes);
        }
    }

    private final class Skip
    extends Info {
        private String skippedNamespaceURI;
        private String skippedLocalName;
        private int nesting;

        public Skip(String string, String string2) {
            this.skippedNamespaceURI = string;
            this.skippedLocalName = string2;
        }

        @Override
        public void startElement(String string, String string2, Attributes attributes) {
            if (this.skippedNamespaceURI.equals(string) && this.skippedLocalName.equals(string2)) {
                ++this.nesting;
            }
        }

        @Override
        public void endElement(String string, String string2) {
            if (this.skippedNamespaceURI.equals(string) && this.skippedLocalName.equals(string2)) {
                --this.nesting;
                if (this.nesting == 0) {
                    SchematronLoader.this.infoStack.pop();
                }
            }
        }
    }

    private abstract class Info {
        public String location;
        public URL url;
        public int lineNumber;
        public int columnNumber;

        private Info() {
        }

        protected void initLocation() {
            Locator locator = SchematronLoader.this.topLocator();
            if (locator != null) {
                this.location = locator.getSystemId();
                try {
                    this.url = URLUtil.newURL(this.location);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.lineNumber = locator.getLineNumber();
                this.columnNumber = locator.getColumnNumber();
            } else {
                this.location = SchematronLoader.this.schemaURL.toExternalForm();
                this.url = SchematronLoader.this.schemaURL;
                this.columnNumber = -1;
                this.lineNumber = -1;
            }
        }

        public abstract void startElement(String var1, String var2, Attributes var3);

        public void characters(char[] cArray, int n, int n2) {
        }

        public void endElement(String string, String string2) {
            SchematronLoader.this.infoStack.pop();
        }
    }

    private static final class StopParsingException
    extends RuntimeException {
        private StopParsingException() {
        }
    }

    private static final class PrefixToNamespaceImpl
    implements PrefixToNamespace {
        public PrefixPreferences prefixPrefs = new PrefixPreferences();
        public PrefixPreferences prefixPrefs2 = new PrefixPreferences();

        private PrefixToNamespaceImpl() {
        }

        @Override
        public Namespace prefixToNamespace(String string) {
            Namespace namespace = this.prefixPrefs.get(string);
            if (namespace == null) {
                namespace = this.prefixPrefs2.get(string);
            }
            return namespace;
        }
    }
}

