/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.schematron.Constants;
import com.xmlmind.xml.schematron.KeySpec;
import com.xmlmind.xml.schematron.LetVariable;
import com.xmlmind.xml.schematron.Msg;
import com.xmlmind.xml.schematron.Pattern;
import com.xmlmind.xml.schematron.Phase;
import com.xmlmind.xml.schematron.ValidateExprContext;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.DiagnosticImpl;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprParser;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.StringExpr;
import com.xmlmind.xml.xpath.VariantExpr;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public final class Schematron
implements Constants {
    private final PrefixEntry[] prefixEntries;
    private final KeySpec[] keySpecs;
    private final LetVariable[] letVariables;
    private final LinearHashtable<String, Phase> phaseMap;
    private final URL schemaURL;
    private final PrefixPreferences prefixPreferences;

    Schematron(PrefixEntry[] prefixEntryArray, KeySpec[] keySpecArray, LetVariable[] letVariableArray, LinearHashtable<String, Phase> linearHashtable, URL uRL) {
        this.prefixEntries = prefixEntryArray;
        this.keySpecs = keySpecArray;
        this.letVariables = letVariableArray;
        this.phaseMap = linearHashtable;
        this.schemaURL = uRL;
        this.prefixPreferences = new PrefixPreferences(prefixEntryArray, false);
    }

    public URL getURL() {
        return this.schemaURL;
    }

    public Diagnostic[] validate(Document document, StringExpr stringExpr, String[] stringArray) throws EvalException {
        ValidateExprContext validateExprContext = this.createValidateExprContext(document, stringArray);
        validateExprContext.defaultBaseURL = this.schemaURL;
        String string = stringExpr.eval(document, validateExprContext);
        return this.doValidate(document, string, validateExprContext);
    }

    public Diagnostic[] validate(Document document, String string, String[] stringArray) throws EvalException {
        ValidateExprContext validateExprContext = this.createValidateExprContext(document, stringArray);
        return this.doValidate(document, string, validateExprContext);
    }

    private ValidateExprContext createValidateExprContext(Document document, String[] stringArray) throws EvalException {
        ValidateExprContext validateExprContext = new ValidateExprContext(this.keySpecs);
        if (this.letVariables.length > 0) {
            LetVariable[] letVariableArray = this.letVariables;
            if (stringArray != null && stringArray.length > 0) {
                letVariableArray = (LetVariable[])this.letVariables.clone();
                block2: for (int i = 0; i < stringArray.length; i += 2) {
                    String string = stringArray[i];
                    String string2 = stringArray[i + 1];
                    for (int j = 0; j < letVariableArray.length; ++j) {
                        if (!letVariableArray[j].name.equals(string)) continue;
                        VariantExpr variantExpr = null;
                        try {
                            variantExpr = ExprParser.parseVariantExpr(string2, this.prefixPreferences);
                        }
                        catch (ParseException parseException) {
                            throw new EvalException(Msg.msg("cannotParseVariableValue", string2, string, ThrowableUtil.reason(parseException)));
                        }
                        letVariableArray[j] = new LetVariable(string, variantExpr, string2, this.schemaURL);
                        continue block2;
                    }
                }
            }
            validateExprContext.pushVariables(letVariableArray, document);
        }
        return validateExprContext;
    }

    private Diagnostic[] doValidate(Document document, String string, ValidateExprContext validateExprContext) throws EvalException {
        Phase phase;
        if (string == null) {
            string = this.phaseMap.containsKey("#DEFAULT") ? "#DEFAULT" : "#ALL";
        }
        if ((phase = this.phaseMap.get(string)) == null) {
            throw new EvalException(Msg.msg("unknownPhase", string));
        }
        ArrayList<Diagnostic> arrayList = new ArrayList<Diagnostic>();
        phase.validate(document, validateExprContext, arrayList);
        return arrayList.toArray(DiagnosticImpl.NO_DIAGNOSTICS);
    }

    public String[] getPhaseIds() {
        Object[] objectArray;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Iterator<String> iterator = this.phaseMap.keys();
        while (iterator.hasNext()) {
            objectArray = iterator.next();
            if ("#DEFAULT".equals(objectArray) || "#ALL".equals(objectArray)) continue;
            arrayList.add(objectArray);
        }
        objectArray = arrayList.toArray(StringUtil.EMPTY_LIST);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public String getDefaultPhaseId() {
        Phase phase = this.phaseMap.get("#DEFAULT");
        if (phase == null) {
            return null;
        }
        Iterator<Phase> iterator = this.phaseMap.elements();
        while (iterator.hasNext()) {
            Phase phase2 = iterator.next();
            if (phase2 != phase) continue;
            return phase2.id;
        }
        return null;
    }

    public void writeXML(Writer writer) throws IOException {
        Pattern[] patternArray;
        int n;
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<sch:schema queryBinding=\"xslt\"");
        String string = this.getDefaultPhaseId();
        if (string != null) {
            writer.write(" defaultPhase=");
            writer.write(XMLText.quoteXML(string));
        }
        writer.write("\n  xmlns:sch=\"http://purl.oclc.org/dsdl/schematron\"");
        writer.write("\n  xmlns:xslt=\"http://www.w3.org/1999/XSL/Transform\"");
        writer.write(">\n");
        if (this.prefixEntries.length > 0) {
            if (this.prefixEntries.length > 1) {
                Arrays.sort(this.prefixEntries);
            }
            for (n = 0; n < this.prefixEntries.length; ++n) {
                this.writeNs(this.prefixEntries[n], writer, 2);
            }
            writer.write(10);
        }
        if (this.keySpecs.length > 0) {
            for (n = 0; n < this.keySpecs.length; ++n) {
                this.keySpecs[n].writeXML(writer, 2);
            }
            writer.write(10);
        }
        if (this.letVariables.length > 0) {
            for (n = 0; n < this.letVariables.length; ++n) {
                this.letVariables[n].writeXML(writer, 2);
            }
            writer.write(10);
        }
        String[] stringArray = this.getPhaseIds();
        for (int i = 0; i < stringArray.length; ++i) {
            patternArray = this.phaseMap.get(stringArray[i]);
            patternArray.writeXML(writer, 2);
            writer.write(10);
        }
        Phase phase = this.phaseMap.get("#ALL");
        patternArray = phase.patterns;
        for (int i = 0; i < patternArray.length; ++i) {
            if (i > 0) {
                writer.write(10);
            }
            patternArray[i].writeXML(writer, 2);
        }
        writer.write("</sch:schema>\n");
    }

    private void writeNs(PrefixEntry prefixEntry, Writer writer, int n) throws IOException {
        KeySpec.writeIndent(writer, n);
        writer.write("<sch:ns prefix=\"");
        writer.write(prefixEntry.prefix);
        writer.write("\" uri=");
        writer.write(XMLText.quoteXML(prefixEntry.namespace.uri));
        writer.write("/>\n");
    }
}

