/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.xpath.Pattern;
import com.xmlmind.xml.xpath.VariantExpr;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;

final class KeySpec {
    public final Name keyName;
    public final Pattern matchPattern;
    public final String matchString;
    public final VariantExpr useExpr;
    public final String useString;
    public final URL specURL;

    public KeySpec(Name name, Pattern pattern, String string, VariantExpr variantExpr, String string2, URL uRL) {
        this.keyName = name;
        this.matchPattern = pattern;
        this.matchString = string;
        this.useExpr = variantExpr;
        this.useString = string2;
        this.specURL = uRL;
    }

    public void writeXML(Writer writer, int n) throws IOException {
        KeySpec.writeIndent(writer, n);
        writer.write("<xslt:key name=");
        Namespace namespace = this.keyName.namespace;
        if (namespace == Namespace.NONE) {
            writer.write(34);
            writer.write(this.keyName.localPart);
            writer.write(34);
        } else {
            writer.write("\"__keyns__:");
            writer.write(this.keyName.localPart);
            writer.write("\" xmlns:__keyns__=");
            writer.write(XMLText.quoteXML(namespace.uri));
        }
        writer.write(" match=");
        writer.write(XMLText.quoteXML(this.matchString));
        writer.write(" use=");
        writer.write(XMLText.quoteXML(this.useString));
        writer.write("/>\n");
    }

    static void writeIndent(Writer writer, int n) throws IOException {
        while (n > 0) {
            writer.write(32);
            --n;
        }
    }
}

