/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.save;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.save.LineWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

final class WrappedLine {
    private final LineWriter out;
    private final int lineFirst;
    private final int lineEnd;
    private ArrayList<Object> list;
    private StringBuilder endString;

    public WrappedLine(LineWriter lineWriter, int n, int n2) {
        this.out = lineWriter;
        this.lineFirst = n;
        this.lineEnd = n2;
        this.list = new ArrayList();
    }

    public void add(char c) {
        int n = this.list.size();
        if (n == 0) {
            this.endString = new StringBuilder();
            this.endString.append(c);
            this.list.add(this.endString);
        } else if (this.endString != null) {
            this.endString.append(c);
        } else {
            this.endString = new StringBuilder();
            this.endString.append(c);
            this.list.add(this.endString);
        }
    }

    public void add(String string) {
        int n = this.list.size();
        if (n == 0) {
            this.endString = new StringBuilder(string);
            this.list.add(this.endString);
        } else if (this.endString != null) {
            this.endString.append(string);
        } else {
            this.endString = new StringBuilder(string);
            this.list.add(this.endString);
        }
    }

    public void addSpace() {
        int n = this.list.size();
        if (n == 0 || this.list.get(n - 1) != Boolean.TRUE) {
            this.list.add(Boolean.TRUE);
        }
        this.endString = null;
    }

    public void addAll(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t", true);
        block3: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1) {
                switch (string2.charAt(0)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        this.addSpace();
                        continue block3;
                    }
                }
                this.add(string2);
                continue;
            }
            this.add(string2);
        }
    }

    public void addElement(Element element) {
        this.list.add(element);
    }

    public void addInclusion(Inclusion inclusion) {
        this.list.add(inclusion);
    }

    public void flush() throws IOException {
        int n = this.list.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Object object = this.list.get(i);
                if (object instanceof StringBuilder) {
                    this.out.write(((StringBuilder)object).toString());
                    continue;
                }
                if (object instanceof Boolean) {
                    int n2;
                    StringBuilder stringBuilder = null;
                    for (n2 = i + 1; n2 < n; ++n2) {
                        Object object2 = this.list.get(n2);
                        if (!(object2 instanceof StringBuilder)) continue;
                        stringBuilder = (StringBuilder)object2;
                        break;
                    }
                    if (stringBuilder != null) {
                        n2 = this.out.getColumnNumber();
                        if (n2 <= this.lineFirst || n2 + 1 + stringBuilder.length() <= this.lineEnd) {
                            this.out.write(32);
                            continue;
                        }
                        this.out.writeIndent(this.lineFirst);
                        continue;
                    }
                    this.out.write(32);
                    continue;
                }
                if (object instanceof Element) {
                    this.out.writingElement((Element)object);
                    continue;
                }
                this.out.writingInclusion((Inclusion)object);
            }
            this.list.clear();
            this.endString = null;
        }
    }
}

