/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.save;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class QNameHelper {
    private boolean predeclarePrefixPrefs = false;
    private boolean favorInteroperability = false;
    private PrefixEntry[] prefixPreferences = null;
    private Namespace defaultNS = Namespace.NONE;
    private HashMap<NamespaceEntry, NamespaceEntry> namespacePrefixes = new HashMap();
    private HashMap<String, Namespace> prefixesInUse = new HashMap();
    private Namespace[] emptyPrefixNSStack = new Namespace[10];
    private int emptyPrefixNSStackSize = 0;
    private NamespaceEntry[] inScopeStack = new NamespaceEntry[10];
    private int inScopeStackSize = 0;
    private HashMap<NamespaceEntry, NamespaceEntry> inScopeSet = new HashMap();
    private NamespaceEntry probe = new NamespaceEntry(null, null);
    private ArrayList<String> xmlnsDeclList;

    public QNameHelper() {
        NamespaceEntry namespaceEntry = new NamespaceEntry(Namespace.XML, "xml");
        this.inScopeSet.put(namespaceEntry, namespaceEntry);
        this.xmlnsDeclList = new ArrayList();
    }

    public void setPredeclarePrefixPreferences(boolean bl) {
        this.predeclarePrefixPrefs = bl;
    }

    public boolean getPredeclarePrefixPreferences() {
        return this.predeclarePrefixPrefs;
    }

    public void setPrefixPreferences(PrefixEntry[] prefixEntryArray) {
        this.defaultNS = null;
        if (prefixEntryArray != null) {
            HashMap<PrefixEntry, PrefixEntry> hashMap = new HashMap<PrefixEntry, PrefixEntry>();
            for (PrefixEntry prefixEntry : prefixEntryArray) {
                int n;
                if (prefixEntry.namespace == Namespace.NONE || prefixEntry.namespace == Namespace.XML || (n = prefixEntry.prefix.length()) > 0 && (!XMLText.isNCName(prefixEntry.prefix) || prefixEntry.prefix.regionMatches(true, 0, "xml", 0, 3))) continue;
                if (n == 0) {
                    this.defaultNS = prefixEntry.namespace;
                    continue;
                }
                hashMap.put(prefixEntry, prefixEntry);
            }
            prefixEntryArray = new PrefixEntry[hashMap.size()];
            hashMap.values().toArray(prefixEntryArray);
            if (prefixEntryArray.length > 1) {
                Arrays.sort(prefixEntryArray);
            }
        }
        if (this.defaultNS == null) {
            this.defaultNS = Namespace.NONE;
        }
        this.prefixPreferences = prefixEntryArray;
    }

    public PrefixEntry[] getPrefixPreferences() {
        return this.prefixPreferences;
    }

    public void setFavorInteroperability(boolean bl) {
        this.favorInteroperability = bl;
    }

    public boolean getFavorInteroperability() {
        return this.favorInteroperability;
    }

    public void reset() {
        this.predeclarePrefixPrefs = false;
        this.namespacePrefixes.clear();
        this.prefixesInUse.clear();
        this.emptyPrefixNSStackSize = 0;
        this.inScopeStackSize = 0;
        this.inScopeSet.clear();
        NamespaceEntry namespaceEntry = new NamespaceEntry(Namespace.XML, "xml");
        this.inScopeSet.put(namespaceEntry, namespaceEntry);
        this.xmlnsDeclList.clear();
    }

    public void pushFrame() {
        this.dupEmptyPrefixNS();
        this.pushNamespace(null);
        if (this.inScopeStackSize == 1 && this.prefixPreferences != null) {
            if (this.predeclarePrefixPrefs) {
                this.usePrefixPreferences(true);
                this.setEmptyPrefixNS(this.defaultNS);
            } else {
                this.usePrefixPreferences(false);
            }
        }
    }

    public String toQName(Name name, boolean bl) {
        Namespace namespace = name.namespace;
        String string = name.localPart;
        if (bl) {
            if (namespace == Namespace.NONE) {
                return string;
            }
            this.probe.namespace = namespace;
            NamespaceEntry namespaceEntry = this.inScopeSet.get(this.probe);
            if (namespaceEntry == null) {
                namespaceEntry = this.declarePrefix(namespace);
                this.pushNamespace(namespaceEntry);
            }
            return QNameHelper.qName(namespaceEntry.prefix, string);
        }
        if (namespace == Namespace.NONE) {
            this.setEmptyPrefixNS(Namespace.NONE);
            return string;
        }
        if (namespace == this.defaultNS) {
            this.setEmptyPrefixNS(this.defaultNS);
            return string;
        }
        if (this.favorInteroperability) {
            if (namespace == Namespace.MATHML) {
                this.setEmptyPrefixNS(Namespace.MATHML);
                return string;
            }
            if (namespace == Namespace.SVG) {
                this.setEmptyPrefixNS(Namespace.SVG);
                return string;
            }
        }
        this.probe.namespace = namespace;
        NamespaceEntry namespaceEntry = this.inScopeSet.get(this.probe);
        if (namespaceEntry == null) {
            namespaceEntry = this.declarePrefix(namespace);
            this.pushNamespace(namespaceEntry);
        }
        return QNameHelper.qName(namespaceEntry.prefix, string);
    }

    public List<String> listFrame() {
        NamespaceEntry namespaceEntry;
        this.xmlnsDeclList.clear();
        Namespace namespace = this.emptyPrefixNSStackSize >= 2 ? this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 2] : Namespace.NONE;
        Namespace namespace2 = this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 1];
        if (namespace2 != namespace) {
            this.xmlnsDeclList.add("xmlns");
            this.xmlnsDeclList.add(namespace2.uri);
        }
        int n = this.inScopeStackSize - 1;
        while ((namespaceEntry = this.inScopeStack[n]) != null) {
            this.xmlnsDeclList.add("xmlns:" + namespaceEntry.prefix);
            this.xmlnsDeclList.add(namespaceEntry.namespace.uri);
            --n;
        }
        return this.xmlnsDeclList;
    }

    public void popFrame() {
        NamespaceEntry namespaceEntry;
        --this.emptyPrefixNSStackSize;
        int n = this.inScopeStackSize - 1;
        while ((namespaceEntry = this.inScopeStack[n]) != null) {
            this.inScopeSet.remove(namespaceEntry);
            --n;
        }
        this.inScopeStackSize = n;
    }

    private void dupEmptyPrefixNS() {
        Object object;
        if (this.emptyPrefixNSStackSize >= this.emptyPrefixNSStack.length) {
            object = new Namespace[Math.max(10, 2 * this.emptyPrefixNSStack.length)];
            System.arraycopy(this.emptyPrefixNSStack, 0, object, 0, this.emptyPrefixNSStack.length);
            this.emptyPrefixNSStack = object;
        }
        object = this.emptyPrefixNSStackSize > 0 ? this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 1] : Namespace.NONE;
        this.emptyPrefixNSStack[this.emptyPrefixNSStackSize++] = object;
    }

    private void pushNamespace(NamespaceEntry namespaceEntry) {
        if (this.inScopeStackSize >= this.inScopeStack.length) {
            NamespaceEntry[] namespaceEntryArray = new NamespaceEntry[Math.max(10, 2 * this.inScopeStack.length)];
            System.arraycopy(this.inScopeStack, 0, namespaceEntryArray, 0, this.inScopeStack.length);
            this.inScopeStack = namespaceEntryArray;
        }
        this.inScopeStack[this.inScopeStackSize++] = namespaceEntry;
        if (namespaceEntry != null) {
            this.inScopeSet.put(namespaceEntry, namespaceEntry);
        }
    }

    private void usePrefixPreferences(boolean bl) {
        for (PrefixEntry prefixEntry : this.prefixPreferences) {
            this.prefixesInUse.put(prefixEntry.prefix, prefixEntry.namespace);
            NamespaceEntry namespaceEntry = new NamespaceEntry(prefixEntry.namespace, prefixEntry.prefix);
            this.namespacePrefixes.put(namespaceEntry, namespaceEntry);
            if (!bl) continue;
            this.pushNamespace(namespaceEntry);
        }
    }

    private void setEmptyPrefixNS(Namespace namespace) {
        this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 1] = namespace;
    }

    private NamespaceEntry declarePrefix(Namespace namespace) {
        this.probe.namespace = namespace;
        NamespaceEntry namespaceEntry = this.namespacePrefixes.get(this.probe);
        if (namespaceEntry == null) {
            Object object = namespace.getUsualPrefix();
            if (object == null) {
                object = "ns";
            }
            int n = 2;
            if (this.prefixesInUse.containsKey(object)) {
                while (this.prefixesInUse.containsKey(object = "ns" + n++)) {
                }
            }
            this.prefixesInUse.put((String)object, namespace);
            namespaceEntry = new NamespaceEntry(namespace, (String)object);
            this.namespacePrefixes.put(namespaceEntry, namespaceEntry);
        }
        return namespaceEntry;
    }

    private static final String qName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(':');
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static final class NamespaceEntry {
        public Namespace namespace;
        public String prefix;

        public NamespaceEntry(Namespace namespace, String string) {
            this.namespace = namespace;
            this.prefix = string;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof NamespaceEntry)) {
                return false;
            }
            return this.namespace == ((NamespaceEntry)object).namespace;
        }

        public int hashCode() {
            return System.identityHashCode(this.namespace);
        }
    }
}

