/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.thaiopensource.relaxng.impl.RngProperty;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.xmlmind.util.ArrayUtil;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.ElementField;
import com.xmlmind.xml.rng.validate.IdCollector;
import com.xmlmind.xml.rng.validate.IdFinder;
import com.xmlmind.xml.rng.validate.NameClassBase;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.SAXTraversal;
import com.xmlmind.xml.rng.validate.SAXTraversalException;
import com.xmlmind.xml.rng.validate.SingleNameClass;
import com.xmlmind.xml.rng.validate.Translator;
import com.xmlmind.xml.rng.validate.TranslatorException;
import com.xmlmind.xml.validate.AttributeDefaultValue;
import com.xmlmind.xml.validate.AttributeUtil;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.DiagnosticImpl;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.IdEntry;
import com.xmlmind.xml.validate.IdRefItem;
import com.xmlmind.xml.validate.SchemaKind;
import com.xmlmind.xml.validate.Structure;
import com.xmlmind.xml.validate.SubDocumentType;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SubDocumentTypeImpl
implements SubDocumentType,
ErrorHandler {
    private Schema schema;
    private URL[] schemaURLs;
    private Validator validator;
    private SAXTraversal traversal;
    private ArrayList<DiagnosticImpl> errors;
    private Builder builder;
    private ElementField startField;
    private PrefixEntry[] declaredPrefixes;
    private Namespace[] targetNamespaces;
    private ArrayList<Element> ancestorList = new ArrayList();
    private Structure structure = new Structure();
    private Node[] nodes1 = new Node[1];
    private static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
    private static Entry[] entries = new Entry[]{new Entry("missing_id", Diagnostic.Severity.INVALID_REFERENCE, "BROKEN_IDREF"), new Entry("duplicate_id", Diagnostic.Severity.INVALID_REFERENCE, "DUPLICATE_ID"), new Entry("first_id", Diagnostic.Severity.INVALID_REFERENCE, "ORIGINAL_ID"), new Entry("bad_attribute_value", Diagnostic.Severity.INVALID_DATA, "BAD_ATTRIBUTE_NAME"), new Entry("string_not_allowed", Diagnostic.Severity.INVALID_DATA, null), new Entry("id_no_tokens", Diagnostic.Severity.INVALID_DATA, null), new Entry("id_multiple_tokens", Diagnostic.Severity.INVALID_DATA, null), new Entry("idref_no_tokens", Diagnostic.Severity.INVALID_DATA, null), new Entry("idref_multiple_tokens", Diagnostic.Severity.INVALID_DATA, null), new Entry("idrefs_no_tokens", Diagnostic.Severity.INVALID_DATA, null)};
    private static boolean initialized = false;

    public SubDocumentTypeImpl(Schema schema, URL uRL) throws TranslatorException {
        this.schema = schema;
        this.schemaURLs = null;
        if (uRL != null) {
            this.schemaURLs = new URL[]{uRL};
        }
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, (ErrorHandler)this);
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        this.validator = schema.createValidator(propertyMapBuilder.toPropertyMap());
        this.traversal = new SAXTraversal();
        this.traversal.setContentHandler(this.validator.getContentHandler());
        this.errors = new ArrayList();
        this.builder = new Builder();
        Translator translator = new Translator();
        Pattern pattern = translator.translate(schema, this.builder);
        this.startField = new ElementField(new SingleNameClass(Name.get("__start__")), pattern, this.builder);
        this.declaredPrefixes = translator.getDeclaredPrefixes();
        this.targetNamespaces = null;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ElementField getStartField() {
        return this.startField;
    }

    @Override
    public SchemaKind getSchemaKind() {
        return SchemaKind.RNG;
    }

    @Override
    public Namespace[] getTargetNamespaces() {
        if (this.targetNamespaces == null) {
            ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
            ElementField[] elementFieldArray = this.startField.childElementFields;
            for (int i = 0; i < elementFieldArray.length; ++i) {
                Namespace namespace;
                ElementField elementField = elementFieldArray[i];
                Name name = elementField.getFieldName();
                if (name == null || arrayList.contains(namespace = name.namespace)) continue;
                arrayList.add(namespace);
            }
            this.targetNamespaces = new Namespace[arrayList.size()];
            arrayList.toArray(this.targetNamespaces);
        }
        return this.targetNamespaces;
    }

    @Override
    public URL[] getSchemaURLs() {
        return this.schemaURLs;
    }

    @Override
    public PrefixEntry[] getSchemaDeclaredPrefixes() {
        return this.declaredPrefixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Diagnostic[] checkDocument(Element element) {
        this.errors.clear();
        try {
            this.traversal.traverse(element, null);
        }
        catch (SAXTraversalException sAXTraversalException) {
            Element element2 = this.traversal.getElementAt(sAXTraversalException.getLineNumber());
            if (element2 != null) {
                this.errors.add(new DiagnosticImpl(element2, sAXTraversalException.getMessage(), Diagnostic.Severity.SEMANTIC_ERROR));
            }
        }
        catch (SAXException sAXException) {
        }
        finally {
            this.validator.reset();
        }
        Diagnostic[] diagnosticArray = new Diagnostic[this.errors.size()];
        this.errors.toArray(diagnosticArray);
        return diagnosticArray;
    }

    @Override
    public Name[] getRootElementNames() {
        ElementField[] elementFieldArray = this.startField.childElementFields;
        int n = elementFieldArray.length;
        Name[] nameArray = new Name[n];
        n = 0;
        for (ElementField elementField : elementFieldArray) {
            NameClassBase nameClassBase = elementField.nameClass;
            if (!(nameClassBase instanceof SingleNameClass)) continue;
            nameArray[n++] = ((SingleNameClass)nameClassBase).name;
        }
        if (n != nameArray.length) {
            nameArray = ArrayUtil.trimToSize(nameArray, n);
        }
        return nameArray;
    }

    @Override
    public ElementType[] getElementType(Name name) {
        IdentityHashMap<ElementField, ElementField> identityHashMap = new IdentityHashMap<ElementField, ElementField>();
        IdentityHashMap<ElementField, ElementField> identityHashMap2 = new IdentityHashMap<ElementField, ElementField>();
        SubDocumentTypeImpl.doGetElementType(name, this.startField, identityHashMap, identityHashMap2);
        int n = identityHashMap2.size();
        if (n == 0) {
            return null;
        }
        ElementType[] elementTypeArray = new ElementType[n];
        identityHashMap2.values().toArray(elementTypeArray);
        return elementTypeArray;
    }

    private static final void doGetElementType(Name name, ElementField elementField, Map<ElementField, ElementField> map, Map<ElementField, ElementField> map2) {
        ElementField[] elementFieldArray;
        if (map.containsKey(elementField)) {
            return;
        }
        map.put(elementField, elementField);
        if (elementField.nameClass.containsName(name)) {
            map2.put(elementField, elementField);
        }
        for (ElementField elementField2 : elementFieldArray = elementField.childElementFields) {
            SubDocumentTypeImpl.doGetElementType(name, elementField2, map, map2);
        }
    }

    @Override
    public ElementType getElementType(Element element, Element element2) {
        Element element3;
        this.ancestorList.clear();
        for (element3 = element; element3 != null; element3 = element3.getParentElement()) {
            this.ancestorList.add(element3);
            if (element3 == element2) break;
        }
        int n = this.ancestorList.size() - 1;
        element3 = this.ancestorList.get(n);
        this.nodes1[0] = element3;
        if (!this.startField.getStructure(NO_ATTRIBUTES, 0, this.nodes1, 1, false, this.structure)) {
            return null;
        }
        ElementField elementField = (ElementField)this.structure.childNodeItems[0];
        for (int i = n; i >= 1; --i) {
            if (!elementField.getStructure(element3, true, this.structure)) {
                return null;
            }
            Element element4 = this.ancestorList.get(i - 1);
            elementField = (ElementField)this.structure.childNodeItems[element3.indexOfChild(element4)];
            element3 = element4;
        }
        return elementField;
    }

    @Override
    public String getElementAttribute(Element element, Element element2, Name name, AttributeDefaultValue attributeDefaultValue) {
        Data data;
        ElementType elementType;
        String string = AttributeUtil.getAttribute(element, name, attributeDefaultValue);
        if (string == null && (elementType = this.getElementType(element, element2)) != null && (data = elementType.getAttributeDefaultValue(name)) != null) {
            string = data.formatData(element);
        }
        return string;
    }

    @Override
    public String lookupElementAttribute(Element element, Element element2, Name name, AttributeDefaultValue attributeDefaultValue) {
        String string;
        Element element3;
        String string2 = AttributeUtil.getAttribute(element, name, attributeDefaultValue);
        if (string2 != null) {
            return string2;
        }
        this.ancestorList.clear();
        for (element3 = element; element3 != null; element3 = element3.getParentElement()) {
            this.ancestorList.add(element3);
            if (element3 == element2) break;
        }
        int n = this.ancestorList.size() - 1;
        element3 = this.ancestorList.get(n);
        this.nodes1[0] = element3;
        ElementField elementField = this.startField.getStructure(NO_ATTRIBUTES, 0, this.nodes1, 1, false, this.structure) ? (ElementField)this.structure.childNodeItems[0] : null;
        for (int i = n; i >= 1; --i) {
            string = SubDocumentTypeImpl.getAttributeDefaulted(element3, name, attributeDefaultValue, elementField);
            if (string != null) {
                string2 = string;
            }
            Element element4 = this.ancestorList.get(i - 1);
            if (elementField != null) {
                elementField = elementField.getStructure(element3, true, this.structure) ? (ElementField)this.structure.childNodeItems[element3.indexOfChild(element4)] : null;
            }
            element3 = element4;
        }
        string = SubDocumentTypeImpl.getAttributeDefaulted(element3, name, attributeDefaultValue, elementField);
        if (string != null) {
            string2 = string;
        }
        return string2;
    }

    private static final String getAttributeDefaulted(Element element, Name name, AttributeDefaultValue attributeDefaultValue, ElementType elementType) {
        Data data;
        String string = AttributeUtil.getAttribute(element, name, attributeDefaultValue);
        if (string == null && elementType != null && (data = elementType.getAttributeDefaultValue(name)) != null) {
            string = data.formatData(element);
        }
        return string;
    }

    @Override
    public Element[] findElementById(Element element, Element element2, String string, boolean bl) {
        return new IdFinder(this).find(element, element2, string);
    }

    @Override
    public void collectIds(Element element, Element element2, Map<String, IdEntry> map) {
        if (!map.isEmpty()) {
            map.clear();
        }
        new IdCollector(this).collect(element, element2, map, null);
    }

    @Override
    public void collectIdRefs(Element element, Element element2, List<IdRefItem> list) {
        if (!list.isEmpty()) {
            list.clear();
        }
        new IdCollector(this).collect(element, element2, null, list);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException);
        throw sAXParseException;
    }

    private void addError(SAXParseException sAXParseException) {
        Element element = this.traversal.getElementAt(sAXParseException.getLineNumber());
        if (element != null) {
            String string = sAXParseException.getMessage();
            String[] stringArray = new String[2];
            Diagnostic.Severity severity = SubDocumentTypeImpl.findSeverity(string, element, stringArray);
            Object[] objectArray = null;
            if (stringArray[1] != null) {
                objectArray = new Object[]{stringArray[1]};
            }
            this.errors.add(new DiagnosticImpl(element, string, severity, stringArray[0], objectArray));
        }
    }

    private static Diagnostic.Severity findSeverity(String string, Element element, String[] stringArray) {
        Object object;
        if (!initialized) {
            initialized = true;
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("com.thaiopensource.relaxng.impl.resources.Messages");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle != null) {
                Object object2;
                Object object3;
                int n;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (n = 0; n < entries.length; ++n) {
                    object3 = entries[n];
                    hashMap.put(((Entry)object3).id, object3);
                }
                n = 61166;
                object3 = Character.valueOf((char)n);
                Object[] objectArray = new Object[]{object3, object3, object3, object3, object3, object3, object3, object3, object3, object3};
                ArrayList<String> arrayList = new ArrayList<String>();
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    String string2 = resourceBundle.getString((String)object);
                    object2 = MessageFormat.format(string2, objectArray);
                    if (((String)object2).length() == 0) {
                        object2 = null;
                    }
                    if (object2 == null) continue;
                    object2 = ((String)object2).intern();
                    arrayList.add((String)object2);
                    Entry entry = (Entry)hashMap.get(object);
                    if (entry == null) continue;
                    entry.format = object2;
                }
                hashMap = null;
                object = new String[arrayList.size()];
                arrayList.toArray((T[])object);
                arrayList = null;
                block6: for (int i = 0; i < entries.length; ++i) {
                    String string3;
                    int n2;
                    boolean bl;
                    String string4;
                    int n3;
                    object2 = entries[i];
                    if (((Entry)object2).format == null) continue;
                    int n4 = ((Entry)object2).format.length();
                    for (n3 = 1; n3 <= n4 && (string4 = ((Entry)object2).format.substring(0, n3)).indexOf(n) < 0; ++n3) {
                        bl = false;
                        for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                            string3 = object[n2];
                            if (string3 == ((Entry)object2).format || !string3.startsWith(string4)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        ((Entry)object2).prefix = string4;
                        break;
                    }
                    if (((Entry)object2).prefix != null) continue;
                    for (n3 = n4 - 1; n3 >= 0 && (string4 = ((Entry)object2).format.substring(n3)).indexOf(n) < 0; --n3) {
                        bl = false;
                        for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                            string3 = object[n2];
                            if (string3 == ((Entry)object2).format || !string3.endsWith(string4)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        ((Entry)object2).suffix = string4;
                        continue block6;
                    }
                }
            }
        }
        for (Entry entry : entries) {
            if ((entry.prefix == null || !string.startsWith(entry.prefix)) && (entry.suffix == null || !string.endsWith(entry.suffix))) continue;
            if (entry.detailId != null && stringArray != null) {
                int n;
                stringArray[0] = entry.detailId;
                stringArray[1] = null;
                int n5 = string.indexOf(34);
                if (n5 >= 0 && (n = string.indexOf(34, n5 + 1)) > n5 + 1) {
                    int n6;
                    stringArray[1] = string.substring(n5 + 1, n);
                    int n7 = string.indexOf(" from namespace \"", n + 1);
                    if (n7 == n + 1 && (n6 = string.indexOf(34, n7 + 17)) > n7 + 17) {
                        object = string.substring(n7 + 17, n6);
                        try {
                            Name name = Name.get((String)object, stringArray[1]);
                            stringArray[1] = name.format(true, element);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            return entry.severity;
        }
        return Diagnostic.Severity.INVALID_STRUCTURE;
    }

    private static final class Entry {
        public final String id;
        public final Diagnostic.Severity severity;
        public final String detailId;
        public String format;
        public String prefix;
        public String suffix;

        public Entry(String string, Diagnostic.Severity severity, String string2) {
            this.id = string;
            this.severity = severity;
            this.detailId = string2;
        }
    }
}

