/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.rng.validate.NameClassBase;
import com.xmlmind.xml.rng.validate.NameClassVisitor;
import com.xmlmind.xml.rng.validate.SingleNameClass;

final class OverlapDetector
implements NameClassVisitor {
    private final NameClassBase nc1;
    private final NameClassBase nc2;
    private boolean overlaps = false;
    private static final String ILLEGAL = "\u0000";

    public static boolean overlap(NameClassBase nameClassBase, NameClassBase nameClassBase2) {
        if (nameClassBase2 instanceof SingleNameClass) {
            return nameClassBase.containsName(((SingleNameClass)nameClassBase2).name);
        }
        if (nameClassBase instanceof SingleNameClass) {
            return nameClassBase2.containsName(((SingleNameClass)nameClassBase).name);
        }
        return new OverlapDetector((NameClassBase)nameClassBase, (NameClassBase)nameClassBase2).overlaps;
    }

    private OverlapDetector(NameClassBase nameClassBase, NameClassBase nameClassBase2) {
        this.nc1 = nameClassBase;
        this.nc2 = nameClassBase2;
        nameClassBase.accept(this);
        nameClassBase2.accept(this);
    }

    @Override
    public void visitName(Name name) {
        this.probe(name);
    }

    private void probe(Name name) {
        if (this.nc1.containsName(name) && this.nc2.containsName(name)) {
            this.overlaps = true;
        }
    }

    @Override
    public void visitAnyName() {
        this.probe(Name.get(ILLEGAL, ILLEGAL));
    }

    @Override
    public void visitAnyNameExcept(NameClassBase nameClassBase) {
        this.probe(Name.get(ILLEGAL, ILLEGAL));
        nameClassBase.accept(this);
    }

    @Override
    public void visitNsName(Namespace namespace) {
        this.probe(Name.get(namespace, ILLEGAL));
    }

    @Override
    public void visitNsNameExcept(Namespace namespace, NameClassBase nameClassBase) {
        this.probe(Name.get(namespace, ILLEGAL));
        nameClassBase.accept(this);
    }

    @Override
    public void visitChoice(NameClassBase nameClassBase, NameClassBase nameClassBase2) {
        nameClassBase.accept(this);
        nameClassBase2.accept(this);
    }
}

