/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.rng.validate.ChoicePattern;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.OneOrMorePattern;
import com.xmlmind.xml.rng.validate.Pattern;

final class Occurrence {
    public Pattern pattern;
    public Op occurrence;
    private static Occurrence which = new Occurrence();

    public Occurrence(Pattern pattern, Op op) {
        this.pattern = pattern;
        this.occurrence = op;
    }

    public Occurrence() {
    }

    public static Occurrence which(Pattern pattern) {
        Occurrence.get(pattern, which);
        return which;
    }

    public static void get(Pattern pattern, Occurrence occurrence) {
        Occurrence.doGet(pattern, occurrence);
        if (occurrence.pattern == pattern) {
            return;
        }
        Op op = occurrence.occurrence;
        while (true) {
            Pattern pattern2 = occurrence.pattern;
            Occurrence.doGet(pattern2, occurrence);
            block0 : switch (occurrence.occurrence) {
                case ONE: {
                    occurrence.pattern = pattern2;
                    occurrence.occurrence = op;
                    return;
                }
                case OPTIONAL: {
                    switch (op) {
                        case ONE: {
                            op = Op.OPTIONAL;
                            break block0;
                        }
                        case OPTIONAL: {
                            op = Op.OPTIONAL;
                            break block0;
                        }
                        case ZERO_OR_MORE: {
                            op = Op.ZERO_OR_MORE;
                            break block0;
                        }
                        case ONE_OR_MORE: {
                            op = Op.ZERO_OR_MORE;
                        }
                    }
                    break;
                }
                case ZERO_OR_MORE: {
                    switch (op) {
                        case ONE: {
                            op = Op.ZERO_OR_MORE;
                            break block0;
                        }
                        case OPTIONAL: {
                            op = Op.ZERO_OR_MORE;
                            break block0;
                        }
                        case ZERO_OR_MORE: {
                            op = Op.ZERO_OR_MORE;
                            break block0;
                        }
                        case ONE_OR_MORE: {
                            op = Op.ZERO_OR_MORE;
                        }
                    }
                    break;
                }
                case ONE_OR_MORE: {
                    switch (op) {
                        case ONE: {
                            op = Op.ONE_OR_MORE;
                            break block0;
                        }
                        case OPTIONAL: {
                            op = Op.ZERO_OR_MORE;
                            break block0;
                        }
                        case ZERO_OR_MORE: {
                            op = Op.ZERO_OR_MORE;
                            break block0;
                        }
                        case ONE_OR_MORE: {
                            op = Op.ONE_OR_MORE;
                        }
                    }
                }
            }
        }
    }

    private static void doGet(Pattern pattern, Occurrence occurrence) {
        occurrence.pattern = pattern;
        occurrence.occurrence = Op.ONE;
        if (pattern instanceof OneOrMorePattern) {
            occurrence.pattern = ((OneOrMorePattern)pattern).pattern;
            occurrence.occurrence = Op.ONE_OR_MORE;
        } else if (pattern instanceof ChoicePattern) {
            ChoicePattern choicePattern = (ChoicePattern)pattern;
            pattern = choicePattern.pattern1 == EmptyPattern.INSTANCE ? choicePattern.pattern2 : (choicePattern.pattern2 == EmptyPattern.INSTANCE ? choicePattern.pattern1 : null);
            if (pattern != null) {
                if (pattern instanceof OneOrMorePattern) {
                    occurrence.pattern = ((OneOrMorePattern)pattern).pattern;
                    occurrence.occurrence = Op.ZERO_OR_MORE;
                } else {
                    occurrence.pattern = pattern;
                    occurrence.occurrence = Op.OPTIONAL;
                }
            }
        }
    }

    public static enum Op {
        ONE,
        OPTIONAL,
        ZERO_OR_MORE,
        ONE_OR_MORE;


        public String toString() {
            switch (this) {
                case OPTIONAL: {
                    return "?";
                }
                case ZERO_OR_MORE: {
                    return "*";
                }
                case ONE_OR_MORE: {
                    return "+";
                }
            }
            return "";
        }
    }
}

