/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.rng.validate.NameClassBase;
import com.xmlmind.xml.rng.validate.NameClassVisitor;
import com.xmlmind.xml.rng.validate.NsNameClass;

final class NsNameExceptNameClass
extends NameClassBase {
    public final Namespace namespace;
    public final NameClassBase nameClass;

    public NsNameExceptNameClass(Namespace namespace, NameClassBase nameClassBase) {
        this.namespace = namespace;
        this.nameClass = nameClassBase;
    }

    public int hashCode() {
        return System.identityHashCode(this.namespace) ^ this.nameClass.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NsNameExceptNameClass)) {
            return false;
        }
        NsNameExceptNameClass nsNameExceptNameClass = (NsNameExceptNameClass)object;
        return this.namespace == nsNameExceptNameClass.namespace && this.nameClass.equals(nsNameExceptNameClass.nameClass);
    }

    @Override
    public void toLabel(boolean bl, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        NsNameClass.toLabel(this.namespace, bl, namespaceToPrefixes, stringBuilder);
        stringBuilder.append(" - ");
        this.nameClass.toLabel(bl, namespaceToPrefixes, stringBuilder);
        stringBuilder.append(')');
    }

    @Override
    public void accept(NameClassVisitor nameClassVisitor) {
        nameClassVisitor.visitNsNameExcept(this.namespace, this.nameClass);
    }

    @Override
    public Name getInstance() {
        Name name = Name.get(this.namespace, PRIVATE_LOCAL_PART);
        if (this.nameClass.containsName(name)) {
            return null;
        }
        return name;
    }

    @Override
    public boolean containsName(Name name) {
        return this.namespace == name.namespace && !this.nameClass.containsName(name);
    }
}

