/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.ChoicePattern;
import com.xmlmind.xml.rng.validate.ComplexDataType;
import com.xmlmind.xml.rng.validate.DataPattern;
import com.xmlmind.xml.rng.validate.ListPattern;
import com.xmlmind.xml.rng.validate.NameClassBase;
import com.xmlmind.xml.rng.validate.Occurrence;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternList;
import com.xmlmind.xml.rng.validate.SingleNameClass;
import com.xmlmind.xml.rng.validate.ValuePattern;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.NameClass;
import com.xmlmind.xml.wxs.datatype.InvalidTypeException;
import com.xmlmind.xml.wxs.datatype.ListType;
import com.xmlmind.xml.wxs.datatype.Restriction;
import com.xmlmind.xml.wxs.datatype.Value;

abstract class FieldBase
extends Pattern
implements Field {
    public NameClassBase nameClass;
    public Pattern pattern;
    public Builder builder;
    public DataType dataType;
    public Data fixedValue;

    protected FieldBase(NameClassBase nameClassBase, Pattern pattern, Builder builder) {
        this.initialize(nameClassBase, pattern, builder);
    }

    protected FieldBase() {
    }

    protected void initialize(NameClassBase nameClassBase, Pattern pattern, Builder builder) {
        this.nullable = false;
        this.nameClass = nameClassBase;
        this.pattern = pattern;
        this.builder = builder;
    }

    protected abstract void prepare();

    protected void initDataType() {
        Object object;
        Object object2;
        Pattern pattern = this.pattern.findDataPattern();
        if (pattern == null) {
            return;
        }
        this.dataType = null;
        this.fixedValue = null;
        Pattern pattern2 = pattern;
        int n = 1;
        int n2 = 1;
        if (pattern2 instanceof ListPattern) {
            object2 = (ListPattern)pattern2;
            object = Occurrence.which(((ListPattern)object2).pattern);
            pattern2 = ((Occurrence)object).pattern;
            switch (((Occurrence)object).occurrence) {
                case OPTIONAL: {
                    n = 0;
                    n2 = 1;
                    break;
                }
                case ZERO_OR_MORE: {
                    n = 0;
                    n2 = Integer.MAX_VALUE;
                    break;
                }
                case ONE_OR_MORE: {
                    n = 1;
                    n2 = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    n = 1;
                    n2 = 1;
                }
            }
        }
        if (pattern2 instanceof DataPattern) {
            this.dataType = ((DataPattern)pattern2).dataType;
        } else if (pattern2 instanceof ValuePattern) {
            object2 = (ValuePattern)pattern2;
            object = new Restriction((com.xmlmind.xml.wxs.datatype.DataType)((ValuePattern)object2).dataType);
            try {
                ((Restriction)object).setEnumeration(new Value[]{(Value)((ValuePattern)object2).value});
                this.dataType = ((Restriction)object).derive();
            }
            catch (InvalidTypeException invalidTypeException) {
                // empty catch block
            }
            if (this.dataType != null) {
                this.fixedValue = ((ValuePattern)object2).value;
            }
        } else if (pattern2 instanceof ChoicePattern) {
            object2 = new PatternList();
            ((ChoicePattern)pattern2).getChoices((PatternList)object2);
            object = null;
            for (int i = 0; i < ((PatternList)object2).size; ++i) {
                if (!(((PatternList)object2).list[i] instanceof ValuePattern)) {
                    object = null;
                    break;
                }
                ValuePattern valuePattern = (ValuePattern)((PatternList)object2).list[i];
                if (object == null) {
                    object = valuePattern.dataType;
                    continue;
                }
                if (valuePattern.dataType.equals(object)) continue;
                object = null;
                break;
            }
            if (object != null) {
                Value[] valueArray = new Value[((PatternList)object2).size];
                for (int i = 0; i < ((PatternList)object2).size; ++i) {
                    ValuePattern valuePattern = (ValuePattern)((PatternList)object2).list[i];
                    valueArray[i] = (Value)valuePattern.value;
                }
                Restriction restriction = new Restriction((com.xmlmind.xml.wxs.datatype.DataType)object);
                try {
                    restriction.setEnumeration(valueArray);
                    this.dataType = restriction.derive();
                }
                catch (InvalidTypeException invalidTypeException) {
                    // empty catch block
                }
            }
        }
        if (this.dataType != null && (n != 1 || n2 != 1)) {
            this.fixedValue = null;
            this.dataType = new ListType((com.xmlmind.xml.wxs.datatype.DataType)this.dataType);
            if (n != 0 || n2 != Integer.MAX_VALUE) {
                object2 = new Restriction((com.xmlmind.xml.wxs.datatype.DataType)this.dataType);
                try {
                    if (n != 0) {
                        ((Restriction)object2).setMinLength(n, false);
                    }
                    if (n2 != Integer.MAX_VALUE) {
                        ((Restriction)object2).setMaxLength(n2, false);
                    }
                    this.dataType = ((Restriction)object2).derive();
                }
                catch (InvalidTypeException invalidTypeException) {
                    // empty catch block
                }
            }
        }
        if (this.dataType == null) {
            this.dataType = new ComplexDataType(pattern, this.builder);
        }
    }

    @Override
    public Name getFieldName() {
        return this.nameClass instanceof SingleNameClass ? ((SingleNameClass)this.nameClass).name : null;
    }

    @Override
    public NameClass getFieldNameClass() {
        return this.nameClass instanceof SingleNameClass ? null : this.nameClass;
    }

    @Override
    public String getFieldLabel(boolean bl, NamespaceToPrefixes namespaceToPrefixes) {
        if (this.nameClass instanceof SingleNameClass) {
            return ((SingleNameClass)this.nameClass).name.format(bl, namespaceToPrefixes);
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.nameClass.toLabel(bl, namespaceToPrefixes, stringBuilder);
        return XMLText.collapseWhiteSpace(stringBuilder.toString());
    }
}

