/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.rng.validate.Msg;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.Pattern;
import com.xmlmind.xml.wxs.datatype.Value;
import java.io.Serializable;

final class DocGenUtil {
    DocGenUtil() {
    }

    public static final void appendDataType(DataType dataType, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        int n;
        Serializable[] serializableArray;
        DataType dataType2 = dataType.getRootType();
        XMLText.escapeXML(dataType.getDataTypeLabel(namespaceToPrefixes), stringBuilder);
        if (DocGenUtil.hasFacet(dataType, dataType2, 1)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.length"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getLength()));
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 2)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.minLength"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getMinLength()));
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 4)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.maxLength"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getMaxLength()));
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 8)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.pattern"), stringBuilder);
            stringBuilder.append(": ");
            serializableArray = dataType.getPattern();
            for (n = 0; n < serializableArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"');
                DocGenUtil.appendLongLine(((Pattern)serializableArray[n]).toString(), stringBuilder);
                stringBuilder.append('\"');
            }
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 16)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.enumeration"), stringBuilder);
            stringBuilder.append(": ");
            serializableArray = dataType.getEnumeration();
            for (n = 0; n < serializableArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"');
                DocGenUtil.appendLongLine(((Value)serializableArray[n]).toString(namespaceToPrefixes), stringBuilder);
                stringBuilder.append('\"');
            }
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 32)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.whiteSpace"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getWhiteSpace().toString(), stringBuilder);
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 64)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.maxInclusive"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getMaxInclusive().toString(namespaceToPrefixes), stringBuilder);
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 128)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.maxExclusive"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getMaxExclusive().toString(namespaceToPrefixes), stringBuilder);
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 256)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.minExclusive"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getMinExclusive().toString(namespaceToPrefixes), stringBuilder);
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 512)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.minInclusive"), stringBuilder);
            stringBuilder.append(": ");
            XMLText.escapeXML(dataType.getMinInclusive().toString(namespaceToPrefixes), stringBuilder);
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 1024)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.totalDigits"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getTotalDigits()));
        }
        if (DocGenUtil.hasFacet(dataType, dataType2, 2048)) {
            stringBuilder.append("<br>\n");
            XMLText.escapeXML(Msg.msg("DGU.fractionDigits"), stringBuilder);
            stringBuilder.append(": ");
            stringBuilder.append(Integer.toString(dataType.getFractionDigits()));
        }
    }

    private static final boolean hasFacet(DataType dataType, DataType dataType2, int n) {
        return dataType.hasFacet(n) && !dataType2.hasFacet(n);
    }

    public static final void appendLongLine(String string, StringBuilder stringBuilder) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = Math.min(n2, n + 80);
            if (n > 0) {
                stringBuilder.append("<br>\n");
            }
            XMLText.escapeXML(string.substring(n, n3), stringBuilder);
            n = n3;
        }
    }
}

