/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.StringList;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.load.Msg;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.resolve.XMLCatalogs;
import java.net.MalformedURLException;
import java.net.URL;

final class XMLModel {
    public static final String PI_TARGET = "xml-model";
    public static final String XML_TYPE = "application/xml";
    public static final String DTD_TYPE = "application/xml-dtd";
    public static final String RNC_TYPE = "application/relax-ng-compact-syntax";
    public final String href;
    public final URL url;
    public final String type;
    public final Namespace schematypens;
    public final String charset;
    public final String title;
    public final String group;
    public final String phase;

    /*
     * Enabled aggressive block sorting
     */
    public static XMLModel[] parse(Document document) throws ParseException {
        XMLModel[] xMLModelArray = null;
        Node node = document.getFirstChild();
        while (node != null) {
            switch (node.getType()) {
                case PROCESSING_INSTRUCTION: {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    if (!PI_TARGET.equals(processingInstruction.getTarget())) break;
                    XMLModel xMLModel = XMLModel.parse(processingInstruction);
                    if (xMLModelArray == null) {
                        xMLModelArray = new XMLModel[]{xMLModel};
                        break;
                    }
                    xMLModelArray = ArrayUtil.append(xMLModelArray, xMLModel);
                    break;
                }
                case ELEMENT: {
                    return xMLModelArray;
                }
            }
            node = node.getNextSibling();
        }
        return xMLModelArray;
    }

    public static XMLModel parse(ProcessingInstruction processingInstruction) throws ParseException {
        String string = null;
        URL uRL = null;
        String string2 = XML_TYPE;
        Namespace namespace = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String[] stringArray = processingInstruction.getPseudoAttributes();
        int n = stringArray.length;
        for (int i = 0; i < n; i += 2) {
            String string7 = stringArray[i];
            String string8 = stringArray[i + 1].trim();
            if (string8.length() == 0) continue;
            string8 = XMLText.unescapeXML(string8);
            if ("href".equals(string7)) {
                string = string8;
                try {
                    uRL = XMLCatalogs.resolveURI(string, processingInstruction.getBaseURL());
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ParseException(Msg.msg("invalidPseudoAttribute", string8, "href"), processingInstruction);
                }
            }
            if ("type".equals(string7)) {
                string2 = string8;
                continue;
            }
            if ("schematypens".equals(string7)) {
                namespace = Namespace.get(string8);
                continue;
            }
            if ("charset".equals(string7)) {
                string3 = string8;
                if (StringList.containsIgnoreCase(SystemUtil.listEncodings(), string3)) continue;
                throw new ParseException(Msg.msg("invalidPseudoAttribute", string8, "charset"), processingInstruction);
            }
            if ("title".equals(string7)) {
                string4 = string8;
                continue;
            }
            if ("group".equals(string7)) {
                string5 = string8;
                continue;
            }
            if (!"phase".equals(string7)) continue;
            string6 = string8;
        }
        if (uRL == null) {
            throw new ParseException(Msg.msg("missingPseudoAttribute", "href"), processingInstruction);
        }
        return new XMLModel(string, uRL, string2, namespace, string3, string4, string5, string6);
    }

    public XMLModel(String string, URL uRL, String string2, Namespace namespace, String string3, String string4, String string5, String string6) {
        this.href = string;
        this.url = uRL;
        this.type = string2;
        this.schematypens = namespace;
        this.charset = string3;
        this.title = string4;
        this.group = string5;
        this.phase = string6;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?");
        stringBuilder.append(PI_TARGET);
        if (this.href != null) {
            stringBuilder.append(" href=");
            XMLText.quoteXML(this.href, stringBuilder);
        }
        if (this.type != null) {
            stringBuilder.append(" type=");
            XMLText.quoteXML(this.type, stringBuilder);
        }
        if (this.schematypens != null) {
            stringBuilder.append(" schematypens=");
            XMLText.quoteXML(this.schematypens.uri, stringBuilder);
        }
        if (this.charset != null) {
            stringBuilder.append(" charset=");
            XMLText.quoteXML(this.charset, stringBuilder);
        }
        if (this.title != null) {
            stringBuilder.append(" title=");
            XMLText.quoteXML(this.title, stringBuilder);
        }
        if (this.group != null) {
            stringBuilder.append(" group=");
            XMLText.quoteXML(this.group, stringBuilder);
        }
        if (this.phase != null) {
            stringBuilder.append(" phase=");
            XMLText.quoteXML(this.phase, stringBuilder);
        }
        stringBuilder.append("?>");
        return stringBuilder.toString();
    }

    public static final class ParseException
    extends Exception {
        public final ProcessingInstruction pi;

        public ParseException(String string, ProcessingInstruction processingInstruction) {
            super(string);
            this.pi = processingInstruction;
        }
    }
}

