/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.Msg;
import java.net.URL;
import java.util.Comparator;

public final class LoadErrorImpl
implements LoadError {
    public static final LoadErrorImpl[] NO_ERRORS = new LoadErrorImpl[0];
    public final LoadError.Type type;
    public final URL url;
    public final int lineNumber;
    public final int columnNumber;
    public final Node node;
    public final String message;
    public static final CompareLoadErrors COMPARE_LOAD_ERRORS = new CompareLoadErrors();

    public LoadErrorImpl(LoadError.Type type, URL uRL, int n, int n2, String string) {
        this.type = type;
        this.url = uRL;
        this.lineNumber = n;
        this.columnNumber = n2;
        this.node = null;
        this.message = string;
    }

    public LoadErrorImpl(LoadError.Type type, Node node, String string) {
        this.type = type;
        this.url = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
        this.node = node;
        this.message = string;
    }

    @Override
    public LoadError.Type getErrorType() {
        return this.type;
    }

    @Override
    public URL getErrorLocation() {
        return this.url;
    }

    @Override
    public int getErrorLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getErrorColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public Node getNodeInError() {
        return this.node;
    }

    @Override
    public String getErrorMessage() {
        return this.message;
    }

    public static Element getElementInError(LoadError loadError) {
        Node node = loadError.getNodeInError();
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case ELEMENT: {
                return (Element)node;
            }
            case DOCUMENT: {
                return ((Document)node).getRootElement();
            }
        }
        return node.getParentElement();
    }

    public static String format(LoadError loadError, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        URL uRL = loadError.getErrorLocation();
        if (uRL != null) {
            stringBuilder.append(uRL);
            int n = loadError.getErrorLineNumber();
            int n2 = loadError.getErrorColumnNumber();
            stringBuilder.append(':');
            if (n > 0) {
                stringBuilder.append(n);
            }
            stringBuilder.append(':');
            if (n2 > 0) {
                stringBuilder.append(n2);
            }
        } else {
            Node node = loadError.getNodeInError();
            if (node != null) {
                uRL = node.getSourceURL();
                if (uRL != null) {
                    int[] nArray;
                    stringBuilder.append(uRL);
                    int n = loadError.getErrorLineNumber();
                    int n3 = loadError.getErrorColumnNumber();
                    if (n < 0 && node.getType() == Node.Type.ELEMENT && (nArray = (int[])node.getProperty(Constants.LINE_COLUMN_PROPERTY)) != null) {
                        n = nArray[0];
                        n3 = nArray[1];
                    }
                    stringBuilder.append(':');
                    if (n > 0) {
                        stringBuilder.append(n);
                    }
                    stringBuilder.append(':');
                    if (n3 > 0) {
                        stringBuilder.append(n3);
                    }
                } else {
                    stringBuilder.append(node.getXPath());
                }
            }
        }
        stringBuilder.append(':');
        if (bl) {
            String string = loadError.getErrorType() == LoadError.Type.DOCUMENT_TYPE ? Msg.msg("documentTypeWarning") : Msg.msg("inclusionWarning");
            stringBuilder.append(string);
        } else {
            String string = loadError.getErrorType() == LoadError.Type.DOCUMENT_TYPE ? Msg.msg("documentTypeError") : Msg.msg("inclusionError");
            stringBuilder.append(string);
        }
        stringBuilder.append(": ");
        stringBuilder.append(loadError.getErrorMessage());
        return stringBuilder.toString();
    }

    public static final class CompareLoadErrors
    implements Comparator<LoadError> {
        @Override
        public int compare(LoadError loadError, LoadError loadError2) {
            LoadError.Type type;
            LoadError.Type type2 = loadError.getErrorType();
            if (type2 == (type = loadError2.getErrorType())) {
                URL uRL = loadError.getErrorLocation();
                Node node = loadError.getNodeInError();
                if (uRL == null && node != null) {
                    uRL = node.getSourceURL();
                }
                URL uRL2 = loadError2.getErrorLocation();
                Node node2 = loadError2.getNodeInError();
                if (uRL2 == null && node2 != null) {
                    uRL2 = node2.getSourceURL();
                }
                if (uRL != null && uRL2 != null) {
                    if (uRL.equals(uRL2)) {
                        int[] nArray;
                        int[] nArray2;
                        int n = loadError.getErrorLineNumber();
                        int n2 = loadError.getErrorColumnNumber();
                        if (n <= 0 && node != null && node.getType() == Node.Type.ELEMENT && (nArray2 = (int[])node.getProperty(Constants.LINE_COLUMN_PROPERTY)) != null) {
                            n = nArray2[0];
                            n2 = nArray2[1];
                        }
                        int n3 = loadError2.getErrorLineNumber();
                        int n4 = loadError2.getErrorColumnNumber();
                        if (n3 <= 0 && node2 != null && node2.getType() == Node.Type.ELEMENT && (nArray = (int[])node2.getProperty(Constants.LINE_COLUMN_PROPERTY)) != null) {
                            n3 = nArray[0];
                            n4 = nArray[1];
                        }
                        if (n == n3) {
                            if (n2 == n4) {
                                return loadError.getErrorMessage().compareTo(loadError2.getErrorMessage());
                            }
                            return n2 - n4;
                        }
                        return n - n3;
                    }
                    return uRL.toExternalForm().compareTo(uRL2.toExternalForm());
                }
                if (node != null && node2 != null) {
                    String string;
                    String string2 = node.getXPath();
                    if (string2.equals(string = node2.getXPath())) {
                        return loadError.getErrorMessage().compareTo(loadError2.getErrorMessage());
                    }
                    return string2.compareTo(string);
                }
                return loadError.getErrorMessage().compareTo(loadError2.getErrorMessage());
            }
            if (type2 == LoadError.Type.DOCUMENT_TYPE) {
                return -1;
            }
            return 1;
        }
    }
}

