/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.Console;
import com.xmlmind.util.KeyValuePair;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.load.DTDAccelerator;
import com.xmlmind.xml.load.DTDSpec;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.load.DocumentTypeDetector;
import com.xmlmind.xml.load.DocumentTypeDetectorImpl;
import com.xmlmind.xml.load.DocumentTypeSpec;
import com.xmlmind.xml.load.LoadDocument;
import com.xmlmind.xml.load.StopLoadingException;
import com.xmlmind.xml.load.SubDocumentTypeSpec;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.validate.SchemaKind;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LoadDocumentStep
extends DocumentLoader {
    protected boolean twoPasses;
    protected Console console;
    protected boolean firstPass;
    public DocumentTypeSpec detectedDocTypeSpec;
    protected ArrayList<Object> userProperties;
    protected DTDSpec[] actualDTDSpec;
    protected static final Name[] SKIPPED_PROPERTY_NAMES = new Name[]{Constants.NAMESPACE_PREFIX_MAP_PROPERTY, Constants.SOURCE_URL_PROPERTY, Constants.ENTITIES_PROPERTY, Constants.XML_DECLARATION_PROPERTY};

    public LoadDocumentStep(boolean bl, int n, Console console) {
        if ((n & 4) != 0) {
            this.options |= 4;
        }
        if ((n & 2) != 0) {
            this.options |= 2;
        }
        if ((n & 1) != 0) {
            this.options |= 1;
        }
        this.twoPasses = bl;
        this.console = console;
        this.firstPass = true;
        this.detectedDocTypeSpec = null;
    }

    @Override
    protected void rootElement(Element element) {
        if (this.firstPass) {
            SubDocumentTypeSpec subDocumentTypeSpec;
            this.firstPass = false;
            DocumentTypeDetector documentTypeDetector = LoadDocument.getDocumentTypeDetector();
            if (documentTypeDetector == null) {
                documentTypeDetector = DocumentTypeDetectorImpl.INSTANCE;
            }
            this.detectedDocTypeSpec = documentTypeDetector.detectDocumentType(element, this.getDTDSpec());
            if (this.detectedDocTypeSpec != null && (subDocumentTypeSpec = this.detectedDocTypeSpec.mainDocumentTypeSpec) != null && subDocumentTypeSpec.schemaKind == SchemaKind.DTD && subDocumentTypeSpec.dtdSpec == null && subDocumentTypeSpec.dtdSystemId != null) {
                if (this.twoPasses) {
                    this.saveUserProperties(element);
                    throw new StopLoadingException();
                }
                this.detectedDocTypeSpec = null;
            }
        } else {
            SubDocumentTypeSpec subDocumentTypeSpec = new SubDocumentTypeSpec(this.getDTDSpec());
            SubDocumentTypeSpec subDocumentTypeSpec2 = this.detectedDocTypeSpec.mainDocumentTypeSpec;
            subDocumentTypeSpec.preserveSpaceElements = subDocumentTypeSpec2.preserveSpaceElements;
            subDocumentTypeSpec.xInclusionSchemes = subDocumentTypeSpec2.xInclusionSchemes;
            this.detectedDocTypeSpec = new DocumentTypeSpec(subDocumentTypeSpec, this.detectedDocTypeSpec.auxDocumentTypeSpecs, this.detectedDocTypeSpec.auxNamespaces);
            this.restoreUserProperties(element);
        }
    }

    protected void saveUserProperties(Element element) {
        Document document = element.getDocument();
        if (document != null) {
            Iterator<KeyValuePair<Name, Object>> iterator = document.getProperties();
            while (iterator.hasNext()) {
                KeyValuePair<Name, Object> keyValuePair = iterator.next();
                if (ArrayUtil.find(SKIPPED_PROPERTY_NAMES, (Name)keyValuePair.key) >= 0) continue;
                if (this.userProperties == null) {
                    this.userProperties = new ArrayList();
                }
                this.userProperties.add(keyValuePair.key);
                this.userProperties.add(keyValuePair.value);
            }
        }
    }

    protected void restoreUserProperties(Element element) {
        Document document;
        if (this.userProperties != null && (document = element.getDocument()) != null) {
            int n = this.userProperties.size();
            for (int i = 0; i < n; i += 2) {
                Name name = (Name)this.userProperties.get(i);
                Object object = this.userProperties.get(i + 1);
                document.putProperty(name, object);
            }
        }
    }

    @Override
    protected DocumentTypeDeclaration createDocumentTypeDeclaration() {
        if (this.firstPass) {
            return super.createDocumentTypeDeclaration();
        }
        return null;
    }

    @Override
    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        if (this.firstPass) {
            return null;
        }
        SubDocumentTypeSpec subDocumentTypeSpec = this.detectedDocTypeSpec.mainDocumentTypeSpec;
        InputSource inputSource = new InputSource(subDocumentTypeSpec.dtdSystemId.toExternalForm());
        inputSource.setPublicId(subDocumentTypeSpec.dtdPublicId);
        return inputSource;
    }

    @Override
    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        DTDAccelerator dTDAccelerator;
        if (this.firstPass && (dTDAccelerator = LoadDocument.getDTDAccelerator()) != null && "[dtd]".equals(string) && this.dtdSpec != null && this.dtdSpec.getInternalSubsetFlag() == 0) {
            Object object;
            URL uRL = null;
            String string5 = XMLCatalogs.getResolvedEntity(string2, string4);
            if (string5 != null) {
                try {
                    uRL = URLUtil.newURL(string5);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                try {
                    uRL = URLUtil.newURL(string4);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL == null && string3 != null) {
                    object = null;
                    try {
                        object = URLUtil.newURL(string3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (object != null) {
                        try {
                            uRL = URLUtil.newURL((URL)object, string4);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (uRL != null) {
                this.actualDTDSpec = new DTDSpec[1];
                this.actualDTDSpec[0] = this.dtdSpec;
                object = dTDAccelerator.get(uRL, this.actualDTDSpec, this.console);
                if (object != null) {
                    return object;
                }
                this.actualDTDSpec = null;
            }
        }
        return super.resolveEntity(string, string2, string3, string4);
    }

    @Override
    public void endDTD() throws SAXException {
        super.endDTD();
        if (this.actualDTDSpec != null) {
            assert (this.actualDTDSpec[0] != null);
            this.dtdSpec = this.actualDTDSpec[0];
            this.actualDTDSpec = null;
        }
    }

    public void documentLoaded(Document document) {
    }
}

