/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.load.Decl;
import com.xmlmind.xml.load.EntityDecl;
import com.xmlmind.xml.resolve.XMLCatalogs;
import java.net.MalformedURLException;
import java.net.URL;

public class ExternalEntityDecl
extends EntityDecl {
    public final String publicId;
    public final String systemId;
    public final URL baseURL;

    public ExternalEntityDecl(String string, String string2, String string3, URL uRL, String string4) {
        this(Decl.Type.EXTERNAL_ENTITY, string, string2, string3, uRL, string4);
    }

    protected ExternalEntityDecl(Decl.Type type, String string, String string2, String string3, URL uRL, String string4) {
        super(type, string, string4);
        this.publicId = string2;
        this.systemId = string3;
        this.baseURL = uRL;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("<!ENTITY ");
        if (this.name.charAt(0) == '%') {
            stringBuilder.append("% ");
            stringBuilder.append(this.name.substring(1));
        } else {
            stringBuilder.append(this.name);
        }
        stringBuilder.append(' ');
        ExternalEntityDecl.appendExternalId(this.publicId, this.systemId, stringBuilder);
        stringBuilder.append('>');
    }

    @Override
    public URL getURL() {
        URL uRL = null;
        String string = XMLCatalogs.getResolvedEntity(this.publicId, this.systemId);
        try {
            uRL = string != null ? URLUtil.createURL(string) : URLUtil.createURL(this.baseURL, this.systemId);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }
}

