/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.xml.load.CharEntities;
import com.xmlmind.xml.load.EntityDecl;
import com.xmlmind.xml.load.ExternalEntityDecl;
import com.xmlmind.xml.load.InternalEntityDecl;
import com.xmlmind.xml.load.UnparsedEntityDecl;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public final class Entities {
    private ArrayList<EntityDecl> entityList;
    private EntityDecl[] allEntities;
    private HashMap<String, EntityDecl> entityMap;
    private CharEntities charEntities;
    private static final EntityDecl[] NO_ENTITY_DECLS = new EntityDecl[0];

    public InternalEntityDecl internalEntityDecl(String string, String string2, String string3) {
        InternalEntityDecl internalEntityDecl = new InternalEntityDecl(string, string2, string3);
        if (!internalEntityDecl.isParameterEntity()) {
            this.add(internalEntityDecl);
        }
        return internalEntityDecl;
    }

    public ExternalEntityDecl externalEntityDecl(String string, String string2, String string3, URL uRL, String string4) {
        ExternalEntityDecl externalEntityDecl = new ExternalEntityDecl(string, string2, string3, uRL, string4);
        if (!externalEntityDecl.isParameterEntity()) {
            this.add(externalEntityDecl);
        }
        return externalEntityDecl;
    }

    public UnparsedEntityDecl unparsedEntityDecl(String string, String string2, String string3, URL uRL, String string4, String string5) {
        UnparsedEntityDecl unparsedEntityDecl = new UnparsedEntityDecl(string, string2, string3, uRL, string4, string5);
        this.add(unparsedEntityDecl);
        return unparsedEntityDecl;
    }

    private void add(EntityDecl entityDecl) {
        if (this.entityList == null) {
            this.entityList = new ArrayList();
            if (this.allEntities != null) {
                Entities.addAll(this.entityList, this.allEntities);
                this.allEntities = null;
            }
            this.entityMap = null;
            this.charEntities = null;
        }
        this.entityList.add(entityDecl);
    }

    private static final void addAll(ArrayList<EntityDecl> arrayList, EntityDecl[] entityDeclArray) {
        for (EntityDecl entityDecl : entityDeclArray) {
            arrayList.add(entityDecl);
        }
    }

    public EntityDecl[] getAll() {
        if (this.allEntities == null) {
            if (this.entityList != null) {
                this.allEntities = new EntityDecl[this.entityList.size()];
                this.entityList.toArray(this.allEntities);
                this.entityList = null;
            } else {
                this.allEntities = NO_ENTITY_DECLS;
            }
        }
        return this.allEntities;
    }

    public EntityDecl get(String string) {
        if (this.entityMap == null) {
            this.entityMap = new HashMap();
            for (EntityDecl entityDecl : this.getAll()) {
                this.entityMap.put(entityDecl.name, entityDecl);
            }
        }
        return this.entityMap.get(string);
    }

    public CharEntities getCharEntities() {
        if (this.charEntities == null) {
            this.charEntities = new CharEntities();
            for (EntityDecl entityDecl : this.getAll()) {
                if (!entityDecl.isCharEntity()) continue;
                this.charEntities.add(entityDecl.name, ((InternalEntityDecl)entityDecl).value.charAt(0));
            }
        }
        return this.charEntities;
    }
}

