/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.Console;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.load.DTDLoader;
import com.xmlmind.xml.load.DocumentTypeSpec;
import com.xmlmind.xml.load.LoadDocument;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.LoadErrorImpl;
import com.xmlmind.xml.load.Msg;
import com.xmlmind.xml.load.RNGLoader;
import com.xmlmind.xml.load.SubDocumentTypeCache;
import com.xmlmind.xml.load.SubDocumentTypeLoader;
import com.xmlmind.xml.load.SubDocumentTypeSpec;
import com.xmlmind.xml.load.WXSLoader;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.MultiDocumentType;
import com.xmlmind.xml.validate.SingleDocumentType;
import com.xmlmind.xml.validate.SubDocumentType;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;

public final class DocumentTypeLoader {
    private String rncEncoding = null;
    private LoadError[] errors = LoadErrorImpl.NO_ERRORS;
    private LoadError[] warnings = LoadErrorImpl.NO_ERRORS;

    public void setRNCEncoding(String string) {
        this.rncEncoding = string;
    }

    public String getRNCEncoding() {
        return this.rncEncoding;
    }

    public DocumentType loadDocumentType(URL uRL, Console console) throws IOException {
        SubDocumentTypeSpec subDocumentTypeSpec = this.toSubDocumentTypeSpec(uRL);
        return this.loadDocumentType(new DocumentTypeSpec(subDocumentTypeSpec), console);
    }

    private SubDocumentTypeSpec toSubDocumentTypeSpec(URL uRL) throws IOException {
        SubDocumentTypeSpec subDocumentTypeSpec = null;
        String string = URLUtil.getExtension(uRL);
        if (string != null) {
            if ("dtd".equals(string = string.toLowerCase())) {
                subDocumentTypeSpec = new SubDocumentTypeSpec(null, uRL);
            } else if ("xsd".equals(string) || "xs".equals(string) || "wxs".equals(string)) {
                subDocumentTypeSpec = new SubDocumentTypeSpec(uRL);
            } else if ("rng".equals(string)) {
                subDocumentTypeSpec = new SubDocumentTypeSpec(uRL, false, null);
            } else if ("rnc".equals(string)) {
                subDocumentTypeSpec = new SubDocumentTypeSpec(uRL, true, this.rncEncoding);
            }
        }
        if (subDocumentTypeSpec == null) {
            throw new IOException(Msg.msg("cannotGuessSchemaKindFromExt", uRL));
        }
        return subDocumentTypeSpec;
    }

    public DocumentType loadDocumentType(DocumentTypeSpec documentTypeSpec, Console console) throws IOException {
        this.errors = LoadErrorImpl.NO_ERRORS;
        this.warnings = LoadErrorImpl.NO_ERRORS;
        if (documentTypeSpec.documentType != null) {
            return documentTypeSpec.documentType;
        }
        ArrayList<LoadError> arrayList = new ArrayList<LoadError>();
        ArrayList<LoadError> arrayList2 = new ArrayList<LoadError>();
        SubDocumentTypeSpec subDocumentTypeSpec = documentTypeSpec.mainDocumentTypeSpec;
        SubDocumentTypeSpec[] subDocumentTypeSpecArray = documentTypeSpec.auxDocumentTypeSpecs;
        Namespace[] namespaceArray = documentTypeSpec.auxNamespaces;
        boolean bl = subDocumentTypeSpecArray != null && subDocumentTypeSpecArray.length > 0;
        SubDocumentType subDocumentType = this.loadSubDocumentType(subDocumentTypeSpec, bl, console, arrayList, arrayList2);
        if (subDocumentType == null) {
            this.compileErrors(arrayList, arrayList2);
            return null;
        }
        SubDocumentType[] subDocumentTypeArray = null;
        if (bl) {
            subDocumentTypeArray = new SubDocumentType[subDocumentTypeSpecArray.length];
            for (int i = 0; i < subDocumentTypeSpecArray.length; ++i) {
                subDocumentTypeArray[i] = this.loadSubDocumentType(subDocumentTypeSpecArray[i], false, console, arrayList, arrayList2);
                if (subDocumentTypeArray[i] != null) continue;
                this.compileErrors(arrayList, arrayList2);
                return null;
            }
        }
        this.compileErrors(arrayList, arrayList2);
        if (subDocumentTypeArray != null) {
            return new MultiDocumentType(subDocumentType, subDocumentTypeArray, namespaceArray);
        }
        return new SingleDocumentType(subDocumentType);
    }

    public LoadError[] getLoadErrors() {
        return this.errors;
    }

    public LoadError[] getLoadWarnings() {
        return this.warnings;
    }

    public DocumentType loadDocumentType(URL[] uRLArray, Console console) throws IOException {
        SubDocumentType[] subDocumentTypeArray;
        this.errors = LoadErrorImpl.NO_ERRORS;
        this.warnings = LoadErrorImpl.NO_ERRORS;
        int n = uRLArray.length;
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this.loadDocumentType(uRLArray[0], console);
            }
        }
        ArrayList<LoadError> arrayList = new ArrayList<LoadError>();
        ArrayList<LoadError> arrayList2 = new ArrayList<LoadError>();
        SubDocumentType[] subDocumentTypeArray2 = new SubDocumentType[n];
        for (int i = 0; i < n; ++i) {
            subDocumentTypeArray = this.toSubDocumentTypeSpec(uRLArray[i]);
            subDocumentTypeArray2[i] = this.loadSubDocumentType((SubDocumentTypeSpec)subDocumentTypeArray, i > 0, console, arrayList, arrayList2);
            if (subDocumentTypeArray2[i] != null) continue;
            this.compileErrors(arrayList, arrayList2);
            return null;
        }
        SubDocumentType subDocumentType = subDocumentTypeArray2[0];
        subDocumentTypeArray = new SubDocumentType[n - 1];
        Namespace[] namespaceArray = new Namespace[n - 1];
        for (int i = 1; i < n; ++i) {
            subDocumentTypeArray[i - 1] = subDocumentTypeArray2[i];
            Namespace[] namespaceArray2 = subDocumentTypeArray2[i].getTargetNamespaces();
            if (namespaceArray2 == null || namespaceArray2.length != 1 || namespaceArray2[0] == Namespace.NONE) {
                StringBuilder stringBuilder = new StringBuilder();
                if (namespaceArray2 != null) {
                    for (int j = 0; j < namespaceArray2.length; ++j) {
                        if (j > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append('\"');
                        stringBuilder.append(namespaceArray2[j].uri);
                        stringBuilder.append('\"');
                    }
                }
                throw new IOException(Msg.msg("cannotCreateMultiDocumentType", uRLArray[i], stringBuilder.toString()));
            }
            namespaceArray[i - 1] = namespaceArray2[0];
        }
        this.compileErrors(arrayList, arrayList2);
        return new MultiDocumentType(subDocumentType, subDocumentTypeArray, namespaceArray);
    }

    public SubDocumentType loadSubDocumentType(URL uRL, Console console) throws IOException {
        SubDocumentTypeSpec subDocumentTypeSpec = this.toSubDocumentTypeSpec(uRL);
        return this.loadSubDocumentType(subDocumentTypeSpec, console);
    }

    public SubDocumentType loadSubDocumentType(SubDocumentTypeSpec subDocumentTypeSpec, Console console) throws IOException {
        this.errors = LoadErrorImpl.NO_ERRORS;
        this.warnings = LoadErrorImpl.NO_ERRORS;
        ArrayList<LoadError> arrayList = new ArrayList<LoadError>();
        ArrayList<LoadError> arrayList2 = new ArrayList<LoadError>();
        SubDocumentType subDocumentType = this.loadSubDocumentType(subDocumentTypeSpec, false, console, arrayList, arrayList2);
        this.compileErrors(arrayList, arrayList2);
        return subDocumentType;
    }

    private SubDocumentType loadSubDocumentType(SubDocumentTypeSpec subDocumentTypeSpec, boolean bl, Console console, ArrayList<LoadError> arrayList, ArrayList<LoadError> arrayList2) throws IOException {
        if (subDocumentTypeSpec.subDocumentType != null) {
            return subDocumentTypeSpec.subDocumentType;
        }
        URL[] uRLArray = null;
        SubDocumentType subDocumentType = null;
        SubDocumentTypeCache subDocumentTypeCache = LoadDocument.getSubDocumentTypeCache();
        if (subDocumentTypeCache != null) {
            switch (subDocumentTypeSpec.schemaKind) {
                case DTD: {
                    URL uRL = null;
                    if (subDocumentTypeSpec.dtdSpec != null) {
                        if (subDocumentTypeSpec.dtdSpec.getInternalSubsetFlag() == 0 && subDocumentTypeSpec.dtdSpec.isGrammar()) {
                            uRL = subDocumentTypeSpec.dtdSpec.getExternalSubsetURL();
                        }
                    } else if (subDocumentTypeSpec.dtdSystemId != null) {
                        uRL = subDocumentTypeSpec.dtdSystemId;
                    }
                    if (uRL == null) break;
                    if (bl) {
                        uRL = URLUtil.setFragment(uRL, "lenient_ANY");
                    }
                    uRLArray = new URL[]{uRL};
                    break;
                }
                case WXS: {
                    if (subDocumentTypeSpec.wxsURL != null) {
                        uRLArray = new URL[]{subDocumentTypeSpec.wxsURL};
                        break;
                    }
                    if (subDocumentTypeSpec.wxsURLs == null) break;
                    uRLArray = new URL[subDocumentTypeSpec.wxsURLs.length];
                    for (int i = 0; i < subDocumentTypeSpec.wxsURLs.length; ++i) {
                        uRLArray[i] = subDocumentTypeSpec.wxsURLs[i].url;
                    }
                    break;
                }
                case RNG: {
                    if (subDocumentTypeSpec.rngURL == null) break;
                    uRLArray = new URL[]{subDocumentTypeSpec.rngURL};
                }
            }
            if (uRLArray != null) {
                subDocumentType = subDocumentTypeCache.fetchSubDocumentType(uRLArray, console);
            }
        }
        if (subDocumentType == null) {
            SubDocumentTypeLoader subDocumentTypeLoader;
            SubDocumentTypeLoader subDocumentTypeLoader2 = null;
            if (console != null) {
                if (subDocumentTypeSpec.dtdSpec != null) {
                    console.showMessage(Msg.msg("compilingDTD", subDocumentTypeSpec), Console.MessageType.INFO);
                } else {
                    console.showMessage(Msg.msg("loadSubDocumentType", subDocumentTypeSpec), Console.MessageType.INFO);
                }
            }
            switch (subDocumentTypeSpec.schemaKind) {
                case DTD: {
                    subDocumentTypeLoader = DocumentTypeLoader.createDTDLoader();
                    subDocumentTypeLoader.setLenientAny(bl);
                    subDocumentTypeLoader2 = subDocumentTypeLoader;
                    if (subDocumentTypeSpec.dtdSpec != null) {
                        subDocumentType = subDocumentTypeLoader.loadSubDocumentType(subDocumentTypeSpec.dtdSpec);
                        break;
                    }
                    if (subDocumentTypeSpec.dtdSystemId == null) break;
                    subDocumentType = subDocumentTypeLoader.loadSubDocumentType(subDocumentTypeSpec.dtdSystemId);
                    break;
                }
                case WXS: {
                    subDocumentTypeLoader2 = subDocumentTypeLoader = DocumentTypeLoader.createWXSLoader();
                    if (subDocumentTypeSpec.wxsURL != null) {
                        subDocumentType = subDocumentTypeLoader.loadSubDocumentType(subDocumentTypeSpec.wxsURL);
                        break;
                    }
                    if (subDocumentTypeSpec.wxsURLs == null) break;
                    subDocumentType = subDocumentTypeLoader.loadSubDocumentType(subDocumentTypeSpec.wxsURLs);
                    break;
                }
                case RNG: {
                    subDocumentTypeLoader2 = subDocumentTypeLoader = DocumentTypeLoader.createRNGLoader();
                    if (subDocumentTypeSpec.rngURL == null) break;
                    subDocumentType = subDocumentTypeLoader.loadSubDocumentType(subDocumentTypeSpec.rngURL, subDocumentTypeSpec.isCompactSyntax, subDocumentTypeSpec.compactSyntaxEncoding);
                }
            }
            if (subDocumentTypeLoader2 != null) {
                subDocumentTypeLoader = subDocumentTypeLoader2.getLoadErrors();
                if (((SubDocumentTypeLoader)subDocumentTypeLoader).length > 0) {
                    Collections.addAll(arrayList, subDocumentTypeLoader);
                }
                if (((SubDocumentTypeLoader)(subDocumentTypeLoader = subDocumentTypeLoader2.getLoadWarnings())).length > 0) {
                    Collections.addAll(arrayList2, subDocumentTypeLoader);
                }
            }
            if (subDocumentType == null) {
                uRLArray = null;
            }
            if (uRLArray != null) {
                subDocumentTypeCache.cacheSubDocumentType(uRLArray, subDocumentType, console);
            }
        }
        return subDocumentType;
    }

    private static final DTDLoader createDTDLoader() throws IOException {
        try {
            Class<?> clazz = Class.forName("com.xmlmind.xml.dtd.DTDLoaderImpl");
            return (DTDLoader)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IOException(ThrowableUtil.reason(throwable));
        }
    }

    private static final WXSLoader createWXSLoader() throws IOException {
        try {
            Class<?> clazz = Class.forName("com.xmlmind.xml.wxs.load.WXSLoaderImpl");
            return (WXSLoader)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IOException(ThrowableUtil.reason(throwable));
        }
    }

    private static final RNGLoader createRNGLoader() throws IOException {
        try {
            Class<?> clazz = Class.forName("com.xmlmind.xml.rng.validate.RNGLoaderImpl");
            return (RNGLoader)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IOException(ThrowableUtil.reason(throwable));
        }
    }

    private void compileErrors(ArrayList<LoadError> arrayList, ArrayList<LoadError> arrayList2) {
        int n = arrayList.size();
        if (n == 0) {
            this.errors = LoadErrorImpl.NO_ERRORS;
        } else {
            this.errors = new LoadError[n];
            arrayList.toArray(this.errors);
        }
        n = arrayList2.size();
        if (n == 0) {
            this.warnings = LoadErrorImpl.NO_ERRORS;
        } else {
            this.warnings = new LoadError[n];
            arrayList2.toArray(this.warnings);
        }
    }
}

