/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.load.DTDSpec;
import com.xmlmind.xml.load.DocumentTypeDetector;
import com.xmlmind.xml.load.DocumentTypeSpec;
import com.xmlmind.xml.load.NamespaceURLPair;
import com.xmlmind.xml.load.SubDocumentTypeSpec;
import com.xmlmind.xml.load.XMLModel;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.resolve.XMLCatalogs;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class DocumentTypeDetectorImpl
implements DocumentTypeDetector {
    public static DocumentTypeDetectorImpl INSTANCE = new DocumentTypeDetectorImpl();

    @Override
    public DocumentTypeSpec detectDocumentType(Element element, DTDSpec dTDSpec) {
        SubDocumentTypeSpec subDocumentTypeSpec = null;
        if (dTDSpec != null && dTDSpec.isGrammar()) {
            subDocumentTypeSpec = new SubDocumentTypeSpec(dTDSpec);
        } else {
            try {
                subDocumentTypeSpec = DocumentTypeDetectorImpl.useWXSLocation(element);
                if (subDocumentTypeSpec == null) {
                    subDocumentTypeSpec = DocumentTypeDetectorImpl.useXMLModel(element);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (subDocumentTypeSpec == null) {
            return null;
        }
        return new DocumentTypeSpec(subDocumentTypeSpec);
    }

    protected static final SubDocumentTypeSpec useWXSLocation(Element element) throws MalformedURLException {
        Object object;
        String string = element.getAttribute(Name.XSI_SCHEMA_LOCATION);
        String string2 = element.getAttribute(Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION);
        if (string == null && string2 == null) {
            return null;
        }
        URL uRL = element.getSourceURL();
        ArrayList<NamespaceURLPair> arrayList = new ArrayList<NamespaceURLPair>();
        if (string != null) {
            object = XMLText.splitList(string);
            int n = 2 * (((String[])object).length / 2);
            for (int i = 0; i < n; i += 2) {
                Object object2 = object[i];
                Object object3 = object[i + 1];
                boolean bl = false;
                Namespace namespace = Namespace.get((String)object2);
                for (int j = arrayList.size() - 1; j >= 0; --j) {
                    if (((NamespaceURLPair)arrayList.get((int)j)).namespace != namespace) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                URL uRL2 = XMLCatalogs.resolveURI((String)object3, uRL);
                arrayList.add(new NamespaceURLPair(namespace, uRL2));
            }
        }
        if (string2 != null) {
            object = XMLCatalogs.resolveURI(string2.trim(), uRL);
            arrayList.add(new NamespaceURLPair(Namespace.NONE, (URL)object));
        }
        object = new NamespaceURLPair[arrayList.size()];
        arrayList.toArray((T[])object);
        return new SubDocumentTypeSpec((NamespaceURLPair[])object);
    }

    protected static final SubDocumentTypeSpec useXMLModel(Element element) throws MalformedURLException {
        Document document = element.getDocument();
        if (document == null) {
            return null;
        }
        XMLModel[] xMLModelArray = null;
        try {
            xMLModelArray = XMLModel.parse(document);
        }
        catch (XMLModel.ParseException parseException) {
            // empty catch block
        }
        if (xMLModelArray == null || xMLModelArray.length == 0) {
            return null;
        }
        SubDocumentTypeSpec subDocumentTypeSpec = null;
        SubDocumentTypeSpec subDocumentTypeSpec2 = null;
        SubDocumentTypeSpec subDocumentTypeSpec3 = null;
        for (XMLModel xMLModel : xMLModelArray) {
            if (xMLModel.group != null) continue;
            boolean bl = "application/relax-ng-compact-syntax".equals(xMLModel.type);
            if (bl || xMLModel.schematypens == Namespace.RNG) {
                subDocumentTypeSpec = new SubDocumentTypeSpec(xMLModel.url, bl, xMLModel.charset);
            } else if (xMLModel.schematypens == Namespace.XSD) {
                subDocumentTypeSpec2 = new SubDocumentTypeSpec(xMLModel.url);
            } else if ("application/xml-dtd".equals(xMLModel.type)) {
                subDocumentTypeSpec3 = new SubDocumentTypeSpec(null, xMLModel.url);
            }
            if (subDocumentTypeSpec != null || subDocumentTypeSpec2 != null || subDocumentTypeSpec3 != null) continue;
            String string = xMLModel.href;
            if (string.endsWith(".rnc")) {
                subDocumentTypeSpec = new SubDocumentTypeSpec(xMLModel.url, true, xMLModel.charset);
                continue;
            }
            if (string.endsWith(".rng")) {
                subDocumentTypeSpec = new SubDocumentTypeSpec(xMLModel.url, false, null);
                continue;
            }
            if (string.endsWith(".xsd")) {
                subDocumentTypeSpec2 = new SubDocumentTypeSpec(xMLModel.url);
                continue;
            }
            if (!string.endsWith(".dtd")) continue;
            subDocumentTypeSpec3 = new SubDocumentTypeSpec(null, xMLModel.url);
        }
        if (subDocumentTypeSpec != null) {
            return subDocumentTypeSpec;
        }
        if (subDocumentTypeSpec2 != null) {
            return subDocumentTypeSpec2;
        }
        if (subDocumentTypeSpec3 != null) {
            return subDocumentTypeSpec3;
        }
        return null;
    }
}

