/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class CharEntities {
    public static final EntryComparator COMPARE_BY_ENTITY_NAME = new EntryComparator();
    private HashMap<String, Entry> nameToChar;
    private HashMap<Entry, Entry> charToName;
    private Entry probe = new Entry('\u0000', null);
    public static final String DOCBOOK_CHARS_LOCATION = "resource:com.xmlmind.xml.load.CharEntities/docbook_chars.properties";
    private static final CharEntities[] docBookInstance = new CharEntities[1];
    private static final CharEntities[] htmlInstance = new CharEntities[1];

    public CharEntities() {
        this.nameToChar = new HashMap();
        this.charToName = new HashMap();
    }

    public void add(String string, char c) {
        Entry entry = new Entry(c, string);
        this.nameToChar.put(string, entry);
        this.charToName.put(entry, entry);
    }

    public String getName(char c) {
        this.probe.c = c;
        Entry entry = this.charToName.get(this.probe);
        return entry == null ? null : entry.name;
    }

    public int getChar(String string) {
        Entry entry = this.nameToChar.get(string);
        return entry == null ? -1 : (int)entry.c;
    }

    public int size() {
        return this.nameToChar.size();
    }

    public Entry[] getAll() {
        Entry[] entryArray = new Entry[this.nameToChar.size()];
        this.nameToChar.values().toArray(entryArray);
        return entryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharEntities getDocBookInstance() {
        CharEntities[] charEntitiesArray = docBookInstance;
        synchronized (docBookInstance) {
            if (docBookInstance[0] == null) {
                CharEntities.docBookInstance[0] = new CharEntities();
                try {
                    CharEntities.load(CharEntities.class.getResource("docbook_chars.properties"), docBookInstance[0]);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return docBookInstance[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(URL uRL, CharEntities charEntities) throws IOException {
        Properties properties = new Properties();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());){
            properties.load(bufferedInputStream);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            charEntities.add((String)entry.getKey(), ((String)entry.getValue()).charAt(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharEntities getHTMLInstance() {
        CharEntities[] charEntitiesArray = htmlInstance;
        synchronized (htmlInstance) {
            if (htmlInstance[0] == null) {
                CharEntities.htmlInstance[0] = new CharEntities();
                try {
                    CharEntities.load(CharEntities.class.getResource("html_chars.properties"), htmlInstance[0]);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return htmlInstance[0];
        }
    }

    public static final class EntryComparator
    implements Comparator<Entry> {
        @Override
        public int compare(Entry entry, Entry entry2) {
            return entry.getName().compareTo(entry2.getName());
        }
    }

    public static final class Entry {
        private char c;
        private String name;

        public Entry(char c, String string) {
            this.c = c;
            this.name = string;
        }

        public char getChar() {
            return this.c;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.c;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            return ((Entry)object).c == this.c;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            stringBuilder.append("=\\u");
            String string = Integer.toHexString(this.c);
            for (int i = string.length(); i < 4; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            return stringBuilder.toString();
        }
    }
}

