/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.dtd;

import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.dtd.Msg;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.validate.AttributeDefaultValue;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.SchemaKind;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.ValidationError;
import com.xmlmind.xml.wxs.validate.ValidationErrors;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public final class DTD
extends Schema {
    public final String publicId;
    public final String systemId;
    public final URL baseURL;
    private Namespace[] targetNamespaces;

    public DTD(String string, String string2, URL uRL) {
        this.publicId = string;
        this.systemId = string2;
        this.baseURL = uRL;
        this.targetNamespaces = null;
    }

    @Override
    public ValidationError[] validate(Document document) {
        ValidationErrors validationErrors = new ValidationErrors();
        DTD.checkDocumentRoot(document, validationErrors);
        this.validate(document.getRootElement(), validationErrors);
        return validationErrors.toArray();
    }

    private static void checkDocumentRoot(Document document, ValidationErrors validationErrors) {
        Element element;
        String string;
        DocumentTypeDeclaration documentTypeDeclaration = document.getDocumentTypeDeclaration();
        if (documentTypeDeclaration != null && !(string = (element = document.getRootElement()).getName().format(false, element)).equals(documentTypeDeclaration.rootElementName)) {
            validationErrors.append(element, null, Msg.msg("rootNameMismatch", string, documentTypeDeclaration.rootElementName));
        }
    }

    @Override
    protected boolean checkIdentityConstraints(Element element, Element element2, ValidationErrors validationErrors) {
        return true;
    }

    @Override
    public Type findElementType(Element element, Element element2) {
        ElementDeclaration elementDeclaration = this.getElementDeclaration(element.getName());
        return elementDeclaration == null ? null : elementDeclaration.type;
    }

    @Override
    public ElementDeclaration findElementDeclaration(Element element, Element element2) {
        return this.getElementDeclaration(element.getName());
    }

    @Override
    public AttributeDeclaration findAttributeDeclaration(Element element, Element element2, Name name) {
        ElementDeclaration elementDeclaration = this.getElementDeclaration(element.getName());
        if (elementDeclaration == null) {
            return null;
        }
        return ((ComplexType)elementDeclaration.type).getAttributeDeclaration(name);
    }

    @Override
    public Type getElementLocalType(Element element) {
        return null;
    }

    @Override
    public SchemaKind getSchemaKind() {
        return SchemaKind.DTD;
    }

    @Override
    public Diagnostic[] checkDocument(Element element) {
        ValidationErrors validationErrors = new ValidationErrors();
        Document document = element.getDocument();
        if (document != null && element == document.getRootElement()) {
            DTD.checkDocumentRoot(document, validationErrors);
        }
        this.validate(element, validationErrors);
        return validationErrors.toArray();
    }

    @Override
    public Namespace[] getTargetNamespaces() {
        if (this.targetNamespaces == null) {
            ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
            Iterator<ElementDeclaration> iterator = this.getElementDeclarations();
            while (iterator.hasNext()) {
                ElementDeclaration elementDeclaration = iterator.next();
                Namespace namespace = elementDeclaration.name.namespace;
                if (arrayList.contains(namespace)) continue;
                arrayList.add(namespace);
            }
            this.targetNamespaces = new Namespace[arrayList.size()];
            arrayList.toArray(this.targetNamespaces);
        }
        return this.targetNamespaces;
    }

    @Override
    public String lookupElementAttribute(Element element, Element element2, Name name, AttributeDefaultValue attributeDefaultValue) {
        while (element != null) {
            String string = this.getElementAttribute(element, element2, name, attributeDefaultValue);
            if (string != null) {
                return string;
            }
            if (element == element2) break;
            element = element.getParentElement();
        }
        return null;
    }
}

