/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.doc;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.util.KeyValuePair;
import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.StringList;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentEvent;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.name.PrefixEntry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Element
extends Tree
implements NamespacePrefixMap {
    private Name name;
    private IdentityLinearHashtable<Name, String> attributes;
    private Document document;
    public static final Element[] EMPTY_LIST = new Element[0];
    public static final NoAttributeIterator NO_ATTRIBUTES = new NoAttributeIterator();
    private static final NoAttributeXNodeIterator NO_ATTRIBUTE_XNODES = new NoAttributeXNodeIterator();

    public Element(Name name) {
        this.name = name;
    }

    @Override
    public Node copy() {
        Element element = new Element(this.name);
        this.copyProperties(element);
        if (this.attributes != null) {
            element.attributes = (IdentityLinearHashtable)this.attributes.clone();
        }
        Node node = this.first;
        while (node != null) {
            element.appendChild(node.copy());
            node = node.next;
        }
        return element;
    }

    @Override
    public Node.Type getType() {
        return Node.Type.ELEMENT;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    public void setName(Name name) {
        if (name == this.name) {
            return;
        }
        Name name2 = this.name;
        this.name = name;
        Document document = this.getDocument();
        if (document != null) {
            document.fireNameChanged(this, DocumentEvent.Type.ELEMENT_NAME_CHANGED, name2);
        }
    }

    public Name getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.name.namespace;
    }

    public String getLocalName() {
        return this.name.localPart;
    }

    public String putAttribute(Name name, String string) {
        String string2;
        if (this.attributes == null) {
            this.attributes = new IdentityLinearHashtable();
        }
        if ((string2 = this.attributes.put(name, string)) == null) {
            if (this.document != null) {
                this.document.fireAttributeChanged(this, DocumentEvent.Type.ATTRIBUTE_ADDED, name, null, string);
            }
        } else if (!string.equals(string2) && this.document != null) {
            this.document.fireAttributeChanged(this, DocumentEvent.Type.ATTRIBUTE_CHANGED, name, string2, string);
        }
        return string2;
    }

    public String removeAttribute(Name name) {
        if (this.attributes == null) {
            return null;
        }
        String string = this.attributes.remove(name);
        if (this.attributes.size() == 0) {
            this.attributes = null;
        }
        if (string != null && this.document != null) {
            this.document.fireAttributeChanged(this, DocumentEvent.Type.ATTRIBUTE_REMOVED, name, string, null);
        }
        return string;
    }

    public void removeAllAttributes() {
        if (this.attributes == null) {
            return;
        }
        Name[] nameArray = new Name[this.attributes.size()];
        this.attributes.copyKeysInto((Name[])nameArray);
        for (int i = 0; i < nameArray.length; ++i) {
            this.removeAttribute(nameArray[i]);
        }
    }

    public boolean hasAttribute(Name name) {
        return this.attributes == null ? false : this.attributes.get(name) != null;
    }

    public String getAttribute(Name name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    public String lookupAttribute(Name name) {
        Tree tree = this;
        do {
            String string;
            if ((string = ((Element)tree).getAttribute(name)) == null) continue;
            return string;
        } while ((tree = tree.parent) != null && tree.getType() == Node.Type.ELEMENT);
        return null;
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public Attribute[] getAllAttributes() {
        if (this.attributes == null) {
            return Attribute.EMPTY_LIST;
        }
        Attribute[] attributeArray = new Attribute[this.attributes.size()];
        int n = 0;
        Iterator iterator = this.attributes.entries();
        while (iterator.hasNext()) {
            KeyValuePair keyValuePair = iterator.next();
            attributeArray[n++] = new Attribute(this, (Name)keyValuePair.key, (String)keyValuePair.value);
        }
        return attributeArray;
    }

    public Iterator<Attribute> getAttributes() {
        return this.getAttributes(false);
    }

    public Iterator<Attribute> getAttributes(boolean bl) {
        if (this.attributes == null) {
            return NO_ATTRIBUTES;
        }
        return new AttributeIterator(this, this.attributes, bl);
    }

    public boolean hasNoContent() {
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    break;
                }
                default: {
                    return false;
                }
            }
            node = node.next;
        }
        return true;
    }

    public int getContentChildCount() {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    break;
                }
                default: {
                    ++n;
                }
            }
            node = node.next;
        }
        return n;
    }

    public Node getFirstContentChild() {
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    break;
                }
                default: {
                    return node;
                }
            }
            node = node.next;
        }
        return null;
    }

    public Node getLastContentChild() {
        Node node = this.getLastChild();
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    break;
                }
                default: {
                    return node;
                }
            }
            node = node.previous;
        }
        return null;
    }

    public boolean hasChildElements() {
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: 
                case TEXT: {
                    break;
                }
                default: {
                    return true;
                }
            }
            node = node.next;
        }
        return false;
    }

    public int getChildElementCount() {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: 
                case TEXT: {
                    break;
                }
                default: {
                    ++n;
                }
            }
            node = node.next;
        }
        return n;
    }

    public Element getChildElement(int n) {
        int n2 = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: 
                case TEXT: {
                    break;
                }
                default: {
                    if (n2 == n) {
                        return (Element)node;
                    }
                    ++n2;
                }
            }
            node = node.next;
        }
        return null;
    }

    public int indexOfChildElement(Element element) {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: 
                case TEXT: {
                    break;
                }
                default: {
                    if (node == element) {
                        return n;
                    }
                    ++n;
                }
            }
            node = node.next;
        }
        return -1;
    }

    public Element[] getChildElements() {
        int n = this.getChildElementCount();
        if (n == 0) {
            return EMPTY_LIST;
        }
        Element[] elementArray = new Element[n];
        n = 0;
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: 
                case TEXT: {
                    break;
                }
                default: {
                    elementArray[n++] = (Element)node;
                }
            }
            node = node.next;
        }
        return elementArray;
    }

    public Element getFirstChildElement() {
        Node node = this.first;
        while (node != null) {
            if (node.getType() == Node.Type.ELEMENT) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public Element getLastChildElement() {
        Node node = this.getLastChild();
        while (node != null) {
            if (node.getType() == Node.Type.ELEMENT) {
                return (Element)node;
            }
            node = node.previous;
        }
        return null;
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    break;
                }
                case TEXT: {
                    stringBuilder.append(((Text)node).getTextChars());
                    break;
                }
                default: {
                    return null;
                }
            }
            node = node.next;
        }
        return stringBuilder.toString();
    }

    public boolean setText(String string) {
        Node node = this.first;
        while (node != null) {
            if (node.getType() == Node.Type.ELEMENT) {
                return false;
            }
            node = node.next;
        }
        boolean bl = false;
        node = this.first;
        while (node != null) {
            Node node2 = node.next;
            if (node.getType() == Node.Type.TEXT) {
                Text text = (Text)node;
                if (!bl) {
                    bl = true;
                    if (this.document != null) {
                        this.document.beginEdit();
                    }
                    text.setText(string);
                } else {
                    this.removeChild(text);
                }
            }
            node = node2;
        }
        if (bl && this.document != null) {
            this.document.endEdit();
        }
        return bl;
    }

    public void forceText(String string) {
        if (this.document != null) {
            this.document.beginEdit();
        }
        Node node = this.first;
        while (node != null) {
            Node node2 = node.next;
            this.removeChild(node);
            node = node2;
        }
        this.appendChild(new Text(string));
        if (this.document != null) {
            this.document.endEdit();
        }
    }

    public String getDescription(int n, Name ... nameArray) {
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        Element.getAllText(this, ' ', n, stringBuilder, nameArray);
        if (stringBuilder.length() > 0) {
            string = stringBuilder.toString();
            if ((string = XMLText.collapseWhiteSpace(string)).length() == 0) {
                string = null;
            }
        }
        return string;
    }

    public String getAllText(boolean bl, Name ... nameArray) {
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        Element.getAllText(this, '\u0000', Integer.MAX_VALUE, stringBuilder, nameArray);
        if (stringBuilder.length() > 0) {
            string = stringBuilder.toString();
            if (bl && (string = XMLText.collapseWhiteSpace(string)).length() == 0) {
                string = null;
            }
        }
        return string;
    }

    private static boolean getAllText(Element element, char c, int n, StringBuilder stringBuilder, Name ... nameArray) {
        Node node = element.first;
        while (node != null) {
            switch (node.getType()) {
                case TEXT: {
                    stringBuilder.append(((Text)node).getTextChars());
                    if (stringBuilder.length() < n) break;
                    stringBuilder.setLength(n);
                    return false;
                }
                case ELEMENT: {
                    Element element2 = (Element)node;
                    if (nameArray.length != 0 && ArrayUtil.find(nameArray, element2.getName()) >= 0) break;
                    if (c != '\u0000') {
                        stringBuilder.append(c);
                    }
                    if (Element.getAllText(element2, c, n, stringBuilder, nameArray)) break;
                    return false;
                }
            }
            node = node.next;
        }
        return true;
    }

    public int getIntAttribute(Name name, int n) {
        return this.getIntAttribute(name, Integer.MIN_VALUE, Integer.MAX_VALUE, n);
    }

    public int getIntAttribute(Name name, int n, int n2, int n3) {
        int n4 = n3;
        String string = this.getAttribute(name);
        if (string != null) {
            try {
                n4 = Integer.parseInt(string.trim());
                if (n4 < n || n4 > n2) {
                    n4 = n3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n4;
    }

    public double getDoubleAttribute(Name name, double d) {
        return this.getDoubleAttribute(name, -1.7976931348623157E308, Double.MAX_VALUE, d);
    }

    public double getDoubleAttribute(Name name, double d, double d2, double d3) {
        double d4 = d3;
        String string = this.getAttribute(name);
        if (string != null) {
            try {
                d4 = Double.parseDouble(string.trim());
                if (d4 < d || d4 > d2) {
                    d4 = d3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d4;
    }

    public boolean getBooleanAttribute(Name name, boolean bl) {
        boolean bl2 = bl;
        String string = this.getAttribute(name);
        if (string != null) {
            if ((string = string.trim()).equals("true")) {
                bl2 = true;
            } else if (string.equals("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public String getTokenAttribute(Name name, String string) {
        String string2 = this.getAttribute(name);
        string2 = string2 != null ? XMLText.collapseWhiteSpace(string2) : string;
        return string2;
    }

    public String getNmtokenAttribute(Name name, String string) {
        String string2 = this.getAttribute(name);
        if (string2 != null) {
            if (!XMLText.isNmtoken(string2 = XMLText.collapseWhiteSpace(string2))) {
                string2 = string;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    public String[] getListAttribute(Name name, String[] stringArray) {
        String[] stringArray2 = stringArray;
        String string = this.getAttribute(name);
        if (string != null) {
            stringArray2 = XMLText.splitList(string);
        }
        return stringArray2;
    }

    public String getAnyURIAttribute(Name name, String string) {
        String string2 = this.getAttribute(name);
        if (string2 != null) {
            string2 = string2.trim();
            try {
                new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                string2 = string;
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public NamespacePrefixMap namespacePrefixMap() {
        return this;
    }

    @Override
    public String attributeValue(Name name) {
        return this.getAttribute(name);
    }

    @Override
    public Iterator<XNode> attributes() {
        if (this.attributes == null) {
            return NO_ATTRIBUTE_XNODES;
        }
        return new AttributeXNodeIterator(this, this.attributes);
    }

    @Override
    public Namespace prefixToNamespace(String string) {
        NamespacePrefixMap namespacePrefixMap;
        if (this.document != null && (namespacePrefixMap = (NamespacePrefixMap)this.document.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY)) != null) {
            return namespacePrefixMap.prefixToNamespace(string);
        }
        return this.lookupNamespace(string);
    }

    public Namespace lookupNamespace(String string) {
        for (Tree tree = this; tree != null; tree = tree.getParent()) {
            PrefixEntry[] prefixEntryArray = (PrefixEntry[])tree.getProperty(Constants.DECLARED_PREFIXES_PROPERTY);
            if (prefixEntryArray == null) continue;
            int n = prefixEntryArray.length;
            for (int i = 0; i < n; ++i) {
                if (!string.equals(prefixEntryArray[i].prefix)) continue;
                return prefixEntryArray[i].namespace;
            }
        }
        return "xml".equals(string) ? Namespace.XML : null;
    }

    @Override
    public String[] namespaceToPrefixes(Namespace namespace) {
        NamespacePrefixMap namespacePrefixMap;
        if (this.document != null && (namespacePrefixMap = (NamespacePrefixMap)this.document.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY)) != null) {
            return namespacePrefixMap.namespaceToPrefixes(namespace);
        }
        return this.lookupPrefixes(namespace);
    }

    public String[] lookupPrefixes(Namespace namespace) {
        LinearHashtable<String, String> linearHashtable = null;
        String[] stringArray = null;
        for (Tree tree = this; tree != null; tree = tree.getParent()) {
            PrefixEntry[] prefixEntryArray = (PrefixEntry[])tree.getProperty(Constants.DECLARED_PREFIXES_PROPERTY);
            if (prefixEntryArray == null) continue;
            if (linearHashtable == null) {
                linearHashtable = new LinearHashtable<String, String>();
            }
            for (PrefixEntry prefixEntry : prefixEntryArray) {
                Namespace namespace2 = prefixEntry.namespace;
                String string = prefixEntry.prefix;
                if (namespace == namespace2 && !linearHashtable.containsKey(string)) {
                    stringArray = stringArray == null ? new String[]{string} : StringList.append(stringArray, string);
                }
                linearHashtable.put(string, string);
            }
        }
        if (stringArray == null && namespace == Namespace.XML) {
            return NamespacePrefixMap.XML_PREFIXES;
        }
        return stringArray;
    }

    @Override
    void setDocument(Document document, boolean bl, int n) {
        super.setDocument(document, bl, n);
        this.document = document;
    }

    private static final class AttributeXNodeIterator
    implements Iterator<XNode> {
        private Element element;
        private Iterator<KeyValuePair<Name, String>> pairs;

        public AttributeXNodeIterator(Element element, IdentityLinearHashtable<Name, String> identityLinearHashtable) {
            this.element = element;
            this.pairs = identityLinearHashtable.entries();
        }

        @Override
        public boolean hasNext() {
            return this.pairs.hasNext();
        }

        @Override
        public XNode next() {
            KeyValuePair<Name, String> keyValuePair = this.pairs.next();
            return new Attribute(this.element, (Name)keyValuePair.key, (String)keyValuePair.value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class NoAttributeXNodeIterator
    implements Iterator<XNode> {
        private NoAttributeXNodeIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public XNode next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class AttributeIterator
    implements Iterator<Attribute> {
        private Element element;
        private Iterator<KeyValuePair<Name, String>> pairs;
        private boolean copyAttributes;
        private Attribute attr = new Attribute();

        public AttributeIterator(Element element, IdentityLinearHashtable<Name, String> identityLinearHashtable, boolean bl) {
            this.element = element;
            this.pairs = identityLinearHashtable.entries();
            this.copyAttributes = bl;
        }

        @Override
        public boolean hasNext() {
            return this.pairs.hasNext();
        }

        @Override
        public Attribute next() {
            KeyValuePair<Name, String> keyValuePair = this.pairs.next();
            this.attr.element = this.element;
            this.attr.name = (Name)keyValuePair.key;
            this.attr.value = (String)keyValuePair.value;
            return this.copyAttributes ? this.attr.copy() : this.attr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class NoAttributeIterator
    implements Iterator<Attribute> {
        private NoAttributeIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Attribute next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

