/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.util.LocaleUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.whc.DOMUtil;
import com.xmlmind.whc.SearchInfo;
import com.xmlmind.whc.Stemmer;
import java.text.BreakIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

final class WordCollector {
    private HashMap<Locale, BreakIterator> localeToWordBreakIter = new HashMap();
    private Stack<String> langStack;

    public void collect(Element element, String string, int n, Stemmer stemmer, boolean bl, Map<String, SearchInfo.WordRef[]> map) {
        this.langStack = new Stack();
        this.langStack.push(string);
        this.doCollect(element, n, stemmer, bl, map);
        this.langStack.pop();
    }

    private void doCollect(Element element, int n, Stemmer stemmer, boolean bl, Map<String, SearchInfo.WordRef[]> map) {
        if (!"http://www.w3.org/1999/xhtml".equals(element.getNamespaceURI())) {
            return;
        }
        String string = DOMUtil.getXHTMLLang(element);
        if (string == null) {
            string = this.langStack.peek();
        }
        this.langStack.push(string);
        Locale locale = null;
        BreakIterator breakIterator = null;
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: {
                    String string2 = ((Text)node).getData();
                    if (XMLText.isXMLSpace(string2)) continue block4;
                    if (locale == null) {
                        locale = LocaleUtil.getLocale(string);
                        breakIterator = this.getWordBreakIter(locale);
                    }
                    WordCollector.collectWords(string2, locale, breakIterator, n, stemmer, bl, map);
                    continue block4;
                }
                case 1: {
                    this.doCollect((Element)node, n, stemmer, bl, map);
                }
            }
        }
        this.langStack.pop();
    }

    private BreakIterator getWordBreakIter(Locale locale) {
        BreakIterator breakIterator = this.localeToWordBreakIter.get(locale);
        if (breakIterator == null) {
            breakIterator = BreakIterator.getWordInstance(locale);
            this.localeToWordBreakIter.put(locale, breakIterator);
        }
        return breakIterator;
    }

    private static void collectWords(String string, Locale locale, BreakIterator breakIterator, int n, Stemmer stemmer, boolean bl, Map<String, SearchInfo.WordRef[]> map) {
        String string2;
        breakIterator.setText(string);
        if (!(stemmer == null || (string2 = locale.getLanguage()) != null && string2.regionMatches(true, 0, stemmer.langCode, 0, 2))) {
            stemmer = null;
        }
        StringBuilder stringBuilder = null;
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        while (n3 != -1) {
            String string3 = string.substring(n2, n3).toLowerCase(locale);
            int n4 = n3 - n2;
            char c = string.charAt(n2);
            switch (c) {
                case '+': 
                case '-': {
                    if (!bl) break;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(string3);
                    break;
                }
                default: {
                    if (Character.isDigit(c)) {
                        if (!bl) break;
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder();
                        }
                        stringBuilder.append(string3);
                        break;
                    }
                    if (c == '.' || c == ',' || c == '%' || c == '\u2030' || Character.getType(c) == 26) {
                        if (stringBuilder == null) break;
                        stringBuilder.append(string3);
                        break;
                    }
                    if (Character.isLetter(c)) {
                        if (stringBuilder != null) {
                            stringBuilder.append(string3);
                            break;
                        }
                        if (stringBuilder != null) {
                            WordCollector.collectNumber(stringBuilder, n, map);
                            stringBuilder = null;
                        }
                        if (n4 < 2) break;
                        if (stemmer != null) {
                            string3 = stemmer.stem(string3);
                        }
                        WordCollector.collectWord(string3, n, map);
                        break;
                    }
                    if (stringBuilder == null) break;
                    WordCollector.collectNumber(stringBuilder, n, map);
                    stringBuilder = null;
                }
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        if (stringBuilder != null) {
            WordCollector.collectNumber(stringBuilder, n, map);
        }
    }

    private static void collectNumber(StringBuilder stringBuilder, int n, Map<String, SearchInfo.WordRef[]> map) {
        char c;
        int n2;
        for (n2 = stringBuilder.length(); n2 > 0 && ((c = stringBuilder.charAt(n2 - 1)) == '.' || c == ',' || c == '+' || c == '-'); --n2) {
            stringBuilder.deleteCharAt(n2 - 1);
        }
        if (n2 > 0) {
            c = stringBuilder.charAt(0);
            if (!(c != '+' && c != '-' || n2 >= 2 && Character.isDigit(stringBuilder.charAt(1)))) {
                return;
            }
            WordCollector.collectWord(stringBuilder.toString(), n, map);
        }
    }

    private static void collectWord(String string, int n, Map<String, SearchInfo.WordRef[]> map) {
        SearchInfo.WordRef[] wordRefArray = map.get(string);
        if (wordRefArray == null) {
            map.put(string, new SearchInfo.WordRef[]{new SearchInfo.WordRef(n)});
        } else {
            int n2 = wordRefArray.length;
            if (wordRefArray[n2 - 1].pageIndex == n) {
                ++wordRefArray[n2 - 1].refCount;
            } else {
                SearchInfo.WordRef[] wordRefArray2 = new SearchInfo.WordRef[n2 + 1];
                System.arraycopy(wordRefArray, 0, wordRefArray2, 0, n2);
                wordRefArray2[n2] = new SearchInfo.WordRef(n);
                map.put(string, wordRefArray2);
            }
        }
    }
}

