/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.whc.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class SearchInfo {
    public ArrayList<String> baseNameList = new ArrayList();
    public ArrayList<String> titleList = new ArrayList();
    public HashMap<String, WordRef[]> wordMap = new HashMap();

    public String toJS(String string) {
        Object object;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append("\n\n");
        }
        stringBuilder.append("wh.search_stemmer = ");
        if (string != null) {
            stringBuilder.append("Snowball()");
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(";\n");
        stringBuilder.append("wh.search_baseNameList = [\n");
        int n2 = this.baseNameList.size() - 1;
        for (n = 0; n <= n2; ++n) {
            object = this.baseNameList.get(n);
            stringBuilder.append("/*");
            stringBuilder.append(Integer.toString(n));
            stringBuilder.append("*/ ");
            Util.appendJSString((String)object, stringBuilder);
            if (n != n2) {
                stringBuilder.append(",\n");
                continue;
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("];\n");
        stringBuilder.append("wh.search_titleList = [\n");
        n2 = this.titleList.size() - 1;
        for (n = 0; n <= n2; ++n) {
            object = this.titleList.get(n);
            stringBuilder.append("/*");
            stringBuilder.append(Integer.toString(n));
            stringBuilder.append("*/ ");
            Util.appendJSString((String)object, stringBuilder);
            if (n != n2) {
                stringBuilder.append(",\n");
                continue;
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("];\n");
        n = 0;
        n2 = this.wordMap.size() - 1;
        stringBuilder.append("// ");
        stringBuilder.append(Integer.toString(n2 + 1));
        stringBuilder.append(" words.\n");
        stringBuilder.append("wh.search_wordMap= {\n");
        for (Map.Entry entry : this.wordMap.entrySet()) {
            String string2 = (String)entry.getKey();
            Object[] objectArray = (WordRef[])entry.getValue();
            Util.appendJSString(string2, stringBuilder);
            stringBuilder.append(": [");
            Arrays.sort(objectArray);
            SearchInfo.appendWordRefs((WordRef[])objectArray, stringBuilder);
            if (n != n2) {
                stringBuilder.append("],\n");
            } else {
                stringBuilder.append("]\n");
            }
            ++n;
        }
        stringBuilder.append("};\n");
        return stringBuilder.toString();
    }

    private static void appendWordRefs(WordRef[] wordRefArray, StringBuilder stringBuilder) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl = true;
        int n4 = wordRefArray.length;
        for (int i = 0; i < n4; ++i) {
            WordRef wordRef = wordRefArray[i];
            if (wordRef.refCount == n3) {
                n2 = i;
                continue;
            }
            if (n >= 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                SearchInfo.appendItem(wordRefArray, n, n2, stringBuilder);
            }
            n = n2 = i;
            n3 = wordRef.refCount;
        }
        if (n >= 0) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            SearchInfo.appendItem(wordRefArray, n, n2, stringBuilder);
        }
    }

    private static void appendItem(WordRef[] wordRefArray, int n, int n2, StringBuilder stringBuilder) {
        if (n == n2) {
            stringBuilder.append(Integer.toString(wordRefArray[n].pageIndex));
        } else {
            stringBuilder.append('[');
            for (int i = n; i <= n2; ++i) {
                if (i > n) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(Integer.toString(wordRefArray[i].pageIndex));
            }
            stringBuilder.append(']');
        }
    }

    public static final class WordRef
    implements Comparable<WordRef> {
        public final int pageIndex;
        public int refCount;

        public WordRef(int n) {
            this.pageIndex = n;
            this.refCount = 1;
        }

        @Override
        public int compareTo(WordRef wordRef) {
            int n = wordRef.refCount - this.refCount;
            if (n == 0) {
                return this.pageIndex - wordRef.pageIndex;
            }
            return n;
        }
    }
}

