/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.util.XMLText;
import com.xmlmind.util.XMLUtil;
import com.xmlmind.whc.NamespaceHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class SaveDocument {
    private SaveDocument() {
    }

    public static void saveXHTML(Document document, File file) throws IOException {
        SaveDocument.saveXHTML(document, file, "UTF-8", false);
    }

    public static void saveXHTML(Document document, File file, String string) throws IOException {
        SaveDocument.saveXHTML(document, file, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXHTML(Document document, File file, String string, boolean bl) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));){
            SaveDocument.saveXHTML(document, bl, bufferedWriter);
            ((Writer)bufferedWriter).flush();
        }
    }

    private static void saveXHTML(Document document, boolean bl, Writer writer) throws IOException {
        DocumentType documentType = document.getDoctype();
        if (documentType != null) {
            SaveDocument.saveDocType(documentType, writer);
        }
        NamespaceHelper namespaceHelper = new NamespaceHelper();
        namespaceHelper.pushContext();
        writer.write("<html xmlns=\"");
        writer.write("http://www.w3.org/1999/xhtml");
        writer.write("\"");
        Element element = document.getDocumentElement();
        SaveDocument.saveAttributes(element, namespaceHelper, writer);
        writer.write(62);
        SaveDocument.saveContents(element, bl, namespaceHelper, writer);
        writer.write("</html>");
        namespaceHelper.popContext();
    }

    private static void saveDocType(DocumentType documentType, Writer writer) throws IOException {
        String string;
        writer.write("<!DOCTYPE ");
        writer.write(documentType.getName());
        String string2 = documentType.getSystemId();
        if (string2 != null) {
            string = documentType.getPublicId();
            if (string == null) {
                writer.write(" SYSTEM ");
            } else {
                writer.write(" PUBLIC \"");
                writer.write(string);
                writer.write("\"\n");
            }
            int n = string2.indexOf(34) < 0 ? 34 : 39;
            writer.write(n);
            writer.write(string2);
            writer.write(n);
        }
        if ((string = documentType.getInternalSubset()) != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (string != null) {
            writer.write(" [\n");
            writer.write(string);
            writer.write("\n]");
        }
        writer.write(">\n");
    }

    private static void saveContents(Node node, boolean bl, NamespaceHelper namespaceHelper, Writer writer) throws IOException {
        block5: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 3: {
                    NamespaceHelper.saveText(((Text)node2).getData(), writer);
                    continue block5;
                }
                case 7: {
                    if (!bl) continue block5;
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node2;
                    String string = processingInstruction.getData();
                    writer.write("<?");
                    writer.write(processingInstruction.getTarget());
                    if (string.length() > 0) {
                        writer.write(32);
                        writer.write(string);
                    }
                    writer.write("?>");
                    continue block5;
                }
                case 1: {
                    SaveDocument.saveElement((Element)node2, bl, namespaceHelper, writer);
                }
            }
        }
    }

    private static void saveElement(Element element, boolean bl, NamespaceHelper namespaceHelper, Writer writer) throws IOException {
        namespaceHelper.pushContext();
        writer.write(60);
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        String string3 = namespaceHelper.getQName(string, string2, element.getPrefix(), false);
        writer.write(string3);
        SaveDocument.saveAttributes(element, namespaceHelper, writer);
        if (XMLUtil.HTML_NO_END_TAG.contains(string3)) {
            writer.write(" />");
        } else {
            writer.write(62);
            if (("script".equals(string2) || "style".equals(string2)) && "http://www.w3.org/1999/xhtml".equals(string)) {
                SaveDocument.saveCDATA(element.getTextContent(), writer);
            } else {
                SaveDocument.saveContents(element, bl, namespaceHelper, writer);
            }
            writer.write("</");
            writer.write(string3);
            writer.write(62);
        }
        namespaceHelper.popContext();
    }

    private static void saveAttributes(Element element, NamespaceHelper namespaceHelper, Writer writer) throws IOException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            writer.write(32);
            String string = namespaceHelper.getQName(attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix(), true);
            writer.write(string);
            writer.write("=\"");
            NamespaceHelper.saveText(attr.getValue(), writer);
            writer.write(34);
        }
        namespaceHelper.declarePrefixes(writer);
    }

    private static void saveCDATA(String string, Writer writer) throws IOException {
        if (string != null && string.length() > 0) {
            if (XMLText.isXMLSpace(string)) {
                writer.write(string);
            } else {
                writer.write("/*<![CDATA[*/");
                writer.write(string);
                writer.write("/*]]>*/");
            }
        }
    }

    public static String xhtmlToString(Node node) {
        return SaveDocument.xhtmlToString(node, false);
    }

    public static String xhtmlToString(Node node, boolean bl) {
        NamespaceHelper namespaceHelper = new NamespaceHelper();
        namespaceHelper.pushContext();
        StringWriter stringWriter = new StringWriter();
        try {
            SaveDocument.saveContents(node, bl, namespaceHelper, stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        namespaceHelper.popContext();
        return stringWriter.toString();
    }
}

