/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.whc;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.whc.DOMUtil;
import com.xmlmind.whc.IndexAnchor;
import com.xmlmind.whc.IndexRef;
import com.xmlmind.whc.IndexTerm;
import com.xmlmind.whc.Msg;
import com.xmlmind.whc.SaveDocument;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class IndexEntry {
    public final IndexTerm term;
    public final String id;
    public IndexRef[] seeList;
    public IndexAnchor[] anchorList;
    public IndexRef[] seeAlsoList;
    public IndexEntry[] entryList;

    public static IndexEntry parse(Element element) throws IllegalArgumentException {
        IndexEntry indexEntry = null;
        String string = DOMUtil.getAttribute(element, "http://www.w3.org/XML/1998/namespace", "id");
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2;
            String string3;
            Object object;
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string4 = node.getLocalName();
            if ("term".equals(string4)) {
                if (indexEntry != null) {
                    throw new IllegalArgumentException("");
                }
                object = XMLText.collapseWhiteSpace(node.getTextContent());
                if (((String)object).length() == 0) {
                    throw new IllegalArgumentException(Msg.msg("voidElement", "term"));
                }
                string3 = SaveDocument.xhtmlToString(node);
                string2 = DOMUtil.getAttribute(element2, null, "sortAs");
                if (string2 != null) {
                    string2 = XMLText.collapseWhiteSpace(string2);
                }
                indexEntry = new IndexEntry(new IndexTerm(string3, (String)object, string2), string);
                continue;
            }
            if ("see".equals(string4) || "seeAlso".equals(string4)) {
                IndexEntry.checkEntry(indexEntry);
                object = DOMUtil.getAttribute(element2, null, "ref");
                string3 = XMLText.collapseWhiteSpace(node.getTextContent());
                string2 = null;
                if (string3.length() > 0) {
                    string2 = SaveDocument.xhtmlToString(node);
                } else {
                    string3 = null;
                }
                if (object == null && string3 == null) {
                    throw new IllegalArgumentException(Msg.msg("voidElement", string4));
                }
                IndexRef indexRef = new IndexRef((String)object, string2, string3);
                if ("see".equals(string4)) {
                    indexEntry.addSee(indexRef);
                    continue;
                }
                indexEntry.addSeeAlso(indexRef);
                continue;
            }
            if ("anchor".equals(string4)) {
                IndexEntry.checkEntry(indexEntry);
                object = IndexEntry.getRequiredAttribute(element2, "href");
                string3 = DOMUtil.getAttribute(element2, null, "href2");
                indexEntry.addAnchor(new IndexAnchor((String)object, string3));
                continue;
            }
            if (!"entry".equals(string4)) continue;
            IndexEntry.checkEntry(indexEntry);
            object = IndexEntry.parse(element2);
            super.addEntry((IndexEntry)object);
        }
        IndexEntry.checkEntry(indexEntry);
        return indexEntry;
    }

    private static void checkEntry(IndexEntry indexEntry) throws IllegalArgumentException {
        if (indexEntry == null) {
            throw new IllegalArgumentException("");
        }
    }

    private static String getRequiredAttribute(Element element, String string) throws IllegalArgumentException {
        String string2 = DOMUtil.getAttribute(element, null, string);
        if (string2 == null) {
            throw new IllegalArgumentException(Msg.msg("missingAttribute", string));
        }
        return string2;
    }

    private IndexEntry(IndexTerm indexTerm, String string) {
        this.term = indexTerm;
        this.id = string;
    }

    private void addSee(IndexRef indexRef) {
        if (this.seeList == null) {
            this.seeList = new IndexRef[]{indexRef};
        } else if (ArrayUtil.indexOf(this.seeList, indexRef) < 0) {
            this.seeList = ArrayUtil.append(this.seeList, indexRef);
        }
    }

    private void addAnchor(IndexAnchor indexAnchor) {
        if (this.anchorList == null) {
            this.anchorList = new IndexAnchor[]{indexAnchor};
        } else if (ArrayUtil.indexOf(this.anchorList, indexAnchor) < 0) {
            this.anchorList = ArrayUtil.append(this.anchorList, indexAnchor);
        }
    }

    private void addSeeAlso(IndexRef indexRef) {
        if (this.seeAlsoList == null) {
            this.seeAlsoList = new IndexRef[]{indexRef};
        } else if (ArrayUtil.indexOf(this.seeAlsoList, indexRef) < 0) {
            this.seeAlsoList = ArrayUtil.append(this.seeAlsoList, indexRef);
        }
    }

    private void addEntry(IndexEntry indexEntry) {
        this.entryList = this.entryList == null ? new IndexEntry[]{indexEntry} : ArrayUtil.append(this.entryList, indexEntry);
    }

    public void merge(IndexEntry indexEntry, boolean bl, Locale locale) {
        IndexEntry[] indexEntryArray;
        Object[] objectArray;
        IndexRef[] indexRefArray = indexEntry.seeList;
        if (indexRefArray != null) {
            objectArray = indexRefArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                this.addSee((IndexRef)object);
            }
        }
        if ((objectArray = indexEntry.anchorList) != null) {
            for (Object object : objectArray) {
                this.addAnchor((IndexAnchor)object);
            }
        }
        if ((indexRefArray = indexEntry.seeAlsoList) != null) {
            for (IndexRef indexRef : indexRefArray) {
                this.addSeeAlso(indexRef);
            }
        }
        if ((indexEntryArray = indexEntry.entryList) != null) {
            IndexEntry[] indexEntryArray2 = this.entryList;
            if (indexEntryArray2 == null) {
                this.entryList = indexEntryArray;
            } else {
                for (IndexEntry indexEntry2 : indexEntryArray) {
                    String string = indexEntry2.term.text;
                    if (!bl) {
                        string = string.toLowerCase(locale);
                    }
                    IndexEntry indexEntry3 = null;
                    for (IndexEntry indexEntry4 : indexEntryArray2) {
                        String string2 = indexEntry4.term.text;
                        if (!bl) {
                            string2 = string2.toLowerCase(locale);
                        }
                        if (!string.equals(string2)) continue;
                        indexEntry3 = indexEntry4;
                        break;
                    }
                    if (indexEntry3 == null) {
                        this.addEntry(indexEntry2);
                        continue;
                    }
                    indexEntry3.merge(indexEntry2, bl, locale);
                }
            }
        }
    }
}

